/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.validation;

import com.atlassian.plugin.osgi.spring.DefaultSpringContainerAccessor;
import jakarta.validation.ConstraintValidator;
import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.validation.beanvalidation.SpringConstraintValidatorFactory;

@Component(value="constraintValidatorFactory")
public class PluginAwareConstraintValidatorFactory
extends SpringConstraintValidatorFactory {
    private static final Logger log = LoggerFactory.getLogger(PluginAwareConstraintValidatorFactory.class);

    @Autowired
    public PluginAwareConstraintValidatorFactory(AutowireCapableBeanFactory beanFactory) {
        super(beanFactory);
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        if (key.getClassLoader() instanceof BundleReference) {
            try {
                ConstraintValidator instance = (ConstraintValidator)this.getInstanceFromBundle(((BundleReference)key.getClassLoader()).getBundle(), key);
                if (instance != null) {
                    return (T)instance;
                }
            }
            catch (Exception e) {
                log.warn("Failed to create ConstraintValidator from OSGi Bundle. Falling back to default", (Throwable)e);
            }
        }
        return (T)super.getInstance(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getInstanceFromBundle(Bundle bundle, Class<T> clazz) {
        BundleContext context = bundle.getBundleContext();
        String osgiFilter = "(Bundle-SymbolicName=" + bundle.getSymbolicName() + ")";
        try {
            Collection references = context.getServiceReferences(ApplicationContext.class, osgiFilter);
            if (references.isEmpty()) return null;
            ServiceReference reference = (ServiceReference)references.iterator().next();
            Object applicationContext = context.getService(reference);
            try {
                Object object = new DefaultSpringContainerAccessor(applicationContext).createBean(clazz);
                return (T)object;
            }
            finally {
                context.ungetService(reference);
            }
        }
        catch (InvalidSyntaxException e) {
            log.warn("Could not access Spring context for bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
        }
        return null;
    }
}

