/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.config;

import com.atlassian.audit.core.spi.service.AuditMethodProvider;
import com.atlassian.audit.core.spi.service.BaseUrlProvider;
import com.atlassian.audit.core.spi.service.ClusterNodeProvider;
import com.atlassian.audit.core.spi.service.CurrentUserProvider;
import com.atlassian.audit.core.spi.service.IpAddressProvider;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.lighthouse.config.imports.CoreImportServiceConfig;
import com.atlassian.lighthouse.config.imports.JiraImportServiceConfig;
import com.atlassian.lighthouse.config.system.DefaultSystemPropertyProvider;
import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.config.system.SystemPropertyProvider;
import com.atlassian.lighthouse.database.transactions.JiraTransactionHandler;
import com.atlassian.lighthouse.database.transactions.TransactionHandler;
import com.atlassian.lighthouse.eventlisteners.AllowListModificationListener;
import com.atlassian.lighthouse.eventlisteners.UserDirectoryModificationListener;
import com.atlassian.lighthouse.matchers.audit.log.GlobalAuditingMatchers;
import com.atlassian.lighthouse.matchers.audit.log.JiraAuditingMatchers;
import com.atlassian.lighthouse.matchers.audit.log.SharedAuditingMatchers;
import com.atlassian.lighthouse.matchers.audit.log.securitygroup.JiraUserAddedSecurityGroupAuditMatcher;
import com.atlassian.lighthouse.matchers.audit.log.securitygroup.JiraUserDeletedSecurityGroupAuditMatcher;
import com.atlassian.lighthouse.notification.generators.DefaultEmailFactory;
import com.atlassian.lighthouse.notification.mail.JiraMailService;
import com.atlassian.lighthouse.notification.mail.MailServiceInterface;
import com.atlassian.lighthouse.notification.template.MailTemplateRenderer;
import com.atlassian.lighthouse.security.detector.AdminAnonymizedDetector;
import com.atlassian.lighthouse.security.detector.AdminChangedValuesDetector;
import com.atlassian.lighthouse.security.detector.AdminPasswordDetector;
import com.atlassian.lighthouse.security.detector.AdminUsernameDetector;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.ChangedValuesDetector;
import com.atlassian.lighthouse.security.detector.CommonDetectionFunctions;
import com.atlassian.lighthouse.security.detector.DefaultThreatDetector;
import com.atlassian.lighthouse.security.detector.GroupPermissionChangedDetector;
import com.atlassian.lighthouse.security.detector.ThreatDetector;
import com.atlassian.lighthouse.security.detector.Without2SVDetector;
import com.atlassian.lighthouse.security.service.AlertDeactivationService;
import com.atlassian.lighthouse.security.service.AlertService;
import com.atlassian.lighthouse.service.DefaultThreatEventEntityFactory;
import com.atlassian.lighthouse.service.ThreatEventEntityFactory;
import com.atlassian.lighthouse.service.event.AllowListModificationHandler;
import com.atlassian.lighthouse.service.event.EventToThreatsService;
import com.atlassian.lighthouse.service.group.JiraGroupManagerService;
import com.atlassian.lighthouse.service.group.cache.CachedAdminGroupService;
import com.atlassian.lighthouse.service.group.cache.JiraCachedAdminGroupUpdater;
import com.atlassian.lighthouse.service.group.supplier.JiraAdminGroupNamesFinder;
import com.atlassian.lighthouse.service.user.DefaultUserDetailsFinder;
import com.atlassian.lighthouse.service.user.JiraSecurityUserService;
import com.atlassian.lighthouse.service.user.JiraUserManagerService;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import com.atlassian.lighthouse.service.user.cache.CachedAdminUserService;
import com.atlassian.lighthouse.service.user.cache.JiraCachedAdminUserUpdater;
import com.atlassian.lighthouse.service.user.supplier.JiraAdminUsernamesFinder;
import com.atlassian.lighthouse.usage.service.JiraUserReferenceProvider;
import com.atlassian.lighthouse.usage.service.UserReferenceProvider;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CoreImportServiceConfig.class, JiraImportServiceConfig.class})
@Conditional(value={JiraOnly.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010 \u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0017J \u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J$\u0010%\u001a\u00020&2\b\b\u0001\u0010\"\u001a\u00020\u001a2\b\b\u0001\u0010'\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0017J \u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u001a\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\b\b\u0001\u00102\u001a\u00020)H\u0017JR\u00103\u001a\b\u0012\u0004\u0012\u000205042\b\b\u0001\u0010\"\u001a\u00020\u001a2\b\b\u0001\u0010'\u001a\u00020$2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010:\u001a\u00020;2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0017J\u0018\u00108\u001a\u0002092\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010:\u001a\u00020;H\u0017J\u0010\u0010@\u001a\u00020A2\u0006\u0010:\u001a\u00020BH\u0017J0\u0010C\u001a\u00020D2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010:\u001a\u00020;2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\b\u0010E\u001a\u00020FH\u0017J8\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020DH\u0017J\u0018\u0010T\u001a\u00020U2\u0006\u0010:\u001a\u00020;2\u0006\u0010V\u001a\u00020WH\u0017J(\u0010X\u001a\u00020Y2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006["}, d2={"Lcom/atlassian/lighthouse/config/JiraBeanConfig;", "", "()V", "allowListModificationHandler", "Lcom/atlassian/lighthouse/service/event/AllowListModificationHandler;", "alertService", "Lcom/atlassian/lighthouse/security/service/AlertService;", "eventToThreatsService", "Lcom/atlassian/lighthouse/service/event/EventToThreatsService;", "allowListModificationListener", "Lcom/atlassian/lighthouse/eventlisteners/AllowListModificationListener;", "alertDeactivationService", "Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "jiraAdminGroupSupplier", "Lcom/atlassian/lighthouse/service/group/supplier/JiraAdminGroupNamesFinder;", "globalPermissionManager", "Lcom/atlassian/jira/security/GlobalPermissionManager;", "jiraAdminUsernamesFinder", "Lcom/atlassian/lighthouse/service/user/supplier/JiraAdminUsernamesFinder;", "groupManager", "Lcom/atlassian/jira/security/groups/GroupManager;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "jiraCachedAdminGroupService", "Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;", "jiraAdminGroupNamesFinder", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "jiraCachedAdminGroupUpdater", "Lcom/atlassian/lighthouse/service/group/cache/JiraCachedAdminGroupUpdater;", "cachedAdminGroupService", "jiraCachedAdminUserService", "Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;", "jiraCachedAdminUserUpdater", "Lcom/atlassian/lighthouse/service/user/cache/JiraCachedAdminUserUpdater;", "cachedAdminUserService", "jiraEmailFactory", "Lcom/atlassian/lighthouse/notification/generators/DefaultEmailFactory;", "mailTemplateRenderer", "Lcom/atlassian/lighthouse/notification/template/MailTemplateRenderer;", "jiraGroupManagerService", "Lcom/atlassian/lighthouse/service/group/JiraGroupManagerService;", "jiraMailService", "Lcom/atlassian/lighthouse/notification/mail/MailServiceInterface;", "mailQueue", "Lcom/atlassian/mail/queue/MailQueue;", "defaultEmailFactory", "jiraThreatDetectors", "", "Lcom/atlassian/lighthouse/security/detector/ThreatDetector;", "commonDetectionFunctions", "Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "jiraUserManagerService", "Lcom/atlassian/lighthouse/service/user/JiraUserManagerService;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "jiraTransactionHandler", "Lcom/atlassian/lighthouse/database/transactions/TransactionHandler;", "databaseAccessor", "Lcom/atlassian/jira/database/DatabaseAccessor;", "jiraUserReferenceProvider", "Lcom/atlassian/lighthouse/usage/service/UserReferenceProvider;", "Lcom/atlassian/jira/user/util/UserManager;", "jiraUserService", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "systemPropertyProvider", "Lcom/atlassian/lighthouse/config/system/SystemPropertyProvider;", "threatEventEntityFactory", "Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;", "auditMethodProvider", "Lcom/atlassian/audit/core/spi/service/AuditMethodProvider;", "baseUrlProvider", "Lcom/atlassian/audit/core/spi/service/BaseUrlProvider;", "clusterNodeProvider", "Lcom/atlassian/audit/core/spi/service/ClusterNodeProvider;", "currentUserProvider", "Lcom/atlassian/audit/core/spi/service/CurrentUserProvider;", "ipAddressProvider", "Lcom/atlassian/audit/core/spi/service/IpAddressProvider;", "securityUserService", "userDetailsFinder", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "userDirectoryModificationListener", "Lcom/atlassian/lighthouse/eventlisteners/UserDirectoryModificationListener;", "Companion", "atlassian-lighthouse-core"})
public class JiraBeanConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String JIRA_ADMINISTRATOR_PERMISSION_NAME = "Jira Administrators";
    @NotNull
    public static final String JIRA_SYSTEM_ADMINISTRATOR_PERMISSION_NAME = "Jira System Administrators";

    @Bean
    @NotNull
    public AllowListModificationHandler allowListModificationHandler(@NotNull AlertService alertService, @NotNull EventToThreatsService eventToThreatsService) {
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(eventToThreatsService, "eventToThreatsService");
        return new AllowListModificationHandler(alertService, eventToThreatsService);
    }

    @Bean
    @NotNull
    public AllowListModificationListener allowListModificationListener(@NotNull AlertDeactivationService alertDeactivationService, @NotNull AllowListModificationHandler allowListModificationHandler, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(allowListModificationHandler, "allowListModificationHandler");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        return new AllowListModificationListener(alertDeactivationService, allowListModificationHandler, eventPublisher);
    }

    @Bean
    @NotNull
    public ThreatEventEntityFactory threatEventEntityFactory(@NotNull AuditMethodProvider auditMethodProvider, @NotNull BaseUrlProvider baseUrlProvider, @NotNull ClusterNodeProvider clusterNodeProvider, @NotNull CurrentUserProvider currentUserProvider, @NotNull IpAddressProvider ipAddressProvider, @NotNull SecurityUserService securityUserService) {
        Intrinsics.checkNotNullParameter(auditMethodProvider, "auditMethodProvider");
        Intrinsics.checkNotNullParameter(baseUrlProvider, "baseUrlProvider");
        Intrinsics.checkNotNullParameter(clusterNodeProvider, "clusterNodeProvider");
        Intrinsics.checkNotNullParameter(currentUserProvider, "currentUserProvider");
        Intrinsics.checkNotNullParameter(ipAddressProvider, "ipAddressProvider");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        return new DefaultThreatEventEntityFactory(auditMethodProvider, baseUrlProvider, clusterNodeProvider, currentUserProvider, ipAddressProvider, securityUserService, null, 64, null);
    }

    @Bean(value={"jiraCachedAdminGroupService"})
    @NotNull
    public CachedAdminGroupService jiraCachedAdminGroupService(@NotNull JiraAdminGroupNamesFinder jiraAdminGroupNamesFinder, @NotNull CacheManager cacheManager, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(jiraAdminGroupNamesFinder, "jiraAdminGroupNamesFinder");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new CachedAdminGroupService(jiraAdminGroupNamesFinder, cacheManager, lighthouseConfig.getAdminGroupCacheRefreshRate());
    }

    @Bean(value={"jiraCachedAdminUserService"})
    @NotNull
    public CachedAdminUserService jiraCachedAdminUserService(@NotNull JiraAdminUsernamesFinder jiraAdminUsernamesFinder, @NotNull CacheManager cacheManager, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(jiraAdminUsernamesFinder, "jiraAdminUsernamesFinder");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new CachedAdminUserService(jiraAdminUsernamesFinder, cacheManager, lighthouseConfig.getAdminUserCacheRefreshRate());
    }

    @Bean(value={"jiraAdminGroupNamesFinder"})
    @NotNull
    public JiraAdminGroupNamesFinder jiraAdminGroupSupplier(@NotNull GlobalPermissionManager globalPermissionManager) {
        Intrinsics.checkNotNullParameter(globalPermissionManager, "globalPermissionManager");
        return new JiraAdminGroupNamesFinder(globalPermissionManager);
    }

    @Bean(value={"jiraAdminUsernamesFinder"})
    @NotNull
    public JiraAdminUsernamesFinder jiraAdminUsernamesFinder(@NotNull GlobalPermissionManager globalPermissionManager, @NotNull GroupManager groupManager, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil) {
        Intrinsics.checkNotNullParameter(globalPermissionManager, "globalPermissionManager");
        Intrinsics.checkNotNullParameter(groupManager, "groupManager");
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        return new JiraAdminUsernamesFinder(globalPermissionManager, groupManager, jiraThreadLocalUtil);
    }

    @Bean(value={"jiraCachedAdminGroupUpdater"})
    @NotNull
    public JiraCachedAdminGroupUpdater jiraCachedAdminGroupUpdater(@Qualifier(value="jiraCachedAdminGroupService") @NotNull CachedAdminGroupService cachedAdminGroupService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        return new JiraCachedAdminGroupUpdater(cachedAdminGroupService, eventPublisher);
    }

    @Bean(value={"jiraCachedAdminUserUpdater"})
    @NotNull
    public JiraCachedAdminUserUpdater jiraCachedAdminUserUpdater(@Qualifier(value="jiraCachedAdminGroupService") @NotNull CachedAdminGroupService cachedAdminGroupService, @Qualifier(value="jiraCachedAdminUserService") @NotNull CachedAdminUserService cachedAdminUserService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        return new JiraCachedAdminUserUpdater(cachedAdminGroupService, cachedAdminUserService, eventPublisher);
    }

    @Bean(value={"mailServiceInterface"})
    @NotNull
    public MailServiceInterface jiraMailService(@NotNull MailQueue mailQueue, @Qualifier(value="jiraEmailFactory") @NotNull DefaultEmailFactory defaultEmailFactory) {
        Intrinsics.checkNotNullParameter(mailQueue, "mailQueue");
        Intrinsics.checkNotNullParameter(defaultEmailFactory, "defaultEmailFactory");
        return new JiraMailService(mailQueue, defaultEmailFactory);
    }

    @Bean
    @NotNull
    public DefaultEmailFactory jiraEmailFactory(@NotNull MailTemplateRenderer mailTemplateRenderer) {
        Intrinsics.checkNotNullParameter(mailTemplateRenderer, "mailTemplateRenderer");
        return new DefaultEmailFactory(mailTemplateRenderer);
    }

    @Bean
    @NotNull
    public UserReferenceProvider jiraUserReferenceProvider(@NotNull com.atlassian.jira.user.util.UserManager userManager) {
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        return new JiraUserReferenceProvider(userManager);
    }

    @Bean(value={"userService"})
    @NotNull
    public SecurityUserService jiraUserService(@NotNull GlobalPermissionManager globalPermissionManager, @NotNull GroupManager groupManager, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull UserManager userManager, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(globalPermissionManager, "globalPermissionManager");
        Intrinsics.checkNotNullParameter(groupManager, "groupManager");
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        return new JiraSecurityUserService(globalPermissionManager, groupManager, jiraThreadLocalUtil, lighthouseConfig.getSecurityGroupName(), userManager);
    }

    @Bean(value={"jiraUserManagerService"})
    @NotNull
    public JiraUserManagerService jiraUserManagerService(@NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        return new JiraUserManagerService(jiraThreadLocalUtil, userManager);
    }

    @Bean(value={"jiraGroupManagerService"})
    @NotNull
    public JiraGroupManagerService jiraGroupManagerService(@NotNull GlobalPermissionManager globalPermissionManager, @NotNull GroupManager groupManager, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil) {
        Intrinsics.checkNotNullParameter(globalPermissionManager, "globalPermissionManager");
        Intrinsics.checkNotNullParameter(groupManager, "groupManager");
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        return new JiraGroupManagerService(globalPermissionManager, groupManager, jiraThreadLocalUtil);
    }

    @Bean(value={"transactionHandler"})
    @NotNull
    public TransactionHandler jiraTransactionHandler(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter(databaseAccessor, "databaseAccessor");
        return new JiraTransactionHandler(databaseAccessor);
    }

    @Bean(value={"threatDetectors"})
    @NotNull
    public List<ThreatDetector> jiraThreatDetectors(@Qualifier(value="jiraCachedAdminGroupService") @NotNull CachedAdminGroupService cachedAdminGroupService, @Qualifier(value="jiraCachedAdminUserService") @NotNull CachedAdminUserService cachedAdminUserService, @NotNull CommonDetectionFunctions commonDetectionFunctions, @NotNull JiraUserManagerService jiraUserManagerService, @NotNull JiraGroupManagerService jiraGroupManagerService, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull UserManager userManager, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(commonDetectionFunctions, "commonDetectionFunctions");
        Intrinsics.checkNotNullParameter(jiraUserManagerService, "jiraUserManagerService");
        Intrinsics.checkNotNullParameter(jiraGroupManagerService, "jiraGroupManagerService");
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        DefaultThreatDetector[] defaultThreatDetectorArray = new DefaultThreatDetector[]{new GroupPermissionChangedDetector(AlertType.ADMIN_GROUP_DELETED, JiraAuditingMatchers.ADMIN_GROUP_DELETED, JIRA_ADMINISTRATOR_PERMISSION_NAME, cachedAdminGroupService, commonDetectionFunctions, JIRA_SYSTEM_ADMINISTRATOR_PERMISSION_NAME), new DefaultThreatDetector(AlertType.ADMIN_GROUP_PERMISSION_ADDED, JiraAuditingMatchers.ADMIN_GROUP_PERMISSION_ADDED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.ADMIN_GROUP_PERMISSION_DELETED, JiraAuditingMatchers.ADMIN_GROUP_PERMISSION_DELETED, commonDetectionFunctions), new GroupPermissionChangedDetector(AlertType.ADMIN_USER_ADDED_TO_GROUP, JiraAuditingMatchers.ADMIN_USER_ADDED_TO_GROUP, JIRA_ADMINISTRATOR_PERMISSION_NAME, cachedAdminGroupService, commonDetectionFunctions, JIRA_SYSTEM_ADMINISTRATOR_PERMISSION_NAME), new GroupPermissionChangedDetector(AlertType.ADMIN_USER_DELETED_FROM_GROUP, JiraAuditingMatchers.ADMIN_USER_DELETED_FROM_GROUP, JIRA_ADMINISTRATOR_PERMISSION_NAME, cachedAdminGroupService, commonDetectionFunctions, JIRA_SYSTEM_ADMINISTRATOR_PERMISSION_NAME), new DefaultThreatDetector(AlertType.USER_ADDED_TO_SECURITY_GROUP, new JiraUserAddedSecurityGroupAuditMatcher(lighthouseConfig.getSecurityGroupName()), commonDetectionFunctions), new DefaultThreatDetector(AlertType.USER_DELETED_FROM_SECURITY_GROUP, new JiraUserDeletedSecurityGroupAuditMatcher(lighthouseConfig.getSecurityGroupName()), commonDetectionFunctions), new DefaultThreatDetector(AlertType.APP_INSTALLED, JiraAuditingMatchers.APP_INSTALLED, commonDetectionFunctions), new ChangedValuesDetector(AlertType.AUDITING_CONFIG_MODIFIED, SharedAuditingMatchers.AUDITING_CONFIG_MODIFIED_MATCHER, commonDetectionFunctions), new ChangedValuesDetector(AlertType.CONFIGURATION_CHANGED, JiraAuditingMatchers.GENERAL_CONFIGURATION_CHANGED, commonDetectionFunctions), new AdminAnonymizedDetector(AlertType.ADMIN_USER_ANONYMIZED, JiraAuditingMatchers.ADMIN_USER_ANONYMIZED, cachedAdminUserService, commonDetectionFunctions), new AdminChangedValuesDetector(AlertType.ADMIN_USER_DETAILS_CHANGED, JiraAuditingMatchers.ADMIN_USER_DETAILS_CHANGED, cachedAdminUserService, commonDetectionFunctions, jiraGroupManagerService), new AdminUsernameDetector(AlertType.ADMIN_USERNAME_CHANGED, JiraAuditingMatchers.ADMIN_USERNAME_CHANGED, cachedAdminUserService, commonDetectionFunctions), new AdminUsernameDetector(AlertType.ADMIN_USERNAME_CHANGED, JiraAuditingMatchers.ADMIN_USERNAME_CHANGED_IN_EXTERNAL_DIRECTORY, cachedAdminUserService, commonDetectionFunctions), new AdminPasswordDetector(AlertType.ADMIN_USER_PASSWORD_CHANGED, JiraAuditingMatchers.ADMIN_USER_PASSWORD_CHANGED, commonDetectionFunctions, jiraUserManagerService), new ChangedValuesDetector(AlertType.ANNOUNCEMENT_BANNER_ADDED, JiraAuditingMatchers.ANNOUNCEMENT_BANNER_ADDED, commonDetectionFunctions), new ChangedValuesDetector(AlertType.ANNOUNCEMENT_BANNER_DELETED, JiraAuditingMatchers.ANNOUNCEMENT_BANNER_DELETED, commonDetectionFunctions), new ChangedValuesDetector(AlertType.ANNOUNCEMENT_BANNER_UPDATED, JiraAuditingMatchers.ANNOUNCEMENT_BANNER_UPDATED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.AUTHENTICATION_METHOD_ADDED, GlobalAuditingMatchers.AUTHENTICATION_METHOD_ADDED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.AUTHENTICATION_METHOD_DELETED, GlobalAuditingMatchers.AUTHENTICATION_METHOD_DELETED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.AUTHENTICATION_METHOD_MODIFIED, GlobalAuditingMatchers.AUTHENTICATION_METHOD_MODIFIED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.BASIC_AUTHENTICATION_CONFIGURATION_DISABLED, GlobalAuditingMatchers.BASIC_AUTHENTICATION_CONFIGURATION_DISABLED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.BASIC_AUTHENTICATION_CONFIGURATION_ENABLED, GlobalAuditingMatchers.BASIC_AUTHENTICATION_CONFIGURATION_ENABLED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.EXPORT_STARTED, JiraAuditingMatchers.EXPORT_STARTED, commonDetectionFunctions), new DefaultThreatDetector(AlertType.IMPORT_COMPLETED, JiraAuditingMatchers.IMPORT_COMPLETED, commonDetectionFunctions), new Without2SVDetector(AlertType.ADMIN_USER_LOGGED_IN_WITHOUT_2SV, JiraAuditingMatchers.ADMIN_USER_LOGGED_IN_WITHOUT_2SV, commonDetectionFunctions)};
        return CollectionsKt.listOf(defaultThreatDetectorArray);
    }

    @Bean
    @NotNull
    public UserDirectoryModificationListener userDirectoryModificationListener(@NotNull AlertDeactivationService alertDeactivationService, @NotNull AlertService alertService, @NotNull EventPublisher eventPublisher, @NotNull EventToThreatsService eventToThreatsService) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(eventToThreatsService, "eventToThreatsService");
        return new UserDirectoryModificationListener(alertDeactivationService, alertService, eventPublisher, eventToThreatsService);
    }

    @Bean
    @NotNull
    public SystemPropertyProvider systemPropertyProvider() {
        return new DefaultSystemPropertyProvider();
    }

    @Bean
    @NotNull
    public UserDetailsFinder userDetailsFinder(@NotNull UserManager userManager, @NotNull I18nResolver i18nResolver) {
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        return new DefaultUserDetailsFinder(userManager, i18nResolver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/lighthouse/config/JiraBeanConfig$Companion;", "", "()V", "JIRA_ADMINISTRATOR_PERMISSION_NAME", "", "JIRA_SYSTEM_ADMINISTRATOR_PERMISSION_NAME", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

