/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.config.system;

import com.atlassian.lighthouse.config.system.PropertyHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "", "propertyHelper", "Lcom/atlassian/lighthouse/config/system/PropertyHelper;", "(Lcom/atlassian/lighthouse/config/system/PropertyHelper;)V", "getAdminGroupCacheRefreshRate", "", "getAdminUserCacheRefreshRate", "getAnalyticsJobRunSchedule", "", "getDeactivatedAlerts", "getGuardStatusLocalCacheExpiryInSeconds", "getSecurityGroupName", "getUnpushedCloudAlertsJobRunIntervalInMinutes", "getUnpushedCloudAlertsMaxRetryTimespanInMinutes", "Companion", "atlassian-lighthouse-core"})
public final class LighthouseConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PropertyHelper propertyHelper;
    @NotNull
    public static final String DEFAULT_GROUP_NAME = "security-monitoring-alerts";
    @NotNull
    public static final String SECURITY_GROUP_NAME = "plugin.lighthouse.security.group.name";
    @NotNull
    public static final String ADMIN_GROUP_CACHE_REFRESH_RATE_SECONDS = "plugin.lighthouse.cached.admin.group.service.refresh.rate.seconds";
    @NotNull
    public static final String ADMIN_USER_CACHE_REFRESH_RATE_SECONDS = "plugin.lighthouse.cached.admin.user.service.refresh.rate.seconds";
    public static final long DEFAULT_CACHE_REFRESH_RATE_SECONDS = 5L;
    @NotNull
    public static final String ANALYTICS_JOB_CRON_SCHEDULE = "plugin.lighthouse.analytic.cron.schedule";
    @NotNull
    public static final String DEFAULT_DAILY_CRON_SCHEDULE = "0 0 0 1/1 * ? *";
    @NotNull
    public static final String UNPUSHED_CLOUD_ALERTS_JOB_RUN_INTERVAL_IN_MINUTES = "plugin.lighthouse.cloud.alerts.retry.interval.minutes";
    public static final long DEFAULT_UNPUSHED_CLOUD_ALERTS_CRON_SCHEDULE = 5L;
    @NotNull
    public static final String UNPUSHED_CLOUD_ALERTS_MAX_RETRY_TIMESPAN = "plugin.lighthouse.cloud.alerts.retry.max.timespan.minutes";
    public static final long DEFAULT_UNPUSHED_CLOUD_ALERTS_MAX_RETRY_TIMESPAN_IN_MINUTES = 7200L;
    @NotNull
    public static final String ALERT_DEACTIVATION_SYSTEM_PROPERTY_NAME = "plugin.lighthouse.disabled.alert.types";
    @NotNull
    public static final String DEFAULT_ALERT_DEACTIVATION_SYSTEM_PROPERTY_VALUE = "";
    @NotNull
    public static final String GUARD_STATUS_LOCAL_CACHE_EXPIRY_PROPERTY_NAME = "plugin.lighthouse.guard.status.cache.expiry.seconds";
    public static final long DEFAULT_GUARD_STATUS_LOCAL_CACHE_EXPIRY_PROPERTY_VALUE = 300L;

    public LighthouseConfig(@NotNull PropertyHelper propertyHelper) {
        Intrinsics.checkNotNullParameter(propertyHelper, "propertyHelper");
        this.propertyHelper = propertyHelper;
    }

    @NotNull
    public final String getSecurityGroupName() {
        return this.propertyHelper.getSystemPropertyOrDefault(SECURITY_GROUP_NAME, DEFAULT_GROUP_NAME);
    }

    public final long getAdminGroupCacheRefreshRate() {
        return this.propertyHelper.getSystemPropertyOrDefault(ADMIN_GROUP_CACHE_REFRESH_RATE_SECONDS, 5L);
    }

    public final long getAdminUserCacheRefreshRate() {
        return this.propertyHelper.getSystemPropertyOrDefault(ADMIN_USER_CACHE_REFRESH_RATE_SECONDS, 5L);
    }

    @NotNull
    public final String getAnalyticsJobRunSchedule() {
        return this.propertyHelper.getSystemPropertyOrDefault(ANALYTICS_JOB_CRON_SCHEDULE, DEFAULT_DAILY_CRON_SCHEDULE);
    }

    @NotNull
    public final String getDeactivatedAlerts() {
        return this.propertyHelper.getSystemPropertyOrDefault(ALERT_DEACTIVATION_SYSTEM_PROPERTY_NAME, DEFAULT_ALERT_DEACTIVATION_SYSTEM_PROPERTY_VALUE);
    }

    public final long getUnpushedCloudAlertsJobRunIntervalInMinutes() {
        return this.propertyHelper.getSystemPropertyOrDefault(UNPUSHED_CLOUD_ALERTS_JOB_RUN_INTERVAL_IN_MINUTES, 5L);
    }

    public final long getUnpushedCloudAlertsMaxRetryTimespanInMinutes() {
        return this.propertyHelper.getSystemPropertyOrDefault(UNPUSHED_CLOUD_ALERTS_MAX_RETRY_TIMESPAN, 7200L);
    }

    public final long getGuardStatusLocalCacheExpiryInSeconds() {
        return this.propertyHelper.getSystemPropertyOrDefault(GUARD_STATUS_LOCAL_CACHE_EXPIRY_PROPERTY_NAME, 300L);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/lighthouse/config/system/LighthouseConfig$Companion;", "", "()V", "ADMIN_GROUP_CACHE_REFRESH_RATE_SECONDS", "", "ADMIN_USER_CACHE_REFRESH_RATE_SECONDS", "ALERT_DEACTIVATION_SYSTEM_PROPERTY_NAME", "ANALYTICS_JOB_CRON_SCHEDULE", "DEFAULT_ALERT_DEACTIVATION_SYSTEM_PROPERTY_VALUE", "DEFAULT_CACHE_REFRESH_RATE_SECONDS", "", "DEFAULT_DAILY_CRON_SCHEDULE", "DEFAULT_GROUP_NAME", "DEFAULT_GUARD_STATUS_LOCAL_CACHE_EXPIRY_PROPERTY_VALUE", "DEFAULT_UNPUSHED_CLOUD_ALERTS_CRON_SCHEDULE", "DEFAULT_UNPUSHED_CLOUD_ALERTS_MAX_RETRY_TIMESPAN_IN_MINUTES", "GUARD_STATUS_LOCAL_CACHE_EXPIRY_PROPERTY_NAME", "SECURITY_GROUP_NAME", "UNPUSHED_CLOUD_ALERTS_JOB_RUN_INTERVAL_IN_MINUTES", "UNPUSHED_CLOUD_ALERTS_MAX_RETRY_TIMESPAN", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

