/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.lighthouse.database.entities.ao.AoAlert;
import com.atlassian.lighthouse.database.query.WhereClause;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.EmailStatus;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u000eJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/lighthouse/database/dao/AlertDao;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "createAlert", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlert;", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "alertStatus", "Lcom/atlassian/lighthouse/security/detector/AlertStatus;", "emailStatus", "Lcom/atlassian/lighthouse/security/detector/EmailStatus;", "queuedTimestamp", "", "uuid", "", "timestamp", "(Lcom/atlassian/lighthouse/security/detector/AlertType;Lcom/atlassian/lighthouse/security/detector/AlertStatus;Lcom/atlassian/lighthouse/security/detector/EmailStatus;Ljava/lang/Long;Ljava/lang/String;J)Lcom/atlassian/lighthouse/database/entities/ao/AoAlert;", "getAlerts", "", "aoQuery", "Lnet/java/ao/Query;", "getAlertsByUuid", "uuids", "getById", "id", "getByUuid", "streamAlerts", "", "streamCallback", "Lkotlin/Function1;", "atlassian-lighthouse-core"})
public final class AlertDao {
    @NotNull
    private final ActiveObjects ao;

    public AlertDao(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter(ao, "ao");
        this.ao = ao;
    }

    @Nullable
    public final AoAlert getById(long id) {
        Object[] objectArray = new Object[]{id};
        RawEntity[] rawEntityArray = this.ao.find(AoAlert.class, "ID = ?", objectArray);
        Intrinsics.checkNotNullExpressionValue(rawEntityArray, "find(...)");
        return (AoAlert)ArraysKt.getOrNull((Object[])rawEntityArray, 0);
    }

    @Nullable
    public final AoAlert getByUuid(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Object[] objectArray = new Object[]{uuid};
        RawEntity[] rawEntityArray = this.ao.find(AoAlert.class, "UUID = ?", objectArray);
        Intrinsics.checkNotNullExpressionValue(rawEntityArray, "find(...)");
        return (AoAlert)ArraysKt.getOrNull((Object[])rawEntityArray, 0);
    }

    @NotNull
    public final List<AoAlert> getAlerts(@NotNull Query aoQuery) {
        Intrinsics.checkNotNullParameter(aoQuery, "aoQuery");
        RawEntity[] rawEntityArray = this.ao.find(AoAlert.class, aoQuery);
        Intrinsics.checkNotNullExpressionValue(rawEntityArray, "find(...)");
        return ArraysKt.asList((Object[])rawEntityArray);
    }

    public final void streamAlerts(@NotNull Query aoQuery, @NotNull Function1<? super AoAlert, Unit> streamCallback) {
        Intrinsics.checkNotNullParameter(aoQuery, "aoQuery");
        Intrinsics.checkNotNullParameter(streamCallback, "streamCallback");
        this.ao.stream(AoAlert.class, aoQuery, arg_0 -> AlertDao.streamAlerts$lambda$0(streamCallback, arg_0));
    }

    @NotNull
    public final AoAlert createAlert(@NotNull AlertType alertType, @NotNull AlertStatus alertStatus, @NotNull EmailStatus emailStatus, @Nullable Long queuedTimestamp, @NotNull String uuid, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter((Object)alertStatus, "alertStatus");
        Intrinsics.checkNotNullParameter((Object)emailStatus, "emailStatus");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        DBParam[] dBParamArray = new DBParam[]{new DBParam("ALERT_STATUS", (Object)alertStatus.getValue()), new DBParam("ALERT_TYPE", (Object)alertType.getId()), new DBParam("EMAIL_STATUS", (Object)emailStatus.value()), new DBParam("QUEUED_TIMESTAMP", (Object)queuedTimestamp), new DBParam("UUID", (Object)uuid), new DBParam("ALERT_TIMESTAMP", (Object)timestamp)};
        RawEntity rawEntity = this.ao.create(AoAlert.class, dBParamArray);
        Intrinsics.checkNotNullExpressionValue(rawEntity, "create(...)");
        return (AoAlert)rawEntity;
    }

    @NotNull
    public final List<AoAlert> getAlertsByUuid(@NotNull List<String> uuids) {
        Intrinsics.checkNotNullParameter(uuids, "uuids");
        WhereClause where = WhereClause.Companion.isIn("UUID", uuids);
        Object[] objectArray = where.getParameters();
        RawEntity[] rawEntityArray = this.ao.find(AoAlert.class, Query.select().where(where.getClause(), Arrays.copyOf(objectArray, objectArray.length)));
        Intrinsics.checkNotNullExpressionValue(rawEntityArray, "find(...)");
        return ArraysKt.asList((Object[])rawEntityArray);
    }

    private static final void streamAlerts$lambda$0(Function1 $tmp0, AoAlert p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }
}

