/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.dao;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.query.AlertsQuery;
import com.atlassian.lighthouse.database.query.Cursor;
import com.atlassian.lighthouse.database.query.Order;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/database/dao/AlertsPage;", "", "alerts", "", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "following", "Lcom/atlassian/lighthouse/database/query/Cursor;", "preceding", "(Ljava/util/List;Lcom/atlassian/lighthouse/database/query/Cursor;Lcom/atlassian/lighthouse/database/query/Cursor;)V", "getAlerts", "()Ljava/util/List;", "getFollowing", "()Lcom/atlassian/lighthouse/database/query/Cursor;", "getPreceding", "Companion", "atlassian-lighthouse-core"})
public final class AlertsPage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<AlertEntity> alerts;
    @Nullable
    private final Cursor following;
    @Nullable
    private final Cursor preceding;

    public AlertsPage(@NotNull List<AlertEntity> alerts, @Nullable Cursor following, @Nullable Cursor preceding) {
        Intrinsics.checkNotNullParameter(alerts, "alerts");
        this.alerts = alerts;
        this.following = following;
        this.preceding = preceding;
    }

    public /* synthetic */ AlertsPage(List list, Cursor cursor, Cursor cursor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cursor = null;
        }
        if ((n & 4) != 0) {
            cursor2 = null;
        }
        this(list, cursor, cursor2);
    }

    @NotNull
    public final List<AlertEntity> getAlerts() {
        return this.alerts;
    }

    @Nullable
    public final Cursor getFollowing() {
        return this.following;
    }

    @Nullable
    public final Cursor getPreceding() {
        return this.preceding;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/atlassian/lighthouse/database/dao/AlertsPage$Companion;", "", "()V", "of", "Lcom/atlassian/lighthouse/database/dao/AlertsPage;", "query", "Lcom/atlassian/lighthouse/database/query/AlertsQuery;", "alertEntities", "", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "hasMoreResults", "", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AlertsPage of(@NotNull AlertsQuery query, @NotNull List<AlertEntity> alertEntities, boolean hasMoreResults) {
            Cursor cursor;
            Cursor cursor2;
            Intrinsics.checkNotNullParameter(query, "query");
            Intrinsics.checkNotNullParameter(alertEntities, "alertEntities");
            if (query.getPageRequest() == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            List<AlertEntity> orderedAlerts = query.getPageRequest().getOrder() == Order.NATURAL ? alertEntities : CollectionsKt.reversed((Iterable)alertEntities);
            boolean isSeekingForwards = query.getPageRequest().getOrder() == Order.NATURAL;
            boolean cameFromAnotherPage = query.getPageRequest().getCursor() != null;
            if (!isSeekingForwards && !cameFromAnotherPage) {
                cursor2 = null;
            } else if (orderedAlerts.isEmpty()) {
                cursor2 = null;
            } else if (hasMoreResults || !isSeekingForwards) {
                Long l = CollectionsKt.last(orderedAlerts).getId();
                Intrinsics.checkNotNull(l);
                cursor2 = new Cursor(l);
            } else {
                cursor2 = null;
            }
            Cursor followingCursor = cursor2;
            if (isSeekingForwards && !cameFromAnotherPage) {
                cursor = null;
            } else if (orderedAlerts.isEmpty()) {
                cursor = null;
            } else if (hasMoreResults || isSeekingForwards) {
                Long l = CollectionsKt.first(orderedAlerts).getId();
                Intrinsics.checkNotNull(l);
                cursor = new Cursor(l);
            } else {
                cursor = null;
            }
            Cursor precedingCursor = cursor;
            return new AlertsPage(orderedAlerts, followingCursor, precedingCursor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

