/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.dao;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.lighthouse.database.dao.AlertManager;
import com.atlassian.lighthouse.database.dao.CachingUserAlertStatusCountsManager;
import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0003/01B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010 \u001a\u00020\u000fH\u0002J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\fH\u0002J*\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0019J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\u0015H\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u001dH\u0002J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\r\u001a6\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0010*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00110\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "alertManager", "Lcom/atlassian/lighthouse/database/dao/AlertManager;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "(Lcom/atlassian/lighthouse/database/dao/AlertManager;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/sal/api/timezone/TimeZoneManager;)V", "timeZoneForCacheKeys", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/ZoneId;", "userAlertStatusCountsCache", "Lcom/atlassian/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "Lcom/atlassian/lighthouse/security/detector/AlertStatus;", "", "afterPropertiesSet", "", "convertInstantToMonth", "Lkotlin/Pair;", "Ljava/time/Month;", "", "instant", "Ljava/time/Instant;", "deserializeKey", "Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager$UserAlertStatsForMonthKey;", "serializedKey", "deserializeLengthEncodedPart", "serialized", "destroy", "getSystemTimeZone", "getUserAlertStatusCountsForMonth", "userKey", "month", "year", "invalidateCountsForAlert", "alert", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "invalidateIfTimeZoneChanged", "serializeKey", "key", "serializeLengthEncodedPart", "value", "Companion", "UserAlertStatsForMonthKey", "UserAlertStatusStatsCacheLoader", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nCachingUserAlertStatusCountsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingUserAlertStatusCountsManager.kt\ncom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,175:1\n1549#2:176\n1620#2,3:177\n1549#2:180\n1620#2,3:181\n1549#2:184\n1620#2,2:185\n1622#2:188\n1#3:187\n11#4:189\n10#4,3:190\n*S KotlinDebug\n*F\n+ 1 CachingUserAlertStatusCountsManager.kt\ncom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager\n*L\n92#1:176\n92#1:177,3\n93#1:180\n93#1:181,3\n94#1:184\n94#1:185,2\n94#1:188\n161#1:189\n161#1:190,3\n*E\n"})
public final class CachingUserAlertStatusCountsManager
implements InitializingBean,
DisposableBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlertManager alertManager;
    @NotNull
    private final TimeZoneManager timeZoneManager;
    @NotNull
    private AtomicReference<ZoneId> timeZoneForCacheKeys;
    @NotNull
    private final Cache<String, Map<AlertStatus, Long>> userAlertStatusCountsCache;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final CacheSettings CACHE_SETTINGS;

    public CachingUserAlertStatusCountsManager(@NotNull AlertManager alertManager, @NotNull CacheManager cacheManager, @NotNull TimeZoneManager timeZoneManager) {
        Intrinsics.checkNotNullParameter(alertManager, "alertManager");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        this.alertManager = alertManager;
        this.timeZoneManager = timeZoneManager;
        this.timeZoneForCacheKeys = new AtomicReference<ZoneId>(this.getSystemTimeZone());
        Cache cache = cacheManager.getCache("Security monitoring and alerts - alerts status cache", (CacheLoader)new UserAlertStatusStatsCacheLoader(), CACHE_SETTINGS);
        Intrinsics.checkNotNullExpressionValue(cache, "getCache(...)");
        this.userAlertStatusCountsCache = cache;
    }

    @NotNull
    public final Map<AlertStatus, Long> getUserAlertStatusCountsForMonth(@NotNull String userKey, @NotNull Month month, int year) {
        Intrinsics.checkNotNullParameter(userKey, "userKey");
        Intrinsics.checkNotNullParameter(month, "month");
        this.invalidateIfTimeZoneChanged();
        UserAlertStatsForMonthKey key = new UserAlertStatsForMonthKey(userKey, month, year);
        Object object = this.userAlertStatusCountsCache.get((Object)this.serializeKey(key));
        Intrinsics.checkNotNull(object);
        return (Map)object;
    }

    private final String serializeKey(UserAlertStatsForMonthKey key) {
        return this.serializeLengthEncodedPart(key.getUserKey()) + key.getMonth().getValue() + "," + key.getYear();
    }

    private final UserAlertStatsForMonthKey deserializeKey(String serializedKey) {
        Pair<String, Integer> pair = this.deserializeLengthEncodedPart(serializedKey);
        String userKey = pair.component1();
        int nextIdx = ((Number)pair.component2()).intValue();
        String string = serializedKey.substring(nextIdx);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        char[] cArray = new char[]{','};
        List monthYear = StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null);
        int month = Integer.parseInt((String)monthYear.get(0));
        int year = Integer.parseInt((String)monthYear.get(1));
        Month month2 = Month.of(month);
        Intrinsics.checkNotNullExpressionValue(month2, "of(...)");
        return new UserAlertStatsForMonthKey(userKey, month2, year);
    }

    private final String serializeLengthEncodedPart(String value) {
        return value.length() + "," + value;
    }

    private final Pair<String, Integer> deserializeLengthEncodedPart(String serialized) {
        int separatorIdx = StringsKt.indexOf$default((CharSequence)serialized, ',', 0, false, 6, null);
        String string = serialized.substring(0, separatorIdx);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        int length = Integer.parseInt(string);
        int idxAfterValue = separatorIdx + length + 1;
        String string2 = serialized.substring(separatorIdx + 1, idxAfterValue);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String value = string2;
        return new Pair<String, Integer>(value, idxAfterValue);
    }

    private final void invalidateCountsForAlert(AlertEntity alert) {
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Pair<Month, Integer> pair = this.convertInstantToMonth(alert.getTimestamp());
        Month month = pair.component1();
        int year = ((Number)pair.component2()).intValue();
        Iterable iterable = SequencesKt.toSet(SequencesKt.filterNotNull(SequencesKt.map(CollectionsKt.asSequence((Iterable)alert.getThreatEvents()), invalidateCountsForAlert.1.INSTANCE)));
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UserAlertStatsForMonthKey((String)it, month, year));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UserAlertStatsForMonthKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.serializeKey((UserAlertStatsForMonthKey)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object $this$invalidateCountsForAlert_u24lambda_u245_u24lambda_u242;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object = this;
            try {
                $this$invalidateCountsForAlert_u24lambda_u245_u24lambda_u242 = object;
                boolean bl2 = false;
                ((CachingUserAlertStatusCountsManager)$this$invalidateCountsForAlert_u24lambda_u245_u24lambda_u242).userAlertStatusCountsCache.remove(it);
                $this$invalidateCountsForAlert_u24lambda_u245_u24lambda_u242 = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                $this$invalidateCountsForAlert_u24lambda_u245_u24lambda_u242 = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object = $this$invalidateCountsForAlert_u24lambda_u245_u24lambda_u242;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Object it2 = $this$invalidateCountsForAlert_u24lambda_u245_u24lambda_u242 = throwable;
                boolean bl3 = false;
                if (it2 instanceof Error) {
                    throw it2;
                }
            }
            if (Result.exceptionOrNull-impl(object) != null) {
                Throwable e;
                boolean bl4 = false;
                logger.error("Failed to remove cache entry for " + (String)it + ".", e);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final void invalidateIfTimeZoneChanged() {
        ZoneId newTimeZone = this.getSystemTimeZone();
        ZoneId oldTimeZone = this.timeZoneForCacheKeys.getAndSet(newTimeZone);
        if (!Intrinsics.areEqual(oldTimeZone, newTimeZone)) {
            Object $this$invalidateIfTimeZoneChanged_u24lambda_u246;
            logger.info("System timezone changed from {} to {}, clearing cache.", (Object)oldTimeZone, (Object)newTimeZone);
            Object object = this;
            try {
                $this$invalidateIfTimeZoneChanged_u24lambda_u246 = object;
                boolean bl = false;
                ((CachingUserAlertStatusCountsManager)$this$invalidateIfTimeZoneChanged_u24lambda_u246).userAlertStatusCountsCache.removeAll();
                $this$invalidateIfTimeZoneChanged_u24lambda_u246 = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$invalidateIfTimeZoneChanged_u24lambda_u246 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = $this$invalidateIfTimeZoneChanged_u24lambda_u246;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Object it = $this$invalidateIfTimeZoneChanged_u24lambda_u246 = throwable;
                boolean bl = false;
                if (it instanceof Error) {
                    throw it;
                }
            }
            Throwable throwable2 = Result.exceptionOrNull-impl(object);
            if (throwable2 != null) {
                Throwable e = throwable2;
                boolean bl = false;
                logger.error("Failed to remove all cache entries after system timezone change.", e);
            }
        }
    }

    private final Pair<Month, Integer> convertInstantToMonth(Instant instant) {
        ZonedDateTime zonedDateTime = instant.atZone(this.timeZoneForCacheKeys.get());
        return new Pair<Month, Integer>(zonedDateTime.getMonth(), zonedDateTime.getYear());
    }

    private final ZoneId getSystemTimeZone() {
        ZoneId zoneId = this.timeZoneManager.getDefaultTimeZone().toZoneId();
        Intrinsics.checkNotNullExpressionValue(zoneId, "toZoneId(...)");
        return zoneId;
    }

    public void afterPropertiesSet() {
        this.alertManager.addStatusChangeListener((Function1<? super AlertEntity, Unit>)new Function1<AlertEntity, Unit>((Object)this){

            public final void invoke(@NotNull AlertEntity p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                CachingUserAlertStatusCountsManager.access$invalidateCountsForAlert((CachingUserAlertStatusCountsManager)this.receiver, p0);
            }
        });
        this.alertManager.addAlertCreateListener((Function1<? super AlertEntity, Unit>)new Function1<AlertEntity, Unit>((Object)this){

            public final void invoke(@NotNull AlertEntity p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                CachingUserAlertStatusCountsManager.access$invalidateCountsForAlert((CachingUserAlertStatusCountsManager)this.receiver, p0);
            }
        });
    }

    public void destroy() {
        this.alertManager.removeStatusChangeListener((Function1<? super AlertEntity, Unit>)new Function1<AlertEntity, Unit>((Object)this){

            public final void invoke(@NotNull AlertEntity p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                CachingUserAlertStatusCountsManager.access$invalidateCountsForAlert((CachingUserAlertStatusCountsManager)this.receiver, p0);
            }
        });
        this.alertManager.removeAlertCreateListener((Function1<? super AlertEntity, Unit>)new Function1<AlertEntity, Unit>((Object)this){

            public final void invoke(@NotNull AlertEntity p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                CachingUserAlertStatusCountsManager.access$invalidateCountsForAlert((CachingUserAlertStatusCountsManager)this.receiver, p0);
            }
        });
    }

    public static final /* synthetic */ void access$invalidateCountsForAlert(CachingUserAlertStatusCountsManager $this, AlertEntity alert) {
        $this.invalidateCountsForAlert(alert);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        CachingUserAlertStatusCountsManager.logger = logger;
        CacheSettings cacheSettings = new CacheSettingsBuilder().replicateViaInvalidation().remote().expireAfterAccess(180L, TimeUnit.DAYS).maxEntries(1000).build();
        Intrinsics.checkNotNullExpressionValue(cacheSettings, "build(...)");
        CACHE_SETTINGS = cacheSettings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager$Companion;", "", "()V", "CACHE_SETTINGS", "Lcom/atlassian/cache/CacheSettings;", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager$UserAlertStatsForMonthKey;", "", "userKey", "", "month", "Ljava/time/Month;", "year", "", "(Ljava/lang/String;Ljava/time/Month;I)V", "getMonth", "()Ljava/time/Month;", "getUserKey", "()Ljava/lang/String;", "getYear", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "atlassian-lighthouse-core"})
    public static final class UserAlertStatsForMonthKey {
        @NotNull
        private final String userKey;
        @NotNull
        private final Month month;
        private final int year;

        public UserAlertStatsForMonthKey(@NotNull String userKey, @NotNull Month month, int year) {
            Intrinsics.checkNotNullParameter(userKey, "userKey");
            Intrinsics.checkNotNullParameter(month, "month");
            this.userKey = userKey;
            this.month = month;
            this.year = year;
        }

        @NotNull
        public final String getUserKey() {
            return this.userKey;
        }

        @NotNull
        public final Month getMonth() {
            return this.month;
        }

        public final int getYear() {
            return this.year;
        }

        @NotNull
        public final String component1() {
            return this.userKey;
        }

        @NotNull
        public final Month component2() {
            return this.month;
        }

        public final int component3() {
            return this.year;
        }

        @NotNull
        public final UserAlertStatsForMonthKey copy(@NotNull String userKey, @NotNull Month month, int year) {
            Intrinsics.checkNotNullParameter(userKey, "userKey");
            Intrinsics.checkNotNullParameter(month, "month");
            return new UserAlertStatsForMonthKey(userKey, month, year);
        }

        public static /* synthetic */ UserAlertStatsForMonthKey copy$default(UserAlertStatsForMonthKey userAlertStatsForMonthKey, String string, Month month, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = userAlertStatsForMonthKey.userKey;
            }
            if ((n2 & 2) != 0) {
                month = userAlertStatsForMonthKey.month;
            }
            if ((n2 & 4) != 0) {
                n = userAlertStatsForMonthKey.year;
            }
            return userAlertStatsForMonthKey.copy(string, month, n);
        }

        @NotNull
        public String toString() {
            return "UserAlertStatsForMonthKey(userKey=" + this.userKey + ", month=" + this.month + ", year=" + this.year + ")";
        }

        public int hashCode() {
            int result = this.userKey.hashCode();
            result = result * 31 + this.month.hashCode();
            result = result * 31 + Integer.hashCode(this.year);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserAlertStatsForMonthKey)) {
                return false;
            }
            UserAlertStatsForMonthKey userAlertStatsForMonthKey = (UserAlertStatsForMonthKey)other;
            if (!Intrinsics.areEqual(this.userKey, userAlertStatsForMonthKey.userKey)) {
                return false;
            }
            if (this.month != userAlertStatsForMonthKey.month) {
                return false;
            }
            return this.year == userAlertStatsForMonthKey.year;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager$UserAlertStatusStatsCacheLoader;", "Lcom/atlassian/cache/CacheLoader;", "", "", "Lcom/atlassian/lighthouse/security/detector/AlertStatus;", "", "(Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager;)V", "load", "key", "atlassian-lighthouse-core"})
    private final class UserAlertStatusStatsCacheLoader
    implements CacheLoader<String, Map<AlertStatus, ? extends Long>> {
        @NotNull
        public Map<AlertStatus, Long> load(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            UserAlertStatsForMonthKey deserializedKey = CachingUserAlertStatusCountsManager.this.deserializeKey(key);
            AlertManager alertManager = CachingUserAlertStatusCountsManager.this.alertManager;
            String string = deserializedKey.getUserKey();
            Month month = deserializedKey.getMonth();
            int n = deserializedKey.getYear();
            Object v = CachingUserAlertStatusCountsManager.this.timeZoneForCacheKeys.get();
            Intrinsics.checkNotNullExpressionValue(v, "get(...)");
            return alertManager.getUserAlertStatusCountsForMonth(string, month, n, (ZoneId)v);
        }
    }
}

