/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.lighthouse.database.dao.ScheduleJobDao;
import com.atlassian.lighthouse.database.entities.ScheduleJobEntity;
import com.atlassian.lighthouse.database.entities.ao.AoAlertScheduledJob;
import com.atlassian.lighthouse.database.mapper.ScheduleJobEntityMapper;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "scheduleJobDao", "Lcom/atlassian/lighthouse/database/dao/ScheduleJobDao;", "scheduleJobEntityMapper", "Lcom/atlassian/lighthouse/database/mapper/ScheduleJobEntityMapper;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Lcom/atlassian/lighthouse/database/dao/ScheduleJobDao;Lcom/atlassian/lighthouse/database/mapper/ScheduleJobEntityMapper;)V", "createScheduleJob", "Lcom/atlassian/lighthouse/database/entities/ScheduleJobEntity;", "jobKey", "", "lastSuccessfulRun", "", "(Ljava/lang/String;Ljava/lang/Long;)Lcom/atlassian/lighthouse/database/entities/ScheduleJobEntity;", "getLastTimeJobRunSuccessfully", "(Ljava/lang/String;)Ljava/lang/Long;", "updateLastTimeJobRunSuccessfully", "timestamp", "(Ljava/lang/String;J)Ljava/lang/Long;", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nScheduleJobManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduleJobManager.kt\ncom/atlassian/lighthouse/database/dao/ScheduleJobManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,62:1\n1#2:63\n11#3:64\n10#3,3:65\n*S KotlinDebug\n*F\n+ 1 ScheduleJobManager.kt\ncom/atlassian/lighthouse/database/dao/ScheduleJobManager\n*L\n59#1:64\n59#1:65,3\n*E\n"})
public final class ScheduleJobManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final ScheduleJobDao scheduleJobDao;
    @NotNull
    private final ScheduleJobEntityMapper scheduleJobEntityMapper;
    @NotNull
    private static final Logger logger;

    public ScheduleJobManager(@NotNull ActiveObjects ao, @NotNull ScheduleJobDao scheduleJobDao, @NotNull ScheduleJobEntityMapper scheduleJobEntityMapper) {
        Intrinsics.checkNotNullParameter(ao, "ao");
        Intrinsics.checkNotNullParameter(scheduleJobDao, "scheduleJobDao");
        Intrinsics.checkNotNullParameter(scheduleJobEntityMapper, "scheduleJobEntityMapper");
        this.ao = ao;
        this.scheduleJobDao = scheduleJobDao;
        this.scheduleJobEntityMapper = scheduleJobEntityMapper;
    }

    @NotNull
    public final ScheduleJobEntity createScheduleJob(@NotNull String jobKey, @Nullable Long lastSuccessfulRun) {
        Intrinsics.checkNotNullParameter(jobKey, "jobKey");
        AoAlertScheduledJob aoScheduleJob = (AoAlertScheduledJob)this.ao.executeInTransaction(() -> ScheduleJobManager.createScheduleJob$lambda$0(this, jobKey));
        if (aoScheduleJob != null) {
            logger.debug("[Atlassian Lighthouse] Schedule job: " + jobKey + " already exists. Returning existing entry instead.");
            return this.scheduleJobEntityMapper.mapAoScheduleJobToScheduleJobEntity(aoScheduleJob);
        }
        Object object = this.ao.executeInTransaction(() -> ScheduleJobManager.createScheduleJob$lambda$1(this, jobKey, lastSuccessfulRun));
        Intrinsics.checkNotNullExpressionValue(object, "executeInTransaction(...)");
        return (ScheduleJobEntity)object;
    }

    @Nullable
    public final Long updateLastTimeJobRunSuccessfully(@NotNull String jobKey, long timestamp) {
        Intrinsics.checkNotNullParameter(jobKey, "jobKey");
        AoAlertScheduledJob scheduleJob = (AoAlertScheduledJob)this.ao.executeInTransaction(() -> ScheduleJobManager.updateLastTimeJobRunSuccessfully$lambda$2(this, jobKey));
        if (scheduleJob != null) {
            return (Long)this.ao.executeInTransaction(() -> ScheduleJobManager.updateLastTimeJobRunSuccessfully$lambda$3(this, jobKey, timestamp));
        }
        logger.debug("[Atlassian Lighthouse] Schedule job: " + jobKey + " not found. Creating a new entry.");
        this.createScheduleJob(jobKey, null);
        return null;
    }

    @Nullable
    public final Long getLastTimeJobRunSuccessfully(@NotNull String jobKey) {
        Intrinsics.checkNotNullParameter(jobKey, "jobKey");
        return (Long)this.ao.executeInTransaction(() -> ScheduleJobManager.getLastTimeJobRunSuccessfully$lambda$5(this, jobKey));
    }

    private static final AoAlertScheduledJob createScheduleJob$lambda$0(ScheduleJobManager this$0, String $jobKey) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($jobKey, "$jobKey");
        return this$0.scheduleJobDao.getByJobKey($jobKey);
    }

    private static final ScheduleJobEntity createScheduleJob$lambda$1(ScheduleJobManager this$0, String $jobKey, Long $lastSuccessfulRun) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($jobKey, "$jobKey");
        AoAlertScheduledJob createdScheduleJob = this$0.scheduleJobDao.createScheduleJob($jobKey, $lastSuccessfulRun);
        logger.debug("[Atlassian Lighthouse] Persisted schedule job: " + $jobKey);
        return this$0.scheduleJobEntityMapper.mapAoScheduleJobToScheduleJobEntity(createdScheduleJob);
    }

    private static final AoAlertScheduledJob updateLastTimeJobRunSuccessfully$lambda$2(ScheduleJobManager this$0, String $jobKey) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($jobKey, "$jobKey");
        return this$0.scheduleJobDao.getByJobKey($jobKey);
    }

    private static final Long updateLastTimeJobRunSuccessfully$lambda$3(ScheduleJobManager this$0, String $jobKey, long $timestamp) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($jobKey, "$jobKey");
        this$0.scheduleJobDao.updateScheduleJob($jobKey, $timestamp);
        logger.debug("[Atlassian Lighthouse] Updated last successful run time for schedule job: {} at {}", (Object)$jobKey, (Object)new Date($timestamp));
        return $timestamp;
    }

    private static final Long getLastTimeJobRunSuccessfully$lambda$5(ScheduleJobManager this$0, String $jobKey) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($jobKey, "$jobKey");
        AoAlertScheduledJob aoAlertScheduledJob = this$0.scheduleJobDao.getByJobKey($jobKey);
        if (aoAlertScheduledJob != null) {
            AoAlertScheduledJob scheduleJob = aoAlertScheduledJob;
            boolean bl = false;
            return scheduleJob.getLastSuccessfulRun();
        }
        return null;
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        ScheduleJobManager.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

