/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.database.entities.ao.AoAlertThreatEvent;
import com.atlassian.lighthouse.database.mapper.ThreatEntityMapper;
import com.atlassian.lighthouse.database.query.WhereClause;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0007J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/database/dao/ThreatEventDao;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "threatEntityMapper", "Lcom/atlassian/lighthouse/database/mapper/ThreatEntityMapper;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Lcom/atlassian/lighthouse/database/mapper/ThreatEntityMapper;)V", "createThreatEventWithAlertId", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlertThreatEvent;", "threatEvent", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "alertId", "", "getAllThreatEvents", "", "getThreatEventsByAlertId", "getThreatEventsByAlertIds", "alertIds", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nThreatEventDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreatEventDao.kt\ncom/atlassian/lighthouse/database/dao/ThreatEventDao\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,82:1\n11065#2:83\n11400#2,3:84\n11#3:87\n10#3,3:88\n*S KotlinDebug\n*F\n+ 1 ThreatEventDao.kt\ncom/atlassian/lighthouse/database/dao/ThreatEventDao\n*L\n38#1:83\n38#1:84,3\n20#1:87\n20#1:88,3\n*E\n"})
public final class ThreatEventDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final ThreatEntityMapper threatEntityMapper;
    private static final int MAX_THREAT_ENTITIES_PER_ALERT = 1000;
    @NotNull
    private static final Logger logger;

    public ThreatEventDao(@NotNull ActiveObjects ao, @NotNull ThreatEntityMapper threatEntityMapper) {
        Intrinsics.checkNotNullParameter(ao, "ao");
        Intrinsics.checkNotNullParameter(threatEntityMapper, "threatEntityMapper");
        this.ao = ao;
        this.threatEntityMapper = threatEntityMapper;
    }

    @NotNull
    public final AoAlertThreatEvent createThreatEventWithAlertId(@NotNull ThreatEventEntity threatEvent, long alertId) {
        Intrinsics.checkNotNullParameter(threatEvent, "threatEvent");
        RawEntity rawEntity = this.ao.create(AoAlertThreatEvent.class, this.threatEntityMapper.mapThreatEntityToAoDbParams(threatEvent, alertId));
        Intrinsics.checkNotNullExpressionValue(rawEntity, "create(...)");
        return (AoAlertThreatEvent)rawEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Internal
    @VisibleForTesting
    @NotNull
    public final List<ThreatEventEntity> getAllThreatEvents() {
        void $this$mapTo$iv$iv;
        Object object = this.ao.executeInTransaction(() -> ThreatEventDao.getAllThreatEvents$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(object, "executeInTransaction(...)");
        Object[] $this$map$iv = (Object[])object;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AoAlertThreatEvent aoAlertThreatEvent = (AoAlertThreatEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            collection.add(this.threatEntityMapper.mapAoThreatEventToThreatEventEntity((AoAlertThreatEvent)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<AoAlertThreatEvent> getThreatEventsByAlertId(long alertId) {
        Object[] objectArray = new Object[]{alertId};
        RawEntity[] rawEntityArray = this.ao.find(AoAlertThreatEvent.class, "ALERT_ID = ?", objectArray);
        Intrinsics.checkNotNullExpressionValue(rawEntityArray, "find(...)");
        return ArraysKt.asList((Object[])rawEntityArray);
    }

    @Internal
    @NotNull
    public final List<AoAlertThreatEvent> getThreatEventsByAlertIds(@NotNull List<Long> alertIds) {
        Intrinsics.checkNotNullParameter(alertIds, "alertIds");
        if (alertIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        WhereClause whereClause = WhereClause.Companion.isIn("ALERT_ID", alertIds);
        Object[] objectArray = whereClause.getParameters();
        Query query = Query.select().where(whereClause.getClause(), Arrays.copyOf(objectArray, objectArray.length)).limit(alertIds.size() * 1000);
        AoAlertThreatEvent[] result = (AoAlertThreatEvent[])this.ao.find(AoAlertThreatEvent.class, query);
        if (result.length > alertIds.size() * 1000) {
            logger.warn("More than " + alertIds.size() * 1000 + " threat events found for alert IDs: " + alertIds + ". Results have been truncated.");
        }
        Intrinsics.checkNotNull(result);
        return ArraysKt.toList(result);
    }

    private static final AoAlertThreatEvent[] getAllThreatEvents$lambda$0(ThreatEventDao this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return (AoAlertThreatEvent[])this$0.ao.find(AoAlertThreatEvent.class);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        ThreatEventDao.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/lighthouse/database/dao/ThreatEventDao$Companion;", "", "()V", "MAX_THREAT_ENTITIES_PER_ALERT", "", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

