/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.mapper;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.GuardPushStatus;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.database.entities.ao.AoAlert;
import com.atlassian.lighthouse.database.entities.ao.AoAlertThreatEvent;
import com.atlassian.lighthouse.database.mapper.ThreatEntityMapper;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.EmailStatus;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001c\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/database/mapper/AlertEntityMapper;", "", "threatEntityMapper", "Lcom/atlassian/lighthouse/database/mapper/ThreatEntityMapper;", "(Lcom/atlassian/lighthouse/database/mapper/ThreatEntityMapper;)V", "mapAoAlertToAlertEntity", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "aoAlert", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlert;", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "alertStatus", "Lcom/atlassian/lighthouse/security/detector/AlertStatus;", "emailStatus", "Lcom/atlassian/lighthouse/security/detector/EmailStatus;", "aoAlertThreatEventList", "", "Lcom/atlassian/lighthouse/database/entities/ao/AoAlertThreatEvent;", "mapAoAlertToAlertEntityOrThrow", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAlertEntityMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertEntityMapper.kt\ncom/atlassian/lighthouse/database/mapper/AlertEntityMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n*S KotlinDebug\n*F\n+ 1 AlertEntityMapper.kt\ncom/atlassian/lighthouse/database/mapper/AlertEntityMapper\n*L\n64#1:72\n64#1:73,3\n*E\n"})
public final class AlertEntityMapper {
    @NotNull
    private final ThreatEntityMapper threatEntityMapper;

    public AlertEntityMapper(@NotNull ThreatEntityMapper threatEntityMapper) {
        Intrinsics.checkNotNullParameter(threatEntityMapper, "threatEntityMapper");
        this.threatEntityMapper = threatEntityMapper;
    }

    @NotNull
    public final AlertEntity mapAoAlertToAlertEntityOrThrow(@NotNull AoAlert aoAlert, @NotNull List<? extends AoAlertThreatEvent> aoAlertThreatEventList) {
        Intrinsics.checkNotNullParameter(aoAlert, "aoAlert");
        Intrinsics.checkNotNullParameter(aoAlertThreatEventList, "aoAlertThreatEventList");
        AlertType alertType = AlertType.Companion.fromIdOrThrow(aoAlert.getAlertTypeId());
        AlertStatus alertStatus = AlertStatus.Companion.fromValueOrThrow(aoAlert.getAlertStatus());
        EmailStatus emailStatus = EmailStatus.valueOf(aoAlert.getEmailStatus());
        return this.mapAoAlertToAlertEntity(aoAlert, alertType, alertStatus, emailStatus, aoAlertThreatEventList);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AlertEntity mapAoAlertToAlertEntity(@NotNull AoAlert aoAlert, @NotNull AlertType alertType, @NotNull AlertStatus alertStatus, @NotNull EmailStatus emailStatus, @NotNull List<? extends AoAlertThreatEvent> aoAlertThreatEventList) {
        Collection<ThreatEventEntity> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(aoAlert, "aoAlert");
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter((Object)alertStatus, "alertStatus");
        Intrinsics.checkNotNullParameter((Object)emailStatus, "emailStatus");
        Intrinsics.checkNotNullParameter(aoAlertThreatEventList, "aoAlertThreatEventList");
        Iterable iterable = aoAlertThreatEventList;
        Long l = aoAlert.getQueuedTimestamp();
        Long l2 = aoAlert.getId();
        EmailStatus emailStatus2 = emailStatus;
        AlertType alertType2 = alertType;
        AlertStatus alertStatus2 = alertStatus;
        boolean $i$f$map = false;
        void var8_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AoAlertThreatEvent aoAlertThreatEvent = (AoAlertThreatEvent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.threatEntityMapper.mapAoThreatEventToThreatEventEntity((AoAlertThreatEvent)it));
        }
        collection = (List)destination$iv$iv;
        String string = aoAlert.getUuid();
        Instant instant = Instant.ofEpochMilli(aoAlert.getAlertTimestamp());
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(...)");
        GuardPushStatus guardPushStatus = aoAlert.getGuardPushStatus();
        if (guardPushStatus == null) {
            guardPushStatus = GuardPushStatus.CREATED_BEFORE_INTEGRATION;
        }
        int n = aoAlert.getGuardRetryCount();
        GuardPushStatus guardPushStatus2 = guardPushStatus;
        Instant instant2 = instant;
        String string2 = string;
        Collection<ThreatEventEntity> collection2 = collection;
        Long l3 = l;
        Long l4 = l2;
        EmailStatus emailStatus3 = emailStatus2;
        AlertType alertType3 = alertType2;
        AlertStatus alertStatus3 = alertStatus2;
        return new AlertEntity(alertStatus3, alertType3, emailStatus3, l4, l3, (List<ThreatEventEntity>)collection2, string2, instant2, guardPushStatus2, n);
    }
}

