/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.database.query;

import com.atlassian.lighthouse.database.entities.ao.AoAlert;
import com.atlassian.lighthouse.database.entities.ao.AoAlertThreatEvent;
import com.atlassian.lighthouse.database.query.AlertsQueryTextSearchComponents;
import com.atlassian.lighthouse.database.query.PageRequest;
import com.atlassian.lighthouse.database.query.WhereClause;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.lighthouse.security.detector.AlertType;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 ?2\u00020\u0001:\u0001?Bq\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010(\u001a\u00020\rH\u0002J\u0016\u0010)\u001a\u00020&2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0002J\u0016\u0010*\u001a\u00020&2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010+\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u000b\u0010,\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u00c6\u0003Jz\u00103\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u00c6\u0001\u00a2\u0006\u0002\u00104J\u0013\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00108\u001a\u000209H\u00d6\u0001J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\"H\u0002J\t\u0010=\u001a\u00020\u000bH\u00d6\u0001J\u0016\u0010>\u001a\u00020&2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0002R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017\u00a8\u0006@"}, d2={"Lcom/atlassian/lighthouse/database/query/AlertsQuery;", "", "alertId", "", "startDate", "Ljava/time/Instant;", "endDate", "alertTypes", "", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "userKeys", "", "filterByAlertIdOrAlertTypes", "Lcom/atlassian/lighthouse/database/query/AlertsQueryTextSearchComponents;", "pageRequest", "Lcom/atlassian/lighthouse/database/query/PageRequest;", "alertStatuses", "Lcom/atlassian/lighthouse/security/detector/AlertStatus;", "(Ljava/lang/Long;Ljava/time/Instant;Ljava/time/Instant;Ljava/util/Set;Ljava/util/Set;Lcom/atlassian/lighthouse/database/query/AlertsQueryTextSearchComponents;Lcom/atlassian/lighthouse/database/query/PageRequest;Ljava/util/Set;)V", "getAlertId", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getAlertStatuses", "()Ljava/util/Set;", "getAlertTypes", "getEndDate", "()Ljava/time/Instant;", "getFilterByAlertIdOrAlertTypes", "()Lcom/atlassian/lighthouse/database/query/AlertsQueryTextSearchComponents;", "getPageRequest", "()Lcom/atlassian/lighthouse/database/query/PageRequest;", "getStartDate", "getUserKeys", "activeObjectsQuery", "Lnet/java/ao/Query;", "fields", "", "alertIdCondition", "Lcom/atlassian/lighthouse/database/query/WhereClause;", "alertIdOrAlertTypeCondition", "alertsQueryTextSearchComponents", "alertStatusesCondition", "alertTypeCondition", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Ljava/lang/Long;Ljava/time/Instant;Ljava/time/Instant;Ljava/util/Set;Ljava/util/Set;Lcom/atlassian/lighthouse/database/query/AlertsQueryTextSearchComponents;Lcom/atlassian/lighthouse/database/query/PageRequest;Ljava/util/Set;)Lcom/atlassian/lighthouse/database/query/AlertsQuery;", "equals", "", "other", "hashCode", "", "joinThreatEventTable", "", "query", "toString", "userKeysCondition", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAlertsQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertsQuery.kt\ncom/atlassian/lighthouse/database/query/AlertsQuery\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n37#2,2:175\n37#2,2:185\n1549#3:177\n1620#3,3:178\n1549#3:181\n1620#3,3:182\n*S KotlinDebug\n*F\n+ 1 AlertsQuery.kt\ncom/atlassian/lighthouse/database/query/AlertsQuery\n*L\n124#1:175,2\n157#1:185,2\n134#1:177\n134#1:178,3\n145#1:181\n145#1:182,3\n*E\n"})
public final class AlertsQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Long alertId;
    @Nullable
    private final Instant startDate;
    @Nullable
    private final Instant endDate;
    @NotNull
    private final Set<AlertType> alertTypes;
    @NotNull
    private final Set<String> userKeys;
    @Nullable
    private final AlertsQueryTextSearchComponents filterByAlertIdOrAlertTypes;
    @Nullable
    private final PageRequest pageRequest;
    @NotNull
    private final Set<AlertStatus> alertStatuses;
    @NotNull
    private static final String ALERT_TABLE_ALIAS = "alert";
    @NotNull
    private static final String THREAT_TABLE_ALIAS = "threat";
    @NotNull
    private static final String ALERT_ID_COLUMN = "alert.ID";

    public AlertsQuery(@Nullable Long alertId, @Nullable Instant startDate, @Nullable Instant endDate, @NotNull Set<? extends AlertType> alertTypes, @NotNull Set<String> userKeys, @Nullable AlertsQueryTextSearchComponents filterByAlertIdOrAlertTypes, @Nullable PageRequest pageRequest, @NotNull Set<? extends AlertStatus> alertStatuses) {
        Intrinsics.checkNotNullParameter(alertTypes, "alertTypes");
        Intrinsics.checkNotNullParameter(userKeys, "userKeys");
        Intrinsics.checkNotNullParameter(alertStatuses, "alertStatuses");
        this.alertId = alertId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.alertTypes = alertTypes;
        this.userKeys = userKeys;
        this.filterByAlertIdOrAlertTypes = filterByAlertIdOrAlertTypes;
        this.pageRequest = pageRequest;
        this.alertStatuses = alertStatuses;
    }

    public /* synthetic */ AlertsQuery(Long l, Instant instant, Instant instant2, Set set, Set set2, AlertsQueryTextSearchComponents alertsQueryTextSearchComponents, PageRequest pageRequest, Set set3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = null;
        }
        if ((n & 2) != 0) {
            instant = null;
        }
        if ((n & 4) != 0) {
            instant2 = null;
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 0x20) != 0) {
            alertsQueryTextSearchComponents = null;
        }
        if ((n & 0x40) != 0) {
            pageRequest = PageRequest.Companion.first$default(PageRequest.Companion, 0, 1, null);
        }
        if ((n & 0x80) != 0) {
            set3 = SetsKt.emptySet();
        }
        this(l, instant, instant2, set, set2, alertsQueryTextSearchComponents, pageRequest, set3);
    }

    @Nullable
    public final Long getAlertId() {
        return this.alertId;
    }

    @Nullable
    public final Instant getStartDate() {
        return this.startDate;
    }

    @Nullable
    public final Instant getEndDate() {
        return this.endDate;
    }

    @NotNull
    public final Set<AlertType> getAlertTypes() {
        return this.alertTypes;
    }

    @NotNull
    public final Set<String> getUserKeys() {
        return this.userKeys;
    }

    @Nullable
    public final AlertsQueryTextSearchComponents getFilterByAlertIdOrAlertTypes() {
        return this.filterByAlertIdOrAlertTypes;
    }

    @Nullable
    public final PageRequest getPageRequest() {
        return this.pageRequest;
    }

    @NotNull
    public final Set<AlertStatus> getAlertStatuses() {
        return this.alertStatuses;
    }

    @Nullable
    public final Query activeObjectsQuery(@Nullable List<String> fields) {
        Query query;
        if (fields != null) {
            Set fieldsWithId = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)fields, "ID"));
            query = Query.select((String)CollectionsKt.joinToString$default(fieldsWithId, null, null, null, 0, null, null, 63, null));
        } else {
            query = Query.select();
        }
        Query query2 = query;
        query2.alias(AoAlert.class, ALERT_TABLE_ALIAS);
        List whereClauses = new ArrayList();
        if (this.pageRequest != null) {
            query2.limit(this.pageRequest.getSize()).order(this.pageRequest.getOrder().getClause());
            whereClauses.add(this.pageRequest.whereClause(ALERT_ID_COLUMN));
        }
        if (this.alertId != null) {
            whereClauses.add(this.alertIdCondition(this.alertId));
        }
        if (!((Collection)this.alertTypes).isEmpty()) {
            whereClauses.add(this.alertTypeCondition(this.alertTypes));
        }
        if (!((Collection)this.alertStatuses).isEmpty()) {
            whereClauses.add(this.alertStatusesCondition(this.alertStatuses));
        }
        if (!((Collection)this.userKeys).isEmpty()) {
            Intrinsics.checkNotNull(query2);
            this.joinThreatEventTable(query2);
            whereClauses.add(this.userKeysCondition(this.userKeys));
        }
        if (this.startDate != null) {
            whereClauses.add(WhereClause.Companion.greaterThanOrEqual("alert.ALERT_TIMESTAMP", this.startDate.toEpochMilli()));
        }
        if (this.endDate != null) {
            whereClauses.add(WhereClause.Companion.lessThan("alert.ALERT_TIMESTAMP", this.endDate.toEpochMilli()));
        }
        if (this.filterByAlertIdOrAlertTypes != null) {
            WhereClause whereClause = this.alertIdOrAlertTypeCondition(this.filterByAlertIdOrAlertTypes);
            if (whereClause == null) {
                return null;
            }
            WhereClause alertIdOrAlertTypeCondition = whereClause;
            whereClauses.add(alertIdOrAlertTypeCondition);
        }
        Collection $this$toTypedArray$iv = whereClauses;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new WhereClause[0]);
        WhereClause whereClause = WhereClause.Companion.and(Arrays.copyOf(objectArray, objectArray.length));
        if (whereClause != null) {
            objectArray = whereClause.getParameters();
            query2.where(whereClause.getClause(), Arrays.copyOf(objectArray, objectArray.length));
        }
        return query2;
    }

    public static /* synthetic */ Query activeObjectsQuery$default(AlertsQuery alertsQuery, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return alertsQuery.activeObjectsQuery(list);
    }

    /*
     * WARNING - void declaration
     */
    private final WhereClause alertStatusesCondition(Set<? extends AlertStatus> alertStatuses) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = alertStatuses;
        String string = "alert.ALERT_STATUS";
        WhereClause.Companion companion = WhereClause.Companion;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AlertStatus alertStatus = (AlertStatus)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        return companion.isIn(string, (List<? extends Object>)collection);
    }

    private final WhereClause userKeysCondition(Set<String> userKeys) {
        return WhereClause.Companion.isIn("threat.TRIGGERING_USER_KEY", CollectionsKt.toList((Iterable)userKeys));
    }

    private final WhereClause alertIdCondition(long alertId) {
        return WhereClause.Companion.equals(ALERT_ID_COLUMN, alertId);
    }

    /*
     * WARNING - void declaration
     */
    private final WhereClause alertTypeCondition(Set<? extends AlertType> alertTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = alertTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AlertType alertType = (AlertType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        List alertTypeIds = (List)destination$iv$iv;
        return WhereClause.Companion.isIn("alert.ALERT_TYPE", alertTypeIds);
    }

    private final WhereClause alertIdOrAlertTypeCondition(AlertsQueryTextSearchComponents alertsQueryTextSearchComponents) {
        List alertIdOrAlertTypeWhereClause = new ArrayList();
        if (alertsQueryTextSearchComponents.getAlertId() != null) {
            alertIdOrAlertTypeWhereClause.add(this.alertIdCondition(alertsQueryTextSearchComponents.getAlertId()));
        }
        if (!((Collection)alertsQueryTextSearchComponents.getAlertTypes()).isEmpty()) {
            alertIdOrAlertTypeWhereClause.add(this.alertTypeCondition(alertsQueryTextSearchComponents.getAlertTypes()));
        }
        Collection $this$toTypedArray$iv = alertIdOrAlertTypeWhereClause;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        WhereClause[] whereClauseArray = thisCollection$iv.toArray(new WhereClause[0]);
        return WhereClause.Companion.or(Arrays.copyOf(whereClauseArray, whereClauseArray.length));
    }

    private final void joinThreatEventTable(Query query) {
        query.alias(AoAlertThreatEvent.class, THREAT_TABLE_ALIAS);
        query.join(AoAlertThreatEvent.class, "threat.ALERT_ID = alert.ID");
        query.distinct();
    }

    @Nullable
    public final Long component1() {
        return this.alertId;
    }

    @Nullable
    public final Instant component2() {
        return this.startDate;
    }

    @Nullable
    public final Instant component3() {
        return this.endDate;
    }

    @NotNull
    public final Set<AlertType> component4() {
        return this.alertTypes;
    }

    @NotNull
    public final Set<String> component5() {
        return this.userKeys;
    }

    @Nullable
    public final AlertsQueryTextSearchComponents component6() {
        return this.filterByAlertIdOrAlertTypes;
    }

    @Nullable
    public final PageRequest component7() {
        return this.pageRequest;
    }

    @NotNull
    public final Set<AlertStatus> component8() {
        return this.alertStatuses;
    }

    @NotNull
    public final AlertsQuery copy(@Nullable Long alertId, @Nullable Instant startDate, @Nullable Instant endDate, @NotNull Set<? extends AlertType> alertTypes, @NotNull Set<String> userKeys, @Nullable AlertsQueryTextSearchComponents filterByAlertIdOrAlertTypes, @Nullable PageRequest pageRequest, @NotNull Set<? extends AlertStatus> alertStatuses) {
        Intrinsics.checkNotNullParameter(alertTypes, "alertTypes");
        Intrinsics.checkNotNullParameter(userKeys, "userKeys");
        Intrinsics.checkNotNullParameter(alertStatuses, "alertStatuses");
        return new AlertsQuery(alertId, startDate, endDate, alertTypes, userKeys, filterByAlertIdOrAlertTypes, pageRequest, alertStatuses);
    }

    public static /* synthetic */ AlertsQuery copy$default(AlertsQuery alertsQuery, Long l, Instant instant, Instant instant2, Set set, Set set2, AlertsQueryTextSearchComponents alertsQueryTextSearchComponents, PageRequest pageRequest, Set set3, int n, Object object) {
        if ((n & 1) != 0) {
            l = alertsQuery.alertId;
        }
        if ((n & 2) != 0) {
            instant = alertsQuery.startDate;
        }
        if ((n & 4) != 0) {
            instant2 = alertsQuery.endDate;
        }
        if ((n & 8) != 0) {
            set = alertsQuery.alertTypes;
        }
        if ((n & 0x10) != 0) {
            set2 = alertsQuery.userKeys;
        }
        if ((n & 0x20) != 0) {
            alertsQueryTextSearchComponents = alertsQuery.filterByAlertIdOrAlertTypes;
        }
        if ((n & 0x40) != 0) {
            pageRequest = alertsQuery.pageRequest;
        }
        if ((n & 0x80) != 0) {
            set3 = alertsQuery.alertStatuses;
        }
        return alertsQuery.copy(l, instant, instant2, set, set2, alertsQueryTextSearchComponents, pageRequest, set3);
    }

    @NotNull
    public String toString() {
        return "AlertsQuery(alertId=" + this.alertId + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", alertTypes=" + this.alertTypes + ", userKeys=" + this.userKeys + ", filterByAlertIdOrAlertTypes=" + this.filterByAlertIdOrAlertTypes + ", pageRequest=" + this.pageRequest + ", alertStatuses=" + this.alertStatuses + ")";
    }

    public int hashCode() {
        int result = this.alertId == null ? 0 : ((Object)this.alertId).hashCode();
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + ((Object)this.alertTypes).hashCode();
        result = result * 31 + ((Object)this.userKeys).hashCode();
        result = result * 31 + (this.filterByAlertIdOrAlertTypes == null ? 0 : this.filterByAlertIdOrAlertTypes.hashCode());
        result = result * 31 + (this.pageRequest == null ? 0 : this.pageRequest.hashCode());
        result = result * 31 + ((Object)this.alertStatuses).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AlertsQuery)) {
            return false;
        }
        AlertsQuery alertsQuery = (AlertsQuery)other;
        if (!Intrinsics.areEqual(this.alertId, alertsQuery.alertId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.startDate, alertsQuery.startDate)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.endDate, alertsQuery.endDate)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.alertTypes, alertsQuery.alertTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.userKeys, alertsQuery.userKeys)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.filterByAlertIdOrAlertTypes, alertsQuery.filterByAlertIdOrAlertTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pageRequest, alertsQuery.pageRequest)) {
            return false;
        }
        return Intrinsics.areEqual(this.alertStatuses, alertsQuery.alertStatuses);
    }

    public AlertsQuery() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/lighthouse/database/query/AlertsQuery$Companion;", "", "()V", "ALERT_ID_COLUMN", "", "ALERT_TABLE_ALIAS", "THREAT_TABLE_ALIAS", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

