/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.eventlisteners;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.service.AlertDeactivationService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J7\u0010\u000b\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u0002H\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\t0\u0011H\u0004\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/eventlisteners/AbstractBaseAtlassianEventListener;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "alertDeactivationService", "Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "(Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;Lcom/atlassian/event/api/EventPublisher;)V", "afterPropertiesSet", "", "destroy", "handleWhenAlertIsEnabled", "T", "event", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "handle", "Lkotlin/Function1;", "(Ljava/lang/Object;Lcom/atlassian/lighthouse/security/detector/AlertType;Lkotlin/jvm/functions/Function1;)V", "atlassian-lighthouse-core"})
public class AbstractBaseAtlassianEventListener
implements InitializingBean,
DisposableBean {
    @NotNull
    private final AlertDeactivationService alertDeactivationService;
    @NotNull
    private final EventPublisher eventPublisher;

    public AbstractBaseAtlassianEventListener(@NotNull AlertDeactivationService alertDeactivationService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        this.alertDeactivationService = alertDeactivationService;
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    protected final <T> void handleWhenAlertIsEnabled(T event, @NotNull AlertType alertType, @NotNull Function1<? super T, Unit> handle) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(handle, "handle");
        if (!this.alertDeactivationService.isAlertTypeDisabled(alertType)) {
            handle.invoke(event);
        }
    }
}

