/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.eventlisteners;

import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.eventlisteners.AbstractBaseAtlassianEventListener;
import com.atlassian.lighthouse.matchers.atlassian.event.AtlassianEventTypeRegistry;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.service.AlertDeactivationService;
import com.atlassian.lighthouse.security.service.AlertService;
import com.atlassian.lighthouse.service.event.EventToThreatsService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/eventlisteners/UserDirectoryModificationListener;", "Lcom/atlassian/lighthouse/eventlisteners/AbstractBaseAtlassianEventListener;", "alertDeactivationService", "Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;", "alertService", "Lcom/atlassian/lighthouse/security/service/AlertService;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "eventToThreatsService", "Lcom/atlassian/lighthouse/service/event/EventToThreatsService;", "(Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;Lcom/atlassian/lighthouse/security/service/AlertService;Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/lighthouse/service/event/EventToThreatsService;)V", "onDirectoryCreatedEvent", "", "event", "Lcom/atlassian/crowd/event/directory/DirectoryCreatedEvent;", "onDirectoryDeletedEvent", "Lcom/atlassian/crowd/event/directory/DirectoryDeletedEvent;", "onDirectoryUpdatedEvent", "Lcom/atlassian/crowd/event/directory/DirectoryUpdatedEvent;", "atlassian-lighthouse-core"})
public final class UserDirectoryModificationListener
extends AbstractBaseAtlassianEventListener {
    @NotNull
    private final AlertService alertService;
    @NotNull
    private final EventToThreatsService eventToThreatsService;

    public UserDirectoryModificationListener(@NotNull AlertDeactivationService alertDeactivationService, @NotNull AlertService alertService, @NotNull EventPublisher eventPublisher, @NotNull EventToThreatsService eventToThreatsService) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(eventToThreatsService, "eventToThreatsService");
        super(alertDeactivationService, eventPublisher);
        this.alertService = alertService;
        this.eventToThreatsService = eventToThreatsService;
    }

    @EventListener
    public final void onDirectoryCreatedEvent(@NotNull DirectoryCreatedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.handleWhenAlertIsEnabled(event, AlertType.USER_DIRECTORY_ADDED, (Function1)new Function1<DirectoryCreatedEvent, Unit>(this, event){
            final /* synthetic */ UserDirectoryModificationListener this$0;
            final /* synthetic */ DirectoryCreatedEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(1);
            }

            public final void invoke(@NotNull DirectoryCreatedEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ThreatEventEntity threat = UserDirectoryModificationListener.access$getEventToThreatsService$p(this.this$0).getThreatEntity(this.$event, AtlassianEventTypeRegistry.INSTANCE.getUSER_DIRECTORY_CREATED_EVENT());
                UserDirectoryModificationListener.access$getAlertService$p(this.this$0).persistAlertAndSendNotification(AlertType.USER_DIRECTORY_ADDED, CollectionsKt.listOf(threat));
            }
        });
    }

    @EventListener
    public final void onDirectoryDeletedEvent(@NotNull DirectoryDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.handleWhenAlertIsEnabled(event, AlertType.USER_DIRECTORY_DELETED, (Function1)new Function1<DirectoryDeletedEvent, Unit>(this, event){
            final /* synthetic */ UserDirectoryModificationListener this$0;
            final /* synthetic */ DirectoryDeletedEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(1);
            }

            public final void invoke(@NotNull DirectoryDeletedEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ThreatEventEntity threat = UserDirectoryModificationListener.access$getEventToThreatsService$p(this.this$0).getThreatEntity(this.$event, AtlassianEventTypeRegistry.INSTANCE.getUSER_DIRECTORY_DELETED_EVENT());
                UserDirectoryModificationListener.access$getAlertService$p(this.this$0).persistAlertAndSendNotification(AlertType.USER_DIRECTORY_DELETED, CollectionsKt.listOf(threat));
            }
        });
    }

    @EventListener
    public final void onDirectoryUpdatedEvent(@NotNull DirectoryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.handleWhenAlertIsEnabled(event, AlertType.USER_DIRECTORY_UPDATED, (Function1)new Function1<DirectoryUpdatedEvent, Unit>(this, event){
            final /* synthetic */ UserDirectoryModificationListener this$0;
            final /* synthetic */ DirectoryUpdatedEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(1);
            }

            public final void invoke(@NotNull DirectoryUpdatedEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ThreatEventEntity threat = UserDirectoryModificationListener.access$getEventToThreatsService$p(this.this$0).getThreatEntity(this.$event, AtlassianEventTypeRegistry.INSTANCE.getUSER_DIRECTORY_UPDATED_EVENT());
                UserDirectoryModificationListener.access$getAlertService$p(this.this$0).persistAlertAndSendNotification(AlertType.USER_DIRECTORY_UPDATED, CollectionsKt.listOf(threat));
            }
        });
    }

    public static final /* synthetic */ EventToThreatsService access$getEventToThreatsService$p(UserDirectoryModificationListener $this) {
        return $this.eventToThreatsService;
    }

    public static final /* synthetic */ AlertService access$getAlertService$p(UserDirectoryModificationListener $this) {
        return $this.alertService;
    }
}

