/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.frontend.services.impl.jira;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.lighthouse.frontend.services.ProductInfoService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/lighthouse/frontend/services/impl/jira/JiraProductInfoService;", "Lcom/atlassian/lighthouse/frontend/services/ProductInfoService;", "jiraApplicationProperties", "Lcom/atlassian/jira/config/properties/ApplicationProperties;", "(Lcom/atlassian/jira/config/properties/ApplicationProperties;)V", "getApplicationTitle", "", "isJira", "", "atlassian-lighthouse-frontend"})
public class JiraProductInfoService
implements ProductInfoService {
    @NotNull
    private final ApplicationProperties jiraApplicationProperties;

    public JiraProductInfoService(@NotNull ApplicationProperties jiraApplicationProperties) {
        Intrinsics.checkNotNullParameter(jiraApplicationProperties, "jiraApplicationProperties");
        this.jiraApplicationProperties = jiraApplicationProperties;
    }

    @Override
    public boolean isJira() {
        return true;
    }

    @Override
    @NotNull
    public String getApplicationTitle() {
        String string = this.jiraApplicationProperties.getDefaultBackedString("jira.title");
        Intrinsics.checkNotNullExpressionValue(string, "getDefaultBackedString(...)");
        return string;
    }

    @Override
    public boolean isConfluence() {
        return ProductInfoService.DefaultImpls.isConfluence(this);
    }

    @Override
    public boolean isBitbucket() {
        return ProductInfoService.DefaultImpls.isBitbucket(this);
    }

    @Override
    public boolean isRefapp() {
        return ProductInfoService.DefaultImpls.isRefapp(this);
    }
}

