/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.notification;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.notification.AuditNotificationService;
import com.atlassian.lighthouse.notification.exception.MailServerNotConfiguredException;
import com.atlassian.lighthouse.notification.exception.NotificationException;
import com.atlassian.lighthouse.notification.mail.MailServiceInterface;
import com.atlassian.lighthouse.notification.template.MailTemplate;
import com.atlassian.lighthouse.notification.template.MailTemplateFactory;
import com.atlassian.lighthouse.security.detector.EmailStatus;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ#\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/lighthouse/notification/NotificationService;", "", "auditNotificationService", "Lcom/atlassian/lighthouse/notification/AuditNotificationService;", "mailService", "Lcom/atlassian/lighthouse/notification/mail/MailServiceInterface;", "mailTemplateFactory", "Lcom/atlassian/lighthouse/notification/template/MailTemplateFactory;", "securityUserService", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "(Lcom/atlassian/lighthouse/notification/AuditNotificationService;Lcom/atlassian/lighthouse/notification/mail/MailServiceInterface;Lcom/atlassian/lighthouse/notification/template/MailTemplateFactory;Lcom/atlassian/lighthouse/service/user/SecurityUserService;)V", "createAuditLog", "", "alertEntity", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "recipientAddresses", "", "", "status", "Lcom/atlassian/lighthouse/security/detector/EmailStatus;", "template", "Lcom/atlassian/lighthouse/notification/template/MailTemplate;", "(Lcom/atlassian/lighthouse/database/entities/AlertEntity;[Ljava/lang/String;Lcom/atlassian/lighthouse/security/detector/EmailStatus;Lcom/atlassian/lighthouse/notification/template/MailTemplate;)V", "getRecipientEmailAddresses", "()[Ljava/lang/String;", "sendEmailNotification", "sendEmailWithTemplate", "(Lcom/atlassian/lighthouse/notification/template/MailTemplate;[Ljava/lang/String;)Lcom/atlassian/lighthouse/security/detector/EmailStatus;", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationService.kt\ncom/atlassian/lighthouse/notification/NotificationService\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,75:1\n11#2:76\n10#2,3:77\n*S KotlinDebug\n*F\n+ 1 NotificationService.kt\ncom/atlassian/lighthouse/notification/NotificationService\n*L\n22#1:76\n22#1:77,3\n*E\n"})
public final class NotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuditNotificationService auditNotificationService;
    @NotNull
    private final MailServiceInterface mailService;
    @NotNull
    private final MailTemplateFactory mailTemplateFactory;
    @NotNull
    private final SecurityUserService securityUserService;
    @NotNull
    private static final Logger logger;

    public NotificationService(@NotNull AuditNotificationService auditNotificationService, @NotNull MailServiceInterface mailService, @NotNull MailTemplateFactory mailTemplateFactory, @NotNull SecurityUserService securityUserService) {
        Intrinsics.checkNotNullParameter(auditNotificationService, "auditNotificationService");
        Intrinsics.checkNotNullParameter(mailService, "mailService");
        Intrinsics.checkNotNullParameter(mailTemplateFactory, "mailTemplateFactory");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        this.auditNotificationService = auditNotificationService;
        this.mailService = mailService;
        this.mailTemplateFactory = mailTemplateFactory;
        this.securityUserService = securityUserService;
    }

    @NotNull
    public final EmailStatus sendEmailNotification(@NotNull AlertEntity alertEntity) {
        Intrinsics.checkNotNullParameter(alertEntity, "alertEntity");
        logger.info("[Atlassian Lighthouse] - processing email notification for " + alertEntity);
        String[] recipientAddresses = this.getRecipientEmailAddresses();
        if (recipientAddresses.length == 0) {
            logger.warn("[Atlassian Lighthouse] - no valid email addresses found. Product might have not been setup yet");
            return EmailStatus.FAILED;
        }
        MailTemplate template = this.mailTemplateFactory.createTemplate(alertEntity);
        EmailStatus status = this.sendEmailWithTemplate(template, recipientAddresses);
        this.createAuditLog(alertEntity, recipientAddresses, status, template);
        return status;
    }

    private final EmailStatus sendEmailWithTemplate(MailTemplate template, String[] recipientAddresses) {
        EmailStatus emailStatus;
        try {
            this.mailService.sendMail(template, recipientAddresses);
            emailStatus = EmailStatus.SENT;
        }
        catch (MailServerNotConfiguredException mailServerNotConfiguredException) {
            emailStatus = EmailStatus.FAILED;
        }
        catch (NotificationException notificationException) {
            logger.warn("[Atlassian Lighthouse] - error while sending email notification", (Throwable)notificationException);
            emailStatus = EmailStatus.FAILED;
        }
        catch (Exception exception) {
            logger.warn("[Atlassian Lighthouse] - unsupported error while sending email notification", (Throwable)exception);
            emailStatus = EmailStatus.FAILED;
        }
        return emailStatus;
    }

    private final String[] getRecipientEmailAddresses() {
        String[] securityGroupUserEmails = this.securityUserService.getValidSecurityGroupUserEmails();
        return securityGroupUserEmails.length == 0 ? this.securityUserService.getSysAdminEmailAddresses() : securityGroupUserEmails;
    }

    private final void createAuditLog(AlertEntity alertEntity, String[] recipientAddresses, EmailStatus status, MailTemplate template) {
        if (WhenMappings.$EnumSwitchMapping$0[status.ordinal()] == 1) {
            this.auditNotificationService.auditNotificationSent(template, recipientAddresses);
        } else {
            this.auditNotificationService.auditNotificationFailed(alertEntity, recipientAddresses);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        NotificationService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/notification/NotificationService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EmailStatus.values().length];
            try {
                nArray[EmailStatus.SENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

