/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.notification.generators;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.lighthouse.notification.template.MailTemplate;
import com.atlassian.lighthouse.notification.template.MailTemplateRenderer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/notification/generators/BitbucketMailMessageFactory;", "", "mailTemplateRenderer", "Lcom/atlassian/lighthouse/notification/template/MailTemplateRenderer;", "(Lcom/atlassian/lighthouse/notification/template/MailTemplateRenderer;)V", "createMailMessage", "Lcom/atlassian/bitbucket/mail/MailMessage;", "mailTemplate", "Lcom/atlassian/lighthouse/notification/template/MailTemplate;", "emailAddresses", "", "", "(Lcom/atlassian/lighthouse/notification/template/MailTemplate;[Ljava/lang/String;)Lcom/atlassian/bitbucket/mail/MailMessage;", "atlassian-lighthouse-core"})
public final class BitbucketMailMessageFactory {
    @NotNull
    private final MailTemplateRenderer mailTemplateRenderer;

    public BitbucketMailMessageFactory(@NotNull MailTemplateRenderer mailTemplateRenderer) {
        Intrinsics.checkNotNullParameter(mailTemplateRenderer, "mailTemplateRenderer");
        this.mailTemplateRenderer = mailTemplateRenderer;
    }

    @NotNull
    public final MailMessage createMailMessage(@NotNull MailTemplate mailTemplate, @NotNull String[] emailAddresses) {
        Intrinsics.checkNotNullParameter(mailTemplate, "mailTemplate");
        Intrinsics.checkNotNullParameter(emailAddresses, "emailAddresses");
        String body = this.mailTemplateRenderer.render(mailTemplate);
        MailMessage mailMessage = new MailMessage.Builder().to(Arrays.copyOf(emailAddresses, emailAddresses.length)).subject(mailTemplate.getSubject()).text(body).header("Content-Type", "text/html; charset=\"UTF-8\"").build();
        Intrinsics.checkNotNullExpressionValue(mailMessage, "build(...)");
        return mailMessage;
    }
}

