/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.notification.template;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.i18n.EmailAlertTypeI18nMapper;
import com.atlassian.lighthouse.notification.exception.NotificationException;
import com.atlassian.lighthouse.notification.template.AlertSpecificTemplateParameter;
import com.atlassian.lighthouse.notification.template.CommonTemplateParameter;
import com.atlassian.lighthouse.notification.template.MailTemplate;
import com.atlassian.lighthouse.notification.template.TemplateParametersService;
import com.atlassian.lighthouse.plugin.PluginInfo;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00140\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/lighthouse/notification/template/MailTemplateFactory;", "", "emailAlertTypeI18nMapper", "Lcom/atlassian/lighthouse/i18n/EmailAlertTypeI18nMapper;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "pluginInfo", "Lcom/atlassian/lighthouse/plugin/PluginInfo;", "templateParametersService", "Lcom/atlassian/lighthouse/notification/template/TemplateParametersService;", "(Lcom/atlassian/lighthouse/i18n/EmailAlertTypeI18nMapper;Lcom/atlassian/sal/api/message/I18nResolver;Lcom/atlassian/lighthouse/plugin/PluginInfo;Lcom/atlassian/lighthouse/notification/template/TemplateParametersService;)V", "soyTemplateModuleKey", "", "createTemplate", "Lcom/atlassian/lighthouse/notification/template/MailTemplate;", "alertEntity", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "getAlertSpecificRenderingParameters", "", "Lcom/atlassian/lighthouse/notification/template/AlertSpecificTemplateParameter;", "", "getAlertTypeI18n", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "getCommonRenderingParameters", "Lcom/atlassian/lighthouse/notification/template/CommonTemplateParameter;", "getSubjectI18n", "Companion", "atlassian-lighthouse-core"})
public final class MailTemplateFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmailAlertTypeI18nMapper emailAlertTypeI18nMapper;
    @NotNull
    private final I18nResolver i18nResolver;
    @NotNull
    private final TemplateParametersService templateParametersService;
    @NotNull
    private final String soyTemplateModuleKey;
    @NotNull
    public static final String SUBJECT_I18N_KEY = "lighthouse.email.subject";
    @NotNull
    public static final String GENERIC_SOY_TEMPLATE_NAME = "com.atlassian.lighthouse.email.genericAlertEmail";

    public MailTemplateFactory(@NotNull EmailAlertTypeI18nMapper emailAlertTypeI18nMapper, @NotNull I18nResolver i18nResolver, @NotNull PluginInfo pluginInfo, @NotNull TemplateParametersService templateParametersService) {
        Intrinsics.checkNotNullParameter(emailAlertTypeI18nMapper, "emailAlertTypeI18nMapper");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(templateParametersService, "templateParametersService");
        this.emailAlertTypeI18nMapper = emailAlertTypeI18nMapper;
        this.i18nResolver = i18nResolver;
        this.templateParametersService = templateParametersService;
        this.soyTemplateModuleKey = pluginInfo.getBundleName() + ":soy-templates";
    }

    @NotNull
    public final MailTemplate createTemplate(@NotNull AlertEntity alertEntity) throws NotificationException {
        Intrinsics.checkNotNullParameter(alertEntity, "alertEntity");
        AlertType alertType = alertEntity.getAlertType();
        Long l = alertEntity.getId();
        Intrinsics.checkNotNull(l);
        return new MailTemplate(alertType, String.valueOf(l), alertEntity.getUuid(), this.getCommonRenderingParameters(alertEntity), this.getAlertSpecificRenderingParameters(alertEntity), this.soyTemplateModuleKey, GENERIC_SOY_TEMPLATE_NAME, this.getSubjectI18n(alertEntity.getAlertType()));
    }

    private final Map<AlertSpecificTemplateParameter, List<String>> getAlertSpecificRenderingParameters(AlertEntity alertEntity) {
        return this.templateParametersService.getAlertSpecificRenderingParameters(alertEntity.getAlertType(), alertEntity.getThreatEvents());
    }

    private final Map<CommonTemplateParameter, String> getCommonRenderingParameters(AlertEntity alertEntity) {
        return this.templateParametersService.getCommonRenderingParameters(CollectionsKt.first(alertEntity.getThreatEvents()));
    }

    private final String getSubjectI18n(AlertType alertType) {
        Serializable[] serializableArray = new Serializable[]{this.getAlertTypeI18n(alertType)};
        String string = this.i18nResolver.getText(SUBJECT_I18N_KEY, serializableArray);
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        return string;
    }

    private final String getAlertTypeI18n(AlertType alertType) {
        return this.emailAlertTypeI18nMapper.getTranslation(alertType);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/lighthouse/notification/template/MailTemplateFactory$Companion;", "", "()V", "GENERIC_SOY_TEMPLATE_NAME", "", "SUBJECT_I18N_KEY", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

