/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.notification.template;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.notification.exception.NotificationException;
import com.atlassian.lighthouse.notification.template.AlertSpecificTemplateParameter;
import com.atlassian.lighthouse.notification.template.CommonTemplateParameter;
import com.atlassian.lighthouse.notification.template.TemplateParametersStrategy;
import com.atlassian.lighthouse.notification.template.parameters.AlertSpecificTemplateParametersProviderInterface;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.ibm.icu.text.BreakIterator;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 82\u00020\u0001:\u00018B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J.\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001aJ\u001c\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00182\u0006\u0010!\u001a\u00020\u001eJ\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010%\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0018H\u0002J$\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001aH\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001eH\u0007J\b\u0010(\u001a\u00020\u0007H\u0002J\u001e\u0010)\u001a\u0004\u0018\u00010\u00072\b\u0010*\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010+\u001a\u00020,H\u0007J\u0018\u0010-\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0007J\u0014\u0010.\u001a\u0004\u0018\u00010\u00072\b\u0010*\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010/\u001a\u00020\u00072\b\u00100\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u00101\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0002J>\u00102\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u00072\u0006\u00103\u001a\u00020\u00072\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0007052\u0016\u00106\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000707H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/atlassian/lighthouse/notification/template/TemplateParametersService;", "", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "localeResolver", "Lcom/atlassian/sal/api/message/LocaleResolver;", "productId", "", "securityGroupName", "securityUserService", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "userDetailsFinder", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "(Lcom/atlassian/sal/api/message/I18nResolver;Lcom/atlassian/sal/api/message/LocaleResolver;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/lighthouse/service/user/SecurityUserService;Lcom/atlassian/sal/api/timezone/TimeZoneManager;Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;)V", "formatDateTime", "dateTime", "Ljava/time/Instant;", "formatUserDetailsToDisplayName", "userDetails", "Lcom/atlassian/lighthouse/service/user/UserDetails;", "username", "getAlertSpecificRenderingParameters", "", "Lcom/atlassian/lighthouse/notification/template/AlertSpecificTemplateParameter;", "", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "threatEventEntityList", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "getCommonRenderingParameters", "Lcom/atlassian/lighthouse/notification/template/CommonTemplateParameter;", "threat", "getDateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "getDocumentationUrl", "getFooterRenderingParameters", "getRenderedExtraAttributes", "getSourceIp", "getUnknownValue", "limitStringCharacters", "value", "limit", "", "limitTextWithGraphemeClusters", "setEmptyValuePlaceholder", "toDisplayNameByUserKey", "userKey", "toDisplayNameByUsername", "applyTransformFunctionForAttributes", "key", "applicableTemplateParameters", "", "transformFunction", "Lkotlin/Function1;", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nTemplateParametersService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateParametersService.kt\ncom/atlassian/lighthouse/notification/template/TemplateParametersService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1549#2:252\n1620#2,3:253\n2661#2,7:256\n1238#2,4:265\n453#3:263\n403#3:264\n1#4:269\n*S KotlinDebug\n*F\n+ 1 TemplateParametersService.kt\ncom/atlassian/lighthouse/notification/template/TemplateParametersService\n*L\n110#1:252\n110#1:253,3\n111#1:256,7\n112#1:265,4\n112#1:263\n112#1:264\n*E\n"})
public final class TemplateParametersService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final I18nResolver i18nResolver;
    @NotNull
    private final LocaleResolver localeResolver;
    @NotNull
    private final String productId;
    @NotNull
    private final String securityGroupName;
    @NotNull
    private final SecurityUserService securityUserService;
    @NotNull
    private final TimeZoneManager timeZoneManager;
    @NotNull
    private final UserDetailsFinder userDetailsFinder;
    private static final int SHORTEN_VALUE_CHARACTER_LIMIT = 100;
    @NotNull
    private static final String PRODUCT_AGNOSTIC_DOCUMENTATION_URL = "https://developer.atlassian.com/";
    @NotNull
    public static final String BITBUCKET_DOCUMENTATION_URL = "https://confluence.atlassian.com/display/BitbucketServer/Monitor+security+threats";
    @NotNull
    public static final String CONFLUENCE_DOCUMENTATION_URL = "https://confluence.atlassian.com/display/DOC/Monitor+security+threats";
    @NotNull
    public static final String JIRA_DOCUMENTATION_URL = "https://confluence.atlassian.com/display/ADMINJIRASERVER/Monitor+security+threats";
    @NotNull
    private static final Set<String> usernameAttributeIds;
    @NotNull
    private static final Set<String> potentiallyLongValueAttributeIds;
    @NotNull
    private static final Set<String> potentiallyEmptyValueAttributeIds;

    public TemplateParametersService(@NotNull I18nResolver i18nResolver, @NotNull LocaleResolver localeResolver, @NotNull String productId, @NotNull String securityGroupName, @NotNull SecurityUserService securityUserService, @NotNull TimeZoneManager timeZoneManager, @NotNull UserDetailsFinder userDetailsFinder) {
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter(localeResolver, "localeResolver");
        Intrinsics.checkNotNullParameter(productId, "productId");
        Intrinsics.checkNotNullParameter(securityGroupName, "securityGroupName");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        Intrinsics.checkNotNullParameter(userDetailsFinder, "userDetailsFinder");
        this.i18nResolver = i18nResolver;
        this.localeResolver = localeResolver;
        this.productId = productId;
        this.securityGroupName = securityGroupName;
        this.securityUserService = securityUserService;
        this.timeZoneManager = timeZoneManager;
        this.userDetailsFinder = userDetailsFinder;
    }

    @NotNull
    public final Map<AlertSpecificTemplateParameter, List<String>> getAlertSpecificRenderingParameters(@NotNull AlertType alertType, @NotNull List<ThreatEventEntity> threatEventEntityList) throws NotificationException {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(threatEventEntityList, "threatEventEntityList");
        if (threatEventEntityList.isEmpty()) {
            throw new NotificationException("No threat events found for alert type " + alertType, null, 2, null);
        }
        Map<String, String> renderedExtraAttributes = this.getRenderedExtraAttributes(threatEventEntityList);
        AlertSpecificTemplateParametersProviderInterface templateParametersProvider = TemplateParametersStrategy.INSTANCE.getTemplateParametersProvider(alertType);
        return templateParametersProvider.getTemplateParameters(renderedExtraAttributes);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getRenderedExtraAttributes(List<ThreatEventEntity> threatEventEntityList) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = threatEventEntityList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThreatEventEntity threatEventEntity = (ThreatEventEntity)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getExtraAttributes());
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            Map $i$f$mapTo2 = (Map)iterator$iv.next();
            Map p0 = (Map)accumulator$iv;
            boolean bl = false;
            accumulator$iv = MapsKt.plus(p0, p1);
        }
        Map $this$mapValues$iv = (Map)accumulator$iv;
        boolean $i$f$mapValues = false;
        iterator$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object2;
            boolean bl2 = false;
            String string = this.applyTransformFunctionForAttributes(this.applyTransformFunctionForAttributes(this.applyTransformFunctionForAttributes((String)it.getValue(), (String)it.getKey(), usernameAttributeIds, (Function1<? super String, String>)new Function1<String, String>((Object)this){

                @NotNull
                public final String invoke(@Nullable String p0) {
                    return TemplateParametersService.access$toDisplayNameByUsername((TemplateParametersService)this.receiver, p0);
                }
            }), (String)it.getKey(), potentiallyLongValueAttributeIds, (Function1<? super String, String>)new Function1<String, String>((Object)this){

                @Nullable
                public final String invoke(@Nullable String p0) {
                    return TemplateParametersService.limitStringCharacters$default((TemplateParametersService)this.receiver, p0, 0, 2, null);
                }
            }), (String)it.getKey(), potentiallyEmptyValueAttributeIds, (Function1<? super String, String>)new Function1<String, String>((Object)this){

                @Nullable
                public final String invoke(@Nullable String p0) {
                    return TemplateParametersService.access$setEmptyValuePlaceholder((TemplateParametersService)this.receiver, p0);
                }
            });
            object.put(k, string);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Map<CommonTemplateParameter, String> getCommonRenderingParameters(@NotNull ThreatEventEntity threat) {
        Intrinsics.checkNotNullParameter(threat, "threat");
        Pair[] pairArray = new Pair[]{TuplesKt.to(CommonTemplateParameter.ALERT_TIME, this.formatDateTime(threat.getCreatedTime())), TuplesKt.to(CommonTemplateParameter.AUDIT_AUTHOR, this.toDisplayNameByUserKey(threat.getTriggeringUserKey())), TuplesKt.to(CommonTemplateParameter.INSTANCE_URL, threat.getInstanceBaseUrl()), TuplesKt.to(CommonTemplateParameter.METHOD, threat.getEventSource()), TuplesKt.to(CommonTemplateParameter.NODE_ID, threat.getNodeId()), TuplesKt.to(CommonTemplateParameter.SOURCE_IP, this.getSourceIp(threat))};
        return MapsKt.plus(MapsKt.mapOf(pairArray), this.getFooterRenderingParameters());
    }

    private final String formatDateTime(Instant dateTime) {
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        String formattedDateString = dateTimeFormatter.format(dateTime);
        String string = this.i18nResolver.getText(this.localeResolver.getLocale(), formattedDateString);
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        return string;
    }

    private final DateTimeFormatter getDateTimeFormatter() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, this.localeResolver.getLocale());
        Intrinsics.checkNotNull(dateFormat, "null cannot be cast to non-null type java.text.SimpleDateFormat");
        String dateTimeFormatStringPattern = ((SimpleDateFormat)dateFormat).toPattern();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimeFormatStringPattern).withLocale(this.localeResolver.getLocale()).withZone(this.timeZoneManager.getDefaultTimeZone().toZoneId());
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "withZone(...)");
        return dateTimeFormatter;
    }

    @VisibleForTesting
    @NotNull
    public final String getSourceIp(@NotNull ThreatEventEntity threat) {
        Intrinsics.checkNotNullParameter(threat, "threat");
        String string = threat.getSourceIp();
        if (string == null) {
            string = this.getUnknownValue();
        }
        return string;
    }

    private final String toDisplayNameByUsername(String username) {
        if (username == null) {
            return this.getUnknownValue();
        }
        UserDetails userDetails = this.userDetailsFinder.fromUsername(username);
        return this.formatUserDetailsToDisplayName(userDetails, username);
    }

    private final String toDisplayNameByUserKey(String userKey) {
        if (userKey == null) {
            return this.getUnknownValue();
        }
        UserDetails userDetails = this.userDetailsFinder.fromUserKey(userKey);
        return this.formatUserDetailsToDisplayName(userDetails, userKey);
    }

    private final String formatUserDetailsToDisplayName(UserDetails userDetails, String username) {
        if (Intrinsics.areEqual(UserDetailsFinder.Companion.getUNKNOWN_USER_DETAILS$atlassian_lighthouse_core(), userDetails)) {
            return username;
        }
        if (Intrinsics.areEqual(UserDetailsFinder.Companion.getSYSTEM_USER_DETAILS$atlassian_lighthouse_core(), userDetails) || Intrinsics.areEqual(UserDetailsFinder.Companion.getANONYMOUS_USER_DETAILS$atlassian_lighthouse_core(), userDetails)) {
            String string = userDetails.getFullName();
            Intrinsics.checkNotNull(string);
            return string;
        }
        return userDetails.getFullName() + " (" + userDetails.getUsername() + ")";
    }

    private final Map<CommonTemplateParameter, String> getFooterRenderingParameters() {
        Pair[] pairArray = new Pair[]{TuplesKt.to(CommonTemplateParameter.DOCUMENTATION_URL, this.getDocumentationUrl(this.productId)), TuplesKt.to(CommonTemplateParameter.IS_SECURITY_GROUP_SETUP, String.valueOf(this.securityUserService.isSecurityGroupSetup())), TuplesKt.to(CommonTemplateParameter.PRODUCT_ID, this.productId), TuplesKt.to(CommonTemplateParameter.SECURITY_GROUP_NAME, this.securityGroupName)};
        return MapsKt.mapOf(pairArray);
    }

    private final String getDocumentationUrl(String productId) {
        return switch (productId) {
            case "bitbucket" -> BITBUCKET_DOCUMENTATION_URL;
            case "confluence" -> CONFLUENCE_DOCUMENTATION_URL;
            case "jira" -> JIRA_DOCUMENTATION_URL;
            default -> PRODUCT_AGNOSTIC_DOCUMENTATION_URL;
        };
    }

    @VisibleForTesting
    @Nullable
    public final String limitStringCharacters(@Nullable String value, int limit) {
        if (value == null || value.length() <= limit) {
            return value;
        }
        Serializable[] serializableArray = new Serializable[]{this.limitTextWithGraphemeClusters(value, limit)};
        return this.i18nResolver.getText("lighthouse.email.label.truncatedTextTemplate", serializableArray);
    }

    public static /* synthetic */ String limitStringCharacters$default(TemplateParametersService templateParametersService, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        return templateParametersService.limitStringCharacters(string, n);
    }

    @VisibleForTesting
    @NotNull
    public final String limitTextWithGraphemeClusters(@NotNull String value, int limit) {
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = BreakIterator.getCharacterInstance();
        BreakIterator $this$limitTextWithGraphemeClusters_u24lambda_u242 = object;
        boolean bl = false;
        $this$limitTextWithGraphemeClusters_u24lambda_u242.setText(value);
        BreakIterator boundary = object;
        Object $this$limitTextWithGraphemeClusters_u24lambda_u243 = object = new StringBuilder();
        boolean bl2 = false;
        int start = boundary.first();
        int end = boundary.next();
        for (int count = 0; end != -1 && count < limit; ++count) {
            ((StringBuilder)$this$limitTextWithGraphemeClusters_u24lambda_u243).append(value, start, end);
            start = end;
            end = boundary.next();
        }
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String setEmptyValuePlaceholder(String value) {
        CharSequence charSequence = value;
        return !(charSequence == null || charSequence.length() == 0) ? value : this.i18nResolver.getText("lighthouse.email.label.emptyChangedValuePlaceholder");
    }

    private final String applyTransformFunctionForAttributes(String $this$applyTransformFunctionForAttributes, String key, Set<String> applicableTemplateParameters, Function1<? super String, String> transformFunction) {
        return applicableTemplateParameters.contains(key) ? transformFunction.invoke($this$applyTransformFunctionForAttributes) : $this$applyTransformFunctionForAttributes;
    }

    private final String getUnknownValue() {
        String string = this.i18nResolver.getText("lighthouse.email.label.value.unknown");
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        return string;
    }

    public static final /* synthetic */ String access$toDisplayNameByUsername(TemplateParametersService $this, String username) {
        return $this.toDisplayNameByUsername(username);
    }

    public static final /* synthetic */ String access$setEmptyValuePlaceholder(TemplateParametersService $this, String value) {
        return $this.setEmptyValuePlaceholder(value);
    }

    static {
        String[] stringArray = new String[]{"admin.username", "security.group.user.name"};
        usernameAttributeIds = SetsKt.setOf(stringArray);
        stringArray = new String[]{"announcement.banner.content", "announcement.banner.content.from", "announcement.banner.content.to", "custom.html.before.head.end", "custom.html.before.head.end.to", "custom.html.before.head.end.from", "custom.html.after.body.start", "custom.html.after.body.start.from", "custom.html.after.body.start.to", "custom.html.after.body.end", "custom.html.after.body.end.from", "custom.html.after.body.end.to"};
        potentiallyLongValueAttributeIds = SetsKt.setOf(stringArray);
        stringArray = new String[]{"custom.html.before.head.end.to", "custom.html.after.body.start.to", "custom.html.after.body.end.to"};
        potentiallyEmptyValueAttributeIds = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/lighthouse/notification/template/TemplateParametersService$Companion;", "", "()V", "BITBUCKET_DOCUMENTATION_URL", "", "CONFLUENCE_DOCUMENTATION_URL", "JIRA_DOCUMENTATION_URL", "PRODUCT_AGNOSTIC_DOCUMENTATION_URL", "SHORTEN_VALUE_CHARACTER_LIMIT", "", "potentiallyEmptyValueAttributeIds", "", "potentiallyLongValueAttributeIds", "usernameAttributeIds", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

