/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest;

import com.atlassian.lighthouse.rest.dto.ActorDto;
import com.atlassian.lighthouse.rest.dto.ActorsPagedResponseDto;
import com.atlassian.lighthouse.rest.dto.LinksDto;
import com.atlassian.lighthouse.rest.dto.ListActorsQueryParametersDto;
import com.atlassian.lighthouse.rest.dto.mapper.ActorDtoMapper;
import com.atlassian.lighthouse.security.service.WebSudoEnforcerService;
import com.atlassian.lighthouse.service.user.Constants;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Path(value="/actors")
@Produces(value={"application/json"})
@Provider
@LicensedOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/rest/ActorsResource;", "", "userDetailsFinder", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "actorDtoMapper", "Lcom/atlassian/lighthouse/rest/dto/mapper/ActorDtoMapper;", "webSudoEnforcerService", "Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "(Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;Lcom/atlassian/lighthouse/rest/dto/mapper/ActorDtoMapper;Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;Ljakarta/servlet/http/HttpServletRequest;)V", "listActors", "Ljakarta/ws/rs/core/Response;", "queryParameters", "Lcom/atlassian/lighthouse/rest/dto/ListActorsQueryParametersDto;", "atlassian-lighthouse-rest"})
@SourceDebugExtension(value={"SMAP\nActorsResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActorsResource.kt\ncom/atlassian/lighthouse/rest/ActorsResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1549#2:121\n1620#2,3:122\n766#2:125\n857#2,2:126\n1549#2:128\n1620#2,3:129\n*S KotlinDebug\n*F\n+ 1 ActorsResource.kt\ncom/atlassian/lighthouse/rest/ActorsResource\n*L\n101#1:121\n101#1:122,3\n105#1:125\n105#1:126,2\n106#1:128\n106#1:129,3\n*E\n"})
public class ActorsResource {
    @NotNull
    private final UserDetailsFinder userDetailsFinder;
    @NotNull
    private final ActorDtoMapper actorDtoMapper;
    @NotNull
    private final WebSudoEnforcerService webSudoEnforcerService;
    @NotNull
    private final HttpServletRequest request;

    @Inject
    public ActorsResource(@NotNull UserDetailsFinder userDetailsFinder, @NotNull ActorDtoMapper actorDtoMapper, @NotNull WebSudoEnforcerService webSudoEnforcerService, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter(userDetailsFinder, "userDetailsFinder");
        Intrinsics.checkNotNullParameter(actorDtoMapper, "actorDtoMapper");
        Intrinsics.checkNotNullParameter(webSudoEnforcerService, "webSudoEnforcerService");
        Intrinsics.checkNotNullParameter(request, "request");
        this.userDetailsFinder = userDetailsFinder;
        this.actorDtoMapper = actorDtoMapper;
        this.webSudoEnforcerService = webSudoEnforcerService;
        this.request = request;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Operation(tags={"actors"}, summary="Returns a paginated list of actors, currently only supports querying by userKey", description="Returns a list of actors")
    @ApiResponses(value={@ApiResponse(description="Returns a list in JSON of the actors matching the user keys", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ActorsPagedResponseDto.class))}), @ApiResponse(description="Returned if the userKeys parameter contains no keys", responseCode="400", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @Parameters(value={@Parameter(name="userKeys", in=ParameterIn.QUERY, description="List of userKeys to be looked up as part of the listing operation", required=true)})
    @NotNull
    public final Response listActors(@BeanParam @NotNull ListActorsQueryParametersDto queryParameters) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        UserDetails it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(queryParameters, "queryParameters");
        this.webSudoEnforcerService.enforceWebSudoIfApplicable(this.request);
        if (queryParameters.getUserKeys().isEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"userKeys parameter is required but no keys were provided").build();
            Intrinsics.checkNotNullExpressionValue(response, "build(...)");
            return response;
        }
        boolean hasUnknownUser = queryParameters.getUserKeys().contains(Constants.INSTANCE.getUNKNOWN_USER_KEY());
        Iterable iterable = queryParameters.getUserKeys();
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.userDetailsFinder.fromUserKey((String)((Object)it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UserDetails)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getUserKey(), Constants.INSTANCE.getUNKNOWN_USER_KEY()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UserDetails)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.actorDtoMapper.fromUserDetails(it, 48));
        }
        List<ActorDto> actors = (List<ActorDto>)destination$iv$iv;
        boolean bl = false;
        List<ActorDto> actors2 = hasUnknownUser ? CollectionsKt.plus((Collection)actors, this.actorDtoMapper.fromUserDetails(this.userDetailsFinder.fromUserKey(Constants.INSTANCE.getUNKNOWN_USER_KEY()), 48)) : actors;
        Response response = Response.ok((Object)new ActorsPagedResponseDto(actors2.size(), actors2, new LinksDto(null, null))).build();
        Intrinsics.checkNotNullExpressionValue(response, "build(...)");
        return response;
    }
}

