/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest;

import com.atlassian.lighthouse.rest.RestObjectMapper;
import com.atlassian.lighthouse.rest.dto.GuardStatusDto;
import com.atlassian.lighthouse.service.feature.flagging.FeatureFlagRegistry;
import com.atlassian.lighthouse.service.feature.flagging.FeatureFlagService;
import com.atlassian.lighthouse.service.guard.GuardDetectService;
import com.atlassian.lighthouse.service.guard.GuardIntegrationMonitor;
import com.atlassian.lighthouse.service.guard.dto.GuardStatus;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Path(value="/guard-status")
@Produces(value={"application/json"})
@Provider
@LicensedOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/rest/GuardStatusResource;", "", "guardDetectService", "Lcom/atlassian/lighthouse/service/guard/GuardDetectService;", "guardIntegrationMonitor", "Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;", "featureFlagService", "Lcom/atlassian/lighthouse/service/feature/flagging/FeatureFlagService;", "jsonMapper", "Lcom/atlassian/lighthouse/rest/RestObjectMapper;", "(Lcom/atlassian/lighthouse/service/guard/GuardDetectService;Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;Lcom/atlassian/lighthouse/service/feature/flagging/FeatureFlagService;Lcom/atlassian/lighthouse/rest/RestObjectMapper;)V", "getGuardStatus", "Ljakarta/ws/rs/core/Response;", "atlassian-lighthouse-rest"})
@SourceDebugExtension(value={"SMAP\nGuardStatusResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuardStatusResource.kt\ncom/atlassian/lighthouse/rest/GuardStatusResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public class GuardStatusResource {
    @NotNull
    private final GuardDetectService guardDetectService;
    @NotNull
    private final GuardIntegrationMonitor guardIntegrationMonitor;
    @NotNull
    private final FeatureFlagService featureFlagService;
    @NotNull
    private final RestObjectMapper jsonMapper;

    @Inject
    public GuardStatusResource(@NotNull GuardDetectService guardDetectService, @NotNull GuardIntegrationMonitor guardIntegrationMonitor, @NotNull FeatureFlagService featureFlagService, @NotNull RestObjectMapper jsonMapper) {
        Intrinsics.checkNotNullParameter(guardDetectService, "guardDetectService");
        Intrinsics.checkNotNullParameter(guardIntegrationMonitor, "guardIntegrationMonitor");
        Intrinsics.checkNotNullParameter(featureFlagService, "featureFlagService");
        Intrinsics.checkNotNullParameter((Object)jsonMapper, "jsonMapper");
        this.guardDetectService = guardDetectService;
        this.guardIntegrationMonitor = guardIntegrationMonitor;
        this.featureFlagService = featureFlagService;
        this.jsonMapper = jsonMapper;
    }

    @GET
    @NotNull
    public final Response getGuardStatus() {
        Object object;
        GuardStatus guardStatus;
        block5: {
            block4: {
                if (!this.featureFlagService.isFeatureEnabled(FeatureFlagRegistry.INSTANCE.getGUARD_DETECT_INTEGRATION())) {
                    Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                    Intrinsics.checkNotNullExpressionValue(response, "build(...)");
                    return response;
                }
                guardStatus = this.guardIntegrationMonitor.getGuardStatusFromLocalCache();
                String string = guardStatus.getGuardWorkspaceAri();
                String guardWorkspaceId = string != null ? StringsKt.substringAfterLast$default(string, "/", null, 2, null) : null;
                object = guardWorkspaceId;
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                String string2 = "/w/" + it;
                object = string2;
                if (string2 != null) break block5;
            }
            object = "";
        }
        String guardDetectUrlParams = object;
        GuardStatusDto guardStatusDto = new GuardStatusDto(guardStatus.getAcceptingAlerts(), guardStatus.getGuardRejectionReasons(), guardStatus.getUpdatedTimestamp(), this.guardDetectService.getGuardDetectWebpageUrl() + guardDetectUrlParams);
        Response response = Response.ok((Object)this.jsonMapper.writeValueAsString(guardStatusDto)).build();
        Intrinsics.checkNotNullExpressionValue(response, "build(...)");
        return response;
    }
}

