/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.actor;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.lighthouse.rest.actor.ActorUrlsProvider;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/lighthouse/rest/actor/BitbucketActorUrlsProvider;", "Lcom/atlassian/lighthouse/rest/actor/ActorUrlsProvider;", "navBuilder", "Lcom/atlassian/bitbucket/nav/NavBuilder;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "userService", "Lcom/atlassian/bitbucket/user/UserService;", "(Lcom/atlassian/bitbucket/nav/NavBuilder;Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/bitbucket/user/UserService;)V", "getNavBuilder", "()Lcom/atlassian/bitbucket/nav/NavBuilder;", "getUserManager", "()Lcom/atlassian/sal/api/user/UserManager;", "getUserService", "()Lcom/atlassian/bitbucket/user/UserService;", "getAvatarUrl", "", "userDetails", "Lcom/atlassian/lighthouse/service/user/UserDetails;", "avatarSize", "", "getManageActorUrl", "atlassian-lighthouse-rest"})
public final class BitbucketActorUrlsProvider
implements ActorUrlsProvider {
    @NotNull
    private final NavBuilder navBuilder;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final UserService userService;

    public BitbucketActorUrlsProvider(@NotNull NavBuilder navBuilder, @NotNull UserManager userManager, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter(navBuilder, "navBuilder");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(userService, "userService");
        this.navBuilder = navBuilder;
        this.userManager = userManager;
        this.userService = userService;
    }

    @NotNull
    public final NavBuilder getNavBuilder() {
        return this.navBuilder;
    }

    @NotNull
    public final UserManager getUserManager() {
        return this.userManager;
    }

    @NotNull
    public final UserService getUserService() {
        return this.userService;
    }

    @Override
    @Nullable
    public String getManageActorUrl(@NotNull UserDetails userDetails) {
        ApplicationUser bitbucketUser;
        Intrinsics.checkNotNullParameter(userDetails, "userDetails");
        Integer n = StringsKt.toIntOrNull(userDetails.getUserKey());
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            v1 = this.userService.getUserById(it);
        } else {
            v1 = bitbucketUser = null;
        }
        if (bitbucketUser == null) {
            return null;
        }
        return this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey()) ? this.navBuilder.admin().users().view(bitbucketUser.getName()).buildRelative() : this.navBuilder.user(bitbucketUser).buildRelative();
    }

    @Override
    @Nullable
    public String getAvatarUrl(@NotNull UserDetails userDetails, int avatarSize) {
        Intrinsics.checkNotNullParameter(userDetails, "userDetails");
        Object object = this.userManager.getUserProfile(new UserKey(userDetails.getUserKey()));
        return object != null && (object = object.getProfilePictureUri(avatarSize, avatarSize)) != null ? ((URI)object).toString() : null;
    }
}

