/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.dto.mapper;

import com.atlassian.lighthouse.rest.actor.ActorUrlsProvider;
import com.atlassian.lighthouse.rest.dto.ActorDto;
import com.atlassian.lighthouse.rest.dto.AdminTypeDto;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.sal.api.message.I18nResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/rest/dto/mapper/ActorDtoMapper;", "", "actorUrlsProvider", "Lcom/atlassian/lighthouse/rest/actor/ActorUrlsProvider;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "(Lcom/atlassian/lighthouse/rest/actor/ActorUrlsProvider;Lcom/atlassian/sal/api/message/I18nResolver;)V", "fromUserDetails", "Lcom/atlassian/lighthouse/rest/dto/ActorDto;", "userDetails", "Lcom/atlassian/lighthouse/service/user/UserDetails;", "avatarSize", "", "atlassian-lighthouse-rest"})
public final class ActorDtoMapper {
    @NotNull
    private final ActorUrlsProvider actorUrlsProvider;
    @NotNull
    private final I18nResolver i18nResolver;

    public ActorDtoMapper(@NotNull ActorUrlsProvider actorUrlsProvider, @NotNull I18nResolver i18nResolver) {
        Intrinsics.checkNotNullParameter(actorUrlsProvider, "actorUrlsProvider");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        this.actorUrlsProvider = actorUrlsProvider;
        this.i18nResolver = i18nResolver;
    }

    @NotNull
    public final ActorDto fromUserDetails(@NotNull UserDetails userDetails, int avatarSize) {
        Intrinsics.checkNotNullParameter(userDetails, "userDetails");
        switch (userDetails.getUserKey()) {
            case "-1": {
                String string = this.i18nResolver.getText("lighthouse.meta-users.system.display-name");
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return new ActorDto(string, null, userDetails.getUserKey(), AdminTypeDto.NON_ADMIN, true, null, null, 96, null);
            }
            case "-2": {
                String string = this.i18nResolver.getText("lighthouse.meta-users.anonymous.display-name");
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return new ActorDto(string, null, userDetails.getUserKey(), AdminTypeDto.NON_ADMIN, true, null, null, 96, null);
            }
            case "-3": {
                String string = this.i18nResolver.getText("lighthouse.meta-users.unknown.display-name");
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return new ActorDto(string, null, userDetails.getUserKey(), AdminTypeDto.NON_ADMIN, true, null, null, 96, null);
            }
        }
        String string = userDetails.getFullName();
        if (string == null) {
            string = userDetails.getUsername();
        }
        String string2 = string;
        String string3 = this.actorUrlsProvider.getAvatarUrl(userDetails, avatarSize);
        String string4 = this.actorUrlsProvider.getManageActorUrl(userDetails);
        String string5 = userDetails.getUserKey();
        AdminTypeDto adminTypeDto = userDetails.getISystemAdmin() ? AdminTypeDto.SYS_ADMIN : (userDetails.isAdmin() ? AdminTypeDto.ADMIN : AdminTypeDto.NON_ADMIN);
        String string6 = userDetails.getUsername();
        return new ActorDto(string2, string3, string5, adminTypeDto, false, string6, string4, 16, null);
    }
}

