/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.rest.i18n;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.rest.i18n.AlertSummary;
import com.atlassian.lighthouse.rest.i18n.AlertSummaryBuilder;
import com.atlassian.lighthouse.rest.i18n.AlertSummaryDefinition;
import com.atlassian.lighthouse.rest.i18n.AlertSummaryProvider;
import com.atlassian.lighthouse.rest.i18n.CacDocumentationLink;
import com.atlassian.lighthouse.rest.i18n.DocumentationLink;
import com.atlassian.lighthouse.rest.i18n.UserLink;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/lighthouse/rest/i18n/AlertSummaryProvider;", "", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "localeResolver", "Lcom/atlassian/sal/api/message/LocaleResolver;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "(Lcom/atlassian/sal/api/ApplicationProperties;Lcom/atlassian/sal/api/message/I18nResolver;Lcom/atlassian/sal/api/message/LocaleResolver;Lcom/atlassian/sal/api/user/UserManager;)V", "summaryDefinitions", "", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "Lcom/atlassian/lighthouse/rest/i18n/AlertSummaryDefinition;", "getBitbucketSummaryDefinition", "alertType", "getConfluenceSummaryDefinition", "getGroupLink", "", "groupName", "getJiraSummaryDefinition", "getSummary", "Lcom/atlassian/lighthouse/rest/i18n/AlertSummary;", "alert", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "getThreatEntityAttribute", "key", "getUserLink", "Lcom/atlassian/lighthouse/rest/i18n/UserLink;", "username", "Companion", "atlassian-lighthouse-rest"})
@SourceDebugExtension(value={"SMAP\nAlertSummaryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertSummaryProvider.kt\ncom/atlassian/lighthouse/rest/i18n/AlertSummaryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1303:1\n1#2:1304\n1549#3:1305\n1620#3,3:1306\n*S KotlinDebug\n*F\n+ 1 AlertSummaryProvider.kt\ncom/atlassian/lighthouse/rest/i18n/AlertSummaryProvider\n*L\n1285#1:1305\n1285#1:1306,3\n*E\n"})
public final class AlertSummaryProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final I18nResolver i18nResolver;
    @NotNull
    private final LocaleResolver localeResolver;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private Map<AlertType, AlertSummaryDefinition> summaryDefinitions;
    @NotNull
    public static final String ENTERPRISE_CAC_SPACE = "ENTERPRISE";
    @NotNull
    private static final DocumentationLink AUTH_METHODS_CAC_PAGE = com.atlassian.lighthouse.rest.i18n.AlertSummaryProvider$Companion.access$cacLink(Companion, "ENTERPRISE", "Using multiple identity providers");
    @NotNull
    private static final DocumentationLink DISABLE_BASIC_AUTH_CAC_PAGE = com.atlassian.lighthouse.rest.i18n.AlertSummaryProvider$Companion.access$cacLink(Companion, "ENTERPRISE", "Disabling basic authentication");
    @NotNull
    private static final DocumentationLink MANAGE_2SV_CAC_PAGE = com.atlassian.lighthouse.rest.i18n.AlertSummaryProvider$Companion.access$cacLink(Companion, "ENTERPRISE", "Manage two-step verification for your Atlassian account");

    public AlertSummaryProvider(@NotNull ApplicationProperties applicationProperties, @NotNull I18nResolver i18nResolver, @NotNull LocaleResolver localeResolver, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(applicationProperties, "applicationProperties");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter(localeResolver, "localeResolver");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        this.applicationProperties = applicationProperties;
        this.i18nResolver = i18nResolver;
        this.localeResolver = localeResolver;
        this.userManager = userManager;
        this.summaryDefinitions = new LinkedHashMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final AlertSummary getSummary(@NotNull AlertEntity alert) {
        Intrinsics.checkNotNullParameter(alert, "alert");
        Locale locale = this.localeResolver.getLocale();
        AlertSummaryDefinition summaryDefinition2 = this.summaryDefinitions.computeIfAbsent(alert.getAlertType(), arg_0 -> AlertSummaryProvider.getSummary$lambda$0(new Function1<AlertType, AlertSummaryDefinition>(this, alert){
            final /* synthetic */ AlertSummaryProvider this$0;
            final /* synthetic */ AlertEntity $alert;
            {
                this.this$0 = $receiver;
                this.$alert = $alert;
                super(1);
            }

            @Nullable
            public final AlertSummaryDefinition invoke(@NotNull AlertType it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                return switch (AlertSummaryProvider.access$getApplicationProperties$p(this.this$0).getPlatformId()) {
                    case "bitbucket" -> AlertSummaryProvider.access$getBitbucketSummaryDefinition(this.this$0, this.$alert.getAlertType());
                    case "conf" -> AlertSummaryProvider.access$getConfluenceSummaryDefinition(this.this$0, this.$alert.getAlertType());
                    case "jira" -> AlertSummaryProvider.access$getJiraSummaryDefinition(this.this$0, this.$alert.getAlertType());
                    default -> null;
                };
            }
        }, arg_0));
        if (summaryDefinition2 == null) return null;
        Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder> function2 = summaryDefinition2.getBuilderVisitor();
        if (function2 == null) return null;
        Intrinsics.checkNotNull(locale);
        AlertSummaryBuilder alertSummaryBuilder = function2.invoke(new AlertSummaryBuilder(summaryDefinition2, this.i18nResolver, this.applicationProperties, locale), alert);
        if (alertSummaryBuilder == null) return null;
        AlertSummary alertSummary = alertSummaryBuilder.build(alert);
        return alertSummary;
    }

    private final AlertSummaryDefinition getBitbucketSummaryDefinition(AlertType alertType) {
        if (!Intrinsics.areEqual(this.applicationProperties.getPlatformId(), "bitbucket")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DocumentationLink usersAndGroupsCacPage = AlertSummaryProvider.Companion.cacLink("Users and groups");
        DocumentationLink globalPermissionsPage = AlertSummaryProvider.Companion.cacLink("Global permissions");
        DocumentationLink announcementBannerCacPage = AlertSummaryProvider.Companion.cacLink("Add a system-wide announcement banner");
        DocumentationLink manageAppsPage = AlertSummaryProvider.Companion.cacLink("Managing apps");
        DocumentationLink userDirectoriesPage = AlertSummaryProvider.Companion.cacLink("External user directories");
        DocumentationLink loggingAndProfilingPage = AlertSummaryProvider.Companion.cacLink("Enable debug logging");
        return switch (WhenMappings.$EnumSwitchMapping$0[alertType.ordinal()]) {
            case 1 -> new AlertSummaryDefinition("lighthouse.alert.summary.advanced-auditing-config-modified.bitbucket", 0, SetsKt.setOf("doc-link"), getBitbucketSummaryDefinition.1.INSTANCE);
            case 2 -> new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-deleted.bitbucket.2", 1, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                final /* synthetic */ AlertSummaryProvider this$0;
                final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                {
                    this.this$0 = $receiver;
                    this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alert, "alert");
                    String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                    return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).arg(adminGroup);
                }
            });
            case 3 -> {
                String[] var8_9 = new String[]{"doc-link", "group-link"};
                AlertSummaryDefinition v1 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-permission-added.2", 1, SetsKt.setOf(var8_9), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, globalPermissionsPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $globalPermissionsPage;
                    {
                        this.this$0 = $receiver;
                        this.$globalPermissionsPage = $globalPermissionsPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        return $this$$receiver.docLink("doc-link", this.$globalPermissionsPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).arg(adminGroup);
                    }
                });
                yield v1;
            }
            case 4 -> {
                String[] var8_10 = new String[]{"doc-link", "group-link"};
                AlertSummaryDefinition v2 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-permission-deleted.2", 1, SetsKt.setOf(var8_10), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, globalPermissionsPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $globalPermissionsPage;
                    {
                        this.this$0 = $receiver;
                        this.$globalPermissionsPage = $globalPermissionsPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        return $this$$receiver.docLink("doc-link", this.$globalPermissionsPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).arg(adminGroup);
                    }
                });
                yield v2;
            }
            case 5 -> new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-deleted", 1, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                final /* synthetic */ AlertSummaryProvider this$0;
                final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                {
                    this.this$0 = $receiver;
                    this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alert, "alert");
                    String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                    return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).arg(username);
                }
            });
            case 6 -> {
                String[] var8_11 = new String[]{"doc-link", "user-link", "group-link"};
                AlertSummaryDefinition v3 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-added-to-group", 2, SetsKt.setOf(var8_11), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(adminGroup);
                    }
                });
                yield v3;
            }
            case 7 -> {
                String[] var8_12 = new String[]{"doc-link", "user-link", "group-link"};
                AlertSummaryDefinition v4 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-deleted-from-group", 2, SetsKt.setOf(var8_12), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(adminGroup);
                    }
                });
                yield v4;
            }
            case 8 -> {
                String[] var8_13 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v5 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-permission-added", 1, SetsKt.setOf(var8_13), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, globalPermissionsPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $globalPermissionsPage;
                    {
                        this.this$0 = $receiver;
                        this.$globalPermissionsPage = $globalPermissionsPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$globalPermissionsPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v5;
            }
            case 9 -> {
                String[] var8_14 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v6 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-permission-deleted", 1, SetsKt.setOf(var8_14), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, globalPermissionsPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $globalPermissionsPage;
                    {
                        this.this$0 = $receiver;
                        this.$globalPermissionsPage = $globalPermissionsPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$globalPermissionsPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v6;
            }
            case 10 -> {
                String[] var8_15 = new String[]{"doc-link", "user-link", "security-group-link"};
                AlertSummaryDefinition v7 = new AlertSummaryDefinition("lighthouse.alert.summary.user-added-to-security-group", 2, SetsKt.setOf(var8_15), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String securityGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.user.name");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).link("security-group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, securityGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(securityGroup);
                    }
                });
                yield v7;
            }
            case 11 -> {
                String[] var8_16 = new String[]{"doc-link", "user-link", "security-group-link"};
                AlertSummaryDefinition v8 = new AlertSummaryDefinition("lighthouse.alert.summary.user-removed-from-security-group", 2, SetsKt.setOf(var8_16), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String securityGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.user.name");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).link("security-group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, securityGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(securityGroup);
                    }
                });
                yield v8;
            }
            case 12 -> {
                String[] var8_17 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v9 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-details-modified", 1, SetsKt.setOf(var8_17), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v9;
            }
            case 13 -> {
                String[] var8_18 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v10 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-username-modified.2", 3, SetsKt.setOf(var8_18), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String newUsername = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username.to");
                        String oldUsername = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username.from");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, newUsername);
                        return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(oldUsername).arg(newUsername);
                    }
                });
                yield v10;
            }
            case 14 -> {
                String[] var8_19 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v11 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-password-modified", 1, SetsKt.setOf(var8_19), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, usersAndGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $usersAndGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$usersAndGroupsCacPage = $usersAndGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$usersAndGroupsCacPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v11;
            }
            case 15 -> new AlertSummaryDefinition("lighthouse.alert.summary.announcement-banner-added.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(announcementBannerCacPage){
                final /* synthetic */ DocumentationLink $announcementBannerCacPage;
                {
                    this.$announcementBannerCacPage = $announcementBannerCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$announcementBannerCacPage);
                }
            });
            case 16 -> new AlertSummaryDefinition("lighthouse.alert.summary.announcement-banner-deleted.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(announcementBannerCacPage){
                final /* synthetic */ DocumentationLink $announcementBannerCacPage;
                {
                    this.$announcementBannerCacPage = $announcementBannerCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$announcementBannerCacPage);
                }
            });
            case 17 -> new AlertSummaryDefinition("lighthouse.alert.summary.announcement-banner-updated.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(announcementBannerCacPage){
                final /* synthetic */ DocumentationLink $announcementBannerCacPage;
                {
                    this.$announcementBannerCacPage = $announcementBannerCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$announcementBannerCacPage);
                }
            });
            case 18 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-added.bitbucket", 0, SetsKt.setOf("doc-link"), getBitbucketSummaryDefinition.18.INSTANCE);
            case 19 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-deleted.bitbucket", 0, SetsKt.setOf("doc-link"), getBitbucketSummaryDefinition.19.INSTANCE);
            case 20 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-modified.bitbucket", 0, SetsKt.setOf("doc-link"), getBitbucketSummaryDefinition.20.INSTANCE);
            case 21 -> new AlertSummaryDefinition("lighthouse.alert.summary.basic-authentication-configuration-enabled.bitbucket", 0, SetsKt.setOf("doc-link"), getBitbucketSummaryDefinition.21.INSTANCE);
            case 22 -> new AlertSummaryDefinition("lighthouse.alert.summary.basic-authentication-configuration-disabled.bitbucket", 0, SetsKt.setOf("doc-link"), getBitbucketSummaryDefinition.22.INSTANCE);
            case 23 -> new AlertSummaryDefinition("lighthouse.alert.summary.app-installed.bitbucket", 1, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, manageAppsPage){
                final /* synthetic */ AlertSummaryProvider this$0;
                final /* synthetic */ DocumentationLink $manageAppsPage;
                {
                    this.this$0 = $receiver;
                    this.$manageAppsPage = $manageAppsPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alert, "alert");
                    String appName = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "plugin.name");
                    return $this$$receiver.docLink("doc-link", this.$manageAppsPage).arg(appName);
                }
            });
            case 24 -> new AlertSummaryDefinition("lighthouse.alert.summary.configuration-changed.bitbucket", 0, SetsKt.setOf("doc-link"), getBitbucketSummaryDefinition.24.INSTANCE);
            case 25 -> new AlertSummaryDefinition("lighthouse.alert.summary.logging-enabled.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(loggingAndProfilingPage){
                final /* synthetic */ DocumentationLink $loggingAndProfilingPage;
                {
                    this.$loggingAndProfilingPage = $loggingAndProfilingPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$loggingAndProfilingPage);
                }
            });
            case 26 -> new AlertSummaryDefinition("lighthouse.alert.summary.logging-disabled.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(loggingAndProfilingPage){
                final /* synthetic */ DocumentationLink $loggingAndProfilingPage;
                {
                    this.$loggingAndProfilingPage = $loggingAndProfilingPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$loggingAndProfilingPage);
                }
            });
            case 27 -> new AlertSummaryDefinition("lighthouse.alert.summary.profiling-enabled.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(loggingAndProfilingPage){
                final /* synthetic */ DocumentationLink $loggingAndProfilingPage;
                {
                    this.$loggingAndProfilingPage = $loggingAndProfilingPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$loggingAndProfilingPage);
                }
            });
            case 28 -> new AlertSummaryDefinition("lighthouse.alert.summary.profiling-disabled.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(loggingAndProfilingPage){
                final /* synthetic */ DocumentationLink $loggingAndProfilingPage;
                {
                    this.$loggingAndProfilingPage = $loggingAndProfilingPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$loggingAndProfilingPage);
                }
            });
            case 29 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-added.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(userDirectoriesPage){
                final /* synthetic */ DocumentationLink $userDirectoriesPage;
                {
                    this.$userDirectoriesPage = $userDirectoriesPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$userDirectoriesPage);
                }
            });
            case 30 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-deleted.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(userDirectoriesPage){
                final /* synthetic */ DocumentationLink $userDirectoriesPage;
                {
                    this.$userDirectoriesPage = $userDirectoriesPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$userDirectoriesPage);
                }
            });
            case 31 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-modified.bitbucket", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(userDirectoriesPage){
                final /* synthetic */ DocumentationLink $userDirectoriesPage;
                {
                    this.$userDirectoriesPage = $userDirectoriesPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$userDirectoriesPage);
                }
            });
            case 32 -> {
                String[] var8_20 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v12 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-logged-in-without-2sv", 1, SetsKt.setOf(var8_20), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", AlertSummaryProvider.Companion.getMANAGE_2SV_CAC_PAGE()).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v12;
            }
            default -> null;
        };
    }

    private final AlertSummaryDefinition getConfluenceSummaryDefinition(AlertType alertType) {
        if (!Intrinsics.areEqual(this.applicationProperties.getPlatformId(), "conf")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DocumentationLink groupsCacPage = AlertSummaryProvider.Companion.cacLink("Confluence Groups for Administrators");
        DocumentationLink globalPermissionsPage = AlertSummaryProvider.Companion.cacLink("Global Permissions Overview");
        DocumentationLink editUsersPage = AlertSummaryProvider.Companion.cacLink("Edit User Details");
        DocumentationLink editUsernamePage = AlertSummaryProvider.Companion.cacLink("Change a Username");
        DocumentationLink configureAllowlistPage = AlertSummaryProvider.Companion.cacLink("Configuring the Allowlist");
        DocumentationLink userDirectoriesPage = AlertSummaryProvider.Companion.cacLink("Configuring User Directories");
        DocumentationLink siteWideBannerPage = AlertSummaryProvider.Companion.cacLink("CONFKB", "How to add a site-wide banner");
        return switch (WhenMappings.$EnumSwitchMapping$0[alertType.ordinal()]) {
            case 2 -> new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-deleted.confluence.2", 1, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, groupsCacPage){
                final /* synthetic */ AlertSummaryProvider this$0;
                final /* synthetic */ DocumentationLink $groupsCacPage;
                {
                    this.this$0 = $receiver;
                    this.$groupsCacPage = $groupsCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alert, "alert");
                    String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                    return $this$$receiver.docLink("doc-link", this.$groupsCacPage).arg(adminGroup);
                }
            });
            case 3 -> {
                String[] var9_10 = new String[]{"doc-link", "group-link"};
                AlertSummaryDefinition v1 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-permission-added.2", 1, SetsKt.setOf(var9_10), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, globalPermissionsPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $globalPermissionsPage;
                    {
                        this.this$0 = $receiver;
                        this.$globalPermissionsPage = $globalPermissionsPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        return $this$$receiver.docLink("doc-link", this.$globalPermissionsPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).arg(adminGroup);
                    }
                });
                yield v1;
            }
            case 4 -> {
                String[] var9_11 = new String[]{"doc-link", "group-link"};
                AlertSummaryDefinition v2 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-permission-deleted.2", 1, SetsKt.setOf(var9_11), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, globalPermissionsPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $globalPermissionsPage;
                    {
                        this.this$0 = $receiver;
                        this.$globalPermissionsPage = $globalPermissionsPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        return $this$$receiver.docLink("doc-link", this.$globalPermissionsPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).arg(adminGroup);
                    }
                });
                yield v2;
            }
            case 6 -> {
                String[] var9_12 = new String[]{"doc-link", "user-link", "group-link"};
                AlertSummaryDefinition v3 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-added-to-group", 2, SetsKt.setOf(var9_12), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, groupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $groupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$groupsCacPage = $groupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$groupsCacPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(adminGroup);
                    }
                });
                yield v3;
            }
            case 7 -> {
                String[] var9_13 = new String[]{"doc-link", "user-link", "group-link"};
                AlertSummaryDefinition v4 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-deleted-from-group", 2, SetsKt.setOf(var9_13), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, groupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $groupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$groupsCacPage = $groupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$groupsCacPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(adminGroup);
                    }
                });
                yield v4;
            }
            case 12 -> {
                String[] var9_14 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v5 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-details-modified", 1, SetsKt.setOf(var9_14), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, editUsersPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $editUsersPage;
                    {
                        this.this$0 = $receiver;
                        this.$editUsersPage = $editUsersPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$editUsersPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v5;
            }
            case 13 -> {
                String[] var9_15 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v6 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-username-modified.2", 3, SetsKt.setOf(var9_15), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, editUsernamePage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $editUsernamePage;
                    {
                        this.this$0 = $receiver;
                        this.$editUsernamePage = $editUsernamePage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String newUsername = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username.to");
                        String oldUsername = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username.from");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, newUsername);
                        return $this$$receiver.docLink("doc-link", this.$editUsernamePage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(oldUsername).arg(newUsername);
                    }
                });
                yield v6;
            }
            case 14 -> {
                String[] var9_16 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v7 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-password-modified", 1, SetsKt.setOf(var9_16), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, editUsersPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $editUsersPage;
                    {
                        this.this$0 = $receiver;
                        this.$editUsersPage = $editUsersPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$editUsersPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v7;
            }
            case 8 -> {
                String[] var9_17 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v8 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-permission-added", 1, SetsKt.setOf(var9_17), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, globalPermissionsPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $globalPermissionsPage;
                    {
                        this.this$0 = $receiver;
                        this.$globalPermissionsPage = $globalPermissionsPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$globalPermissionsPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v8;
            }
            case 9 -> {
                String[] var9_18 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v9 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-permission-deleted", 1, SetsKt.setOf(var9_18), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, globalPermissionsPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $globalPermissionsPage;
                    {
                        this.this$0 = $receiver;
                        this.$globalPermissionsPage = $globalPermissionsPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$globalPermissionsPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v9;
            }
            case 10 -> {
                String[] var9_19 = new String[]{"doc-link", "user-link", "security-group-link"};
                AlertSummaryDefinition v10 = new AlertSummaryDefinition("lighthouse.alert.summary.user-added-to-security-group", 2, SetsKt.setOf(var9_19), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, groupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $groupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$groupsCacPage = $groupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        String username;
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String securityGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.name");
                        String string = username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.user.name");
                        Intrinsics.checkNotNull(string);
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, string);
                        return $this$$receiver.docLink("doc-link", this.$groupsCacPage).link("security-group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, securityGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(securityGroup);
                    }
                });
                yield v10;
            }
            case 11 -> {
                String[] var9_20 = new String[]{"doc-link", "user-link", "security-group-link"};
                AlertSummaryDefinition v11 = new AlertSummaryDefinition("lighthouse.alert.summary.user-removed-from-security-group", 2, SetsKt.setOf(var9_20), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, groupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $groupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$groupsCacPage = $groupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        String username;
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String securityGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.name");
                        String string = username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.user.name");
                        Intrinsics.checkNotNull(string);
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, string);
                        return $this$$receiver.docLink("doc-link", this.$groupsCacPage).link("security-group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, securityGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(securityGroup);
                    }
                });
                yield v11;
            }
            case 23 -> new AlertSummaryDefinition("lighthouse.alert.summary.app-installed.confluence", 1, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this){
                final /* synthetic */ AlertSummaryProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alert, "alert");
                    String appName = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "plugin.name");
                    return $this$$receiver.docLink("doc-link", com.atlassian.lighthouse.rest.i18n.AlertSummaryProvider$Companion.access$cacLink(AlertSummaryProvider.Companion, "Managing System and Marketplace Apps")).arg(appName);
                }
            });
            case 1 -> new AlertSummaryDefinition("lighthouse.alert.summary.advanced-auditing-config-modified.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.14.INSTANCE);
            case 24 -> new AlertSummaryDefinition("lighthouse.alert.summary.configuration-changed.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.15.INSTANCE);
            case 18 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-added.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.16.INSTANCE);
            case 19 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-deleted.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.17.INSTANCE);
            case 20 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-modified.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.18.INSTANCE);
            case 22 -> new AlertSummaryDefinition("lighthouse.alert.summary.basic-authentication-configuration-disabled.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.19.INSTANCE);
            case 21 -> new AlertSummaryDefinition("lighthouse.alert.summary.basic-authentication-configuration-enabled.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.20.INSTANCE);
            case 33 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-entry-added.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(configureAllowlistPage){
                final /* synthetic */ DocumentationLink $configureAllowlistPage;
                {
                    this.$configureAllowlistPage = $configureAllowlistPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$configureAllowlistPage);
                }
            });
            case 34 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-entry-deleted.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(configureAllowlistPage){
                final /* synthetic */ DocumentationLink $configureAllowlistPage;
                {
                    this.$configureAllowlistPage = $configureAllowlistPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$configureAllowlistPage);
                }
            });
            case 35 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-entry-modified.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(configureAllowlistPage){
                final /* synthetic */ DocumentationLink $configureAllowlistPage;
                {
                    this.$configureAllowlistPage = $configureAllowlistPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$configureAllowlistPage);
                }
            });
            case 36 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-enabled.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(configureAllowlistPage){
                final /* synthetic */ DocumentationLink $configureAllowlistPage;
                {
                    this.$configureAllowlistPage = $configureAllowlistPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$configureAllowlistPage);
                }
            });
            case 37 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-disabled.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(configureAllowlistPage){
                final /* synthetic */ DocumentationLink $configureAllowlistPage;
                {
                    this.$configureAllowlistPage = $configureAllowlistPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$configureAllowlistPage);
                }
            });
            case 29 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-added.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(userDirectoriesPage){
                final /* synthetic */ DocumentationLink $userDirectoriesPage;
                {
                    this.$userDirectoriesPage = $userDirectoriesPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$userDirectoriesPage);
                }
            });
            case 30 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-deleted.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(userDirectoriesPage){
                final /* synthetic */ DocumentationLink $userDirectoriesPage;
                {
                    this.$userDirectoriesPage = $userDirectoriesPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$userDirectoriesPage);
                }
            });
            case 31 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-updated.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(userDirectoriesPage){
                final /* synthetic */ DocumentationLink $userDirectoriesPage;
                {
                    this.$userDirectoriesPage = $userDirectoriesPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$userDirectoriesPage);
                }
            });
            case 38 -> new AlertSummaryDefinition("lighthouse.alert.summary.site-export-completed.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.29.INSTANCE);
            case 39 -> new AlertSummaryDefinition("lighthouse.alert.summary.site-import-completed.confluence", 0, SetsKt.setOf("doc-link"), getConfluenceSummaryDefinition.30.INSTANCE);
            case 40 -> new AlertSummaryDefinition("lighthouse.alert.summary.site-wide-banner-added.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(siteWideBannerPage){
                final /* synthetic */ DocumentationLink $siteWideBannerPage;
                {
                    this.$siteWideBannerPage = $siteWideBannerPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$siteWideBannerPage);
                }
            });
            case 41 -> new AlertSummaryDefinition("lighthouse.alert.summary.side-wide-banner-updated-or-deleted.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(siteWideBannerPage){
                final /* synthetic */ DocumentationLink $siteWideBannerPage;
                {
                    this.$siteWideBannerPage = $siteWideBannerPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$siteWideBannerPage);
                }
            });
            case 42 -> new AlertSummaryDefinition("lighthouse.alert.summary.side-wide-banner-updated.confluence", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(siteWideBannerPage){
                final /* synthetic */ DocumentationLink $siteWideBannerPage;
                {
                    this.$siteWideBannerPage = $siteWideBannerPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$siteWideBannerPage);
                }
            });
            case 32 -> {
                String[] var9_21 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v12 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-logged-in-without-2sv", 1, SetsKt.setOf(var9_21), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", AlertSummaryProvider.Companion.getMANAGE_2SV_CAC_PAGE()).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v12;
            }
            default -> null;
        };
    }

    private final AlertSummaryDefinition getJiraSummaryDefinition(AlertType alertType) {
        if (!Intrinsics.areEqual(this.applicationProperties.getPlatformId(), "jira")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DocumentationLink jiraManagingGroupsCacPage = AlertSummaryProvider.Companion.cacLink("Managing groups");
        DocumentationLink jiraManageUsersCacPage = AlertSummaryProvider.Companion.cacLink("Managing users");
        DocumentationLink jiraGlobalPermissionsCacPage = AlertSummaryProvider.Companion.cacLink("Managing global permissions");
        DocumentationLink jiraConfigureAnnouncementBannerCacPage = AlertSummaryProvider.Companion.cacLink("Configuring an announcement banner");
        DocumentationLink jiraConfigureAllowlistCacPage = AlertSummaryProvider.Companion.cacLink("Configuring the allowlist");
        DocumentationLink jiraConfigureUserDirectoriesCacPage = AlertSummaryProvider.Companion.cacLink("Configuring user directories");
        return switch (WhenMappings.$EnumSwitchMapping$0[alertType.ordinal()]) {
            case 2 -> new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-deleted.jira", 1, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraManagingGroupsCacPage){
                final /* synthetic */ AlertSummaryProvider this$0;
                final /* synthetic */ DocumentationLink $jiraManagingGroupsCacPage;
                {
                    this.this$0 = $receiver;
                    this.$jiraManagingGroupsCacPage = $jiraManagingGroupsCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alert, "alert");
                    String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                    return $this$$receiver.docLink("doc-link", this.$jiraManagingGroupsCacPage).arg(adminGroup);
                }
            });
            case 3 -> {
                String[] var8_9 = new String[]{"doc-link", "group-link"};
                AlertSummaryDefinition v1 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-permission-added.2", 1, SetsKt.setOf(var8_9), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraGlobalPermissionsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraGlobalPermissionsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraGlobalPermissionsCacPage = $jiraGlobalPermissionsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        return $this$$receiver.docLink("doc-link", this.$jiraGlobalPermissionsCacPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).arg(adminGroup);
                    }
                });
                yield v1;
            }
            case 4 -> {
                String[] var8_10 = new String[]{"doc-link", "group-link"};
                AlertSummaryDefinition v2 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-group-permission-deleted.2", 1, SetsKt.setOf(var8_10), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraGlobalPermissionsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraGlobalPermissionsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraGlobalPermissionsCacPage = $jiraGlobalPermissionsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        return $this$$receiver.docLink("doc-link", this.$jiraGlobalPermissionsCacPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).arg(adminGroup);
                    }
                });
                yield v2;
            }
            case 6 -> {
                String[] var8_11 = new String[]{"doc-link", "user-link", "group-link"};
                AlertSummaryDefinition v3 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-added-to-group", 2, SetsKt.setOf(var8_11), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraManagingGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraManagingGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraManagingGroupsCacPage = $jiraManagingGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$jiraManagingGroupsCacPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(adminGroup);
                    }
                });
                yield v3;
            }
            case 7 -> {
                String[] var8_12 = new String[]{"doc-link", "user-link", "group-link"};
                AlertSummaryDefinition v4 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-deleted-from-group", 2, SetsKt.setOf(var8_12), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraManagingGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraManagingGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraManagingGroupsCacPage = $jiraManagingGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String adminGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$jiraManagingGroupsCacPage).link("group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, adminGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(adminGroup);
                    }
                });
                yield v4;
            }
            case 10 -> {
                String[] var8_13 = new String[]{"doc-link", "user-link", "security-group-link"};
                AlertSummaryDefinition v5 = new AlertSummaryDefinition("lighthouse.alert.summary.user-added-to-security-group", 2, SetsKt.setOf(var8_13), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraManagingGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraManagingGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraManagingGroupsCacPage = $jiraManagingGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String securityGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.user.name");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$jiraManagingGroupsCacPage).link("security-group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, securityGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(securityGroup);
                    }
                });
                yield v5;
            }
            case 11 -> {
                String[] var8_14 = new String[]{"doc-link", "user-link", "security-group-link"};
                AlertSummaryDefinition v6 = new AlertSummaryDefinition("lighthouse.alert.summary.user-removed-from-security-group", 2, SetsKt.setOf(var8_14), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraManagingGroupsCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraManagingGroupsCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraManagingGroupsCacPage = $jiraManagingGroupsCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String securityGroup = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.name");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "security.group.user.name");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$jiraManagingGroupsCacPage).link("security-group-link", AlertSummaryProvider.access$getGroupLink(this.this$0, securityGroup)).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(securityGroup);
                    }
                });
                yield v6;
            }
            case 23 -> new AlertSummaryDefinition("lighthouse.alert.summary.app-installed.jira", 1, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this){
                final /* synthetic */ AlertSummaryProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alert, "alert");
                    String appName = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "plugin.name");
                    return $this$$receiver.docLink("doc-link", com.atlassian.lighthouse.rest.i18n.AlertSummaryProvider$Companion.access$cacLink(AlertSummaryProvider.Companion, "Managing apps")).arg(appName);
                }
            });
            case 1 -> new AlertSummaryDefinition("lighthouse.alert.summary.advanced-auditing-config-modified.jira", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.9.INSTANCE);
            case 24 -> new AlertSummaryDefinition("lighthouse.alert.summary.configuration-changed.jira", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.10.INSTANCE);
            case 43 -> new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-anonymized", 1, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this){
                final /* synthetic */ AlertSummaryProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alert, "alert");
                    String oldUserName = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                    return $this$$receiver.docLink("doc-link", com.atlassian.lighthouse.rest.i18n.AlertSummaryProvider$Companion.access$cacLink(AlertSummaryProvider.Companion, "Anonymizing users")).arg(oldUserName);
                }
            });
            case 12 -> {
                String[] var8_15 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v7 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-details-modified", 1, SetsKt.setOf(var8_15), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraManageUsersCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraManageUsersCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraManageUsersCacPage = $jiraManageUsersCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$jiraManageUsersCacPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v7;
            }
            case 13 -> {
                String[] var8_16 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v8 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-username-modified.2", 3, SetsKt.setOf(var8_16), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraManageUsersCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraManageUsersCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraManageUsersCacPage = $jiraManageUsersCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String newUsername = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username.to");
                        String oldUsername = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username.from");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, newUsername);
                        return $this$$receiver.docLink("doc-link", this.$jiraManageUsersCacPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName()).arg(oldUsername).arg(newUsername);
                    }
                });
                yield v8;
            }
            case 14 -> {
                String[] var8_17 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v9 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-password-modified", 1, SetsKt.setOf(var8_17), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this, jiraManageUsersCacPage){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    final /* synthetic */ DocumentationLink $jiraManageUsersCacPage;
                    {
                        this.this$0 = $receiver;
                        this.$jiraManageUsersCacPage = $jiraManageUsersCacPage;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", this.$jiraManageUsersCacPage).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v9;
            }
            case 15 -> new AlertSummaryDefinition("lighthouse.alert.summary.announcement-banner-added.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureAnnouncementBannerCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureAnnouncementBannerCacPage;
                {
                    this.$jiraConfigureAnnouncementBannerCacPage = $jiraConfigureAnnouncementBannerCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureAnnouncementBannerCacPage);
                }
            });
            case 16 -> new AlertSummaryDefinition("lighthouse.alert.summary.announcement-banner-deleted.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureAnnouncementBannerCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureAnnouncementBannerCacPage;
                {
                    this.$jiraConfigureAnnouncementBannerCacPage = $jiraConfigureAnnouncementBannerCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureAnnouncementBannerCacPage);
                }
            });
            case 17 -> new AlertSummaryDefinition("lighthouse.alert.summary.announcement-banner-updated.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureAnnouncementBannerCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureAnnouncementBannerCacPage;
                {
                    this.$jiraConfigureAnnouncementBannerCacPage = $jiraConfigureAnnouncementBannerCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureAnnouncementBannerCacPage);
                }
            });
            case 18 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-added.jira.2", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.18.INSTANCE);
            case 19 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-deleted.jira.2", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.19.INSTANCE);
            case 20 -> new AlertSummaryDefinition("lighthouse.alert.summary.authentication-method-modified.jira.2", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.20.INSTANCE);
            case 22 -> new AlertSummaryDefinition("lighthouse.alert.summary.basic-authentication-configuration-disabled.jira.2", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.21.INSTANCE);
            case 21 -> new AlertSummaryDefinition("lighthouse.alert.summary.basic-authentication-configuration-enabled.jira.2", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.22.INSTANCE);
            case 44 -> new AlertSummaryDefinition("lighthouse.alert.summary.export-started.jira", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.23.INSTANCE);
            case 45 -> new AlertSummaryDefinition("lighthouse.alert.summary.import-completed.jira", 0, SetsKt.setOf("doc-link"), getJiraSummaryDefinition.24.INSTANCE);
            case 33 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-entry-added.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureAllowlistCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureAllowlistCacPage;
                {
                    this.$jiraConfigureAllowlistCacPage = $jiraConfigureAllowlistCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureAllowlistCacPage);
                }
            });
            case 34 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-entry-deleted.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureAllowlistCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureAllowlistCacPage;
                {
                    this.$jiraConfigureAllowlistCacPage = $jiraConfigureAllowlistCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureAllowlistCacPage);
                }
            });
            case 35 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-entry-modified.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureAllowlistCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureAllowlistCacPage;
                {
                    this.$jiraConfigureAllowlistCacPage = $jiraConfigureAllowlistCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureAllowlistCacPage);
                }
            });
            case 36 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-enabled.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureAllowlistCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureAllowlistCacPage;
                {
                    this.$jiraConfigureAllowlistCacPage = $jiraConfigureAllowlistCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureAllowlistCacPage);
                }
            });
            case 37 -> new AlertSummaryDefinition("lighthouse.alert.summary.allowlist-disabled.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureAllowlistCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureAllowlistCacPage;
                {
                    this.$jiraConfigureAllowlistCacPage = $jiraConfigureAllowlistCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureAllowlistCacPage);
                }
            });
            case 29 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-added.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureUserDirectoriesCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureUserDirectoriesCacPage;
                {
                    this.$jiraConfigureUserDirectoriesCacPage = $jiraConfigureUserDirectoriesCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureUserDirectoriesCacPage);
                }
            });
            case 30 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-deleted.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureUserDirectoriesCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureUserDirectoriesCacPage;
                {
                    this.$jiraConfigureUserDirectoriesCacPage = $jiraConfigureUserDirectoriesCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureUserDirectoriesCacPage);
                }
            });
            case 31 -> new AlertSummaryDefinition("lighthouse.alert.summary.user-directory-updated.jira", 0, SetsKt.setOf("doc-link"), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(jiraConfigureUserDirectoriesCacPage){
                final /* synthetic */ DocumentationLink $jiraConfigureUserDirectoriesCacPage;
                {
                    this.$jiraConfigureUserDirectoriesCacPage = $jiraConfigureUserDirectoriesCacPage;
                    super(2);
                }

                @NotNull
                public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alertEntity) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    Intrinsics.checkNotNullParameter(alertEntity, "<anonymous parameter 0>");
                    return $this$$receiver.docLink("doc-link", this.$jiraConfigureUserDirectoriesCacPage);
                }
            });
            case 32 -> {
                String[] var8_18 = new String[]{"doc-link", "user-link"};
                AlertSummaryDefinition v10 = new AlertSummaryDefinition("lighthouse.alert.summary.admin-user-logged-in-without-2sv", 1, SetsKt.setOf(var8_18), (Function2<? super AlertSummaryBuilder, ? super AlertEntity, AlertSummaryBuilder>)new Function2<AlertSummaryBuilder, AlertEntity, AlertSummaryBuilder>(this){
                    final /* synthetic */ AlertSummaryProvider this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final AlertSummaryBuilder invoke(@NotNull AlertSummaryBuilder $this$$receiver, @NotNull AlertEntity alert) {
                        Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                        Intrinsics.checkNotNullParameter(alert, "alert");
                        String username = AlertSummaryProvider.access$getThreatEntityAttribute(this.this$0, alert, "admin.username");
                        UserLink userLink = AlertSummaryProvider.access$getUserLink(this.this$0, username);
                        return $this$$receiver.docLink("doc-link", AlertSummaryProvider.Companion.getMANAGE_2SV_CAC_PAGE()).link("user-link", userLink.getProfileUrl()).arg(userLink.getDisplayName());
                    }
                });
                yield v10;
            }
            default -> null;
        };
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getGroupLink(String groupName) {
        String string;
        String it;
        block6: {
            String string2 = groupName;
            String string3 = string2;
            if (string2 == null) return null;
            it = string3;
            boolean bl = false;
            String string4 = URLEncoder.encode(it, StandardCharsets.UTF_8);
            string3 = string4;
            if (string4 == null) return null;
            it = string3;
            boolean bl2 = false;
            String string5 = this.applicationProperties.getPlatformId();
            switch (string5.hashCode()) {
                case 3059492: {
                    if (string5.equals("conf")) break;
                    return null;
                }
                case 62589239: {
                    if (!string5.equals("bitbucket")) {
                        return null;
                    }
                    break block6;
                }
                case 3262382: {
                    if (!string5.equals("jira")) return null;
                    string = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE_CANONICAL) + "/secure/admin/user/ViewGroup.jspa?name=" + it;
                    return string;
                }
            }
            string = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE_CANONICAL) + "/admin/users/domembersofgroupsearch.action?membersOfGroupTerm=" + it;
            return string;
        }
        string = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE_CANONICAL) + "/admin/groups/view?name=" + it;
        return string;
        return null;
    }

    private final UserLink getUserLink(String username) {
        UserLink userLink;
        UserProfile userProfile = this.userManager.getUserProfile(username);
        if (userProfile != null) {
            UserProfile it = userProfile;
            boolean bl = false;
            String string = it.getFullName();
            Intrinsics.checkNotNullExpressionValue(string, "getFullName(...)");
            userLink = new UserLink(string, this.applicationProperties.getBaseUrl(UrlMode.RELATIVE_CANONICAL) + it.getProfilePageUri());
        } else {
            String string = username;
            if (string == null) {
                string = this.i18nResolver.getText("lighthouse.meta-users.unknown.display-name");
            }
            String string2 = string;
            Intrinsics.checkNotNull(string2);
            UserLink userLink2 = new UserLink(string2, null);
            userLink = userLink2;
        }
        return userLink;
    }

    /*
     * WARNING - void declaration
     */
    private final String getThreatEntityAttribute(AlertEntity alert, String key) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = alert.getThreatEvents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThreatEventEntity threatEventEntity = (ThreatEventEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getExtraAttributes().get(key));
        }
        return (String)CollectionsKt.firstOrNull(CollectionsKt.filterNotNull((List)destination$iv$iv));
    }

    private static final AlertSummaryDefinition getSummary$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (AlertSummaryDefinition)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ApplicationProperties access$getApplicationProperties$p(AlertSummaryProvider $this) {
        return $this.applicationProperties;
    }

    public static final /* synthetic */ AlertSummaryDefinition access$getBitbucketSummaryDefinition(AlertSummaryProvider $this, AlertType alertType) {
        return $this.getBitbucketSummaryDefinition(alertType);
    }

    public static final /* synthetic */ AlertSummaryDefinition access$getConfluenceSummaryDefinition(AlertSummaryProvider $this, AlertType alertType) {
        return $this.getConfluenceSummaryDefinition(alertType);
    }

    public static final /* synthetic */ AlertSummaryDefinition access$getJiraSummaryDefinition(AlertSummaryProvider $this, AlertType alertType) {
        return $this.getJiraSummaryDefinition(alertType);
    }

    public static final /* synthetic */ String access$getThreatEntityAttribute(AlertSummaryProvider $this, AlertEntity alert, String key) {
        return $this.getThreatEntityAttribute(alert, key);
    }

    public static final /* synthetic */ String access$getGroupLink(AlertSummaryProvider $this, String groupName) {
        return $this.getGroupLink(groupName);
    }

    public static final /* synthetic */ UserLink access$getUserLink(AlertSummaryProvider $this, String username) {
        return $this.getUserLink(username);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/lighthouse/rest/i18n/AlertSummaryProvider$Companion;", "", "()V", "AUTH_METHODS_CAC_PAGE", "Lcom/atlassian/lighthouse/rest/i18n/DocumentationLink;", "getAUTH_METHODS_CAC_PAGE", "()Lcom/atlassian/lighthouse/rest/i18n/DocumentationLink;", "DISABLE_BASIC_AUTH_CAC_PAGE", "getDISABLE_BASIC_AUTH_CAC_PAGE", "ENTERPRISE_CAC_SPACE", "", "MANAGE_2SV_CAC_PAGE", "getMANAGE_2SV_CAC_PAGE", "cacLink", "name", "space", "atlassian-lighthouse-rest"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentationLink getAUTH_METHODS_CAC_PAGE() {
            return AUTH_METHODS_CAC_PAGE;
        }

        @NotNull
        public final DocumentationLink getDISABLE_BASIC_AUTH_CAC_PAGE() {
            return DISABLE_BASIC_AUTH_CAC_PAGE;
        }

        @NotNull
        public final DocumentationLink getMANAGE_2SV_CAC_PAGE() {
            return MANAGE_2SV_CAC_PAGE;
        }

        private final DocumentationLink cacLink(String name) {
            return new CacDocumentationLink(name, null, 2, null);
        }

        private final DocumentationLink cacLink(String space, String name) {
            return new CacDocumentationLink(name, space);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AlertType.values().length];
            try {
                nArray[AlertType.AUDITING_CONFIG_MODIFIED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_GROUP_DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_GROUP_PERMISSION_ADDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_GROUP_PERMISSION_DELETED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_DELETED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_ADDED_TO_GROUP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_DELETED_FROM_GROUP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_PERMISSION_ADDED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_PERMISSION_DELETED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.USER_ADDED_TO_SECURITY_GROUP.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.USER_DELETED_FROM_SECURITY_GROUP.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_DETAILS_CHANGED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USERNAME_CHANGED.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_PASSWORD_CHANGED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ANNOUNCEMENT_BANNER_ADDED.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ANNOUNCEMENT_BANNER_DELETED.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ANNOUNCEMENT_BANNER_UPDATED.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.AUTHENTICATION_METHOD_ADDED.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.AUTHENTICATION_METHOD_DELETED.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.AUTHENTICATION_METHOD_MODIFIED.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.BASIC_AUTHENTICATION_CONFIGURATION_ENABLED.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.BASIC_AUTHENTICATION_CONFIGURATION_DISABLED.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.APP_INSTALLED.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.CONFIGURATION_CHANGED.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.LOGGING_ENABLED.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.LOGGING_DISABLED.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.PROFILING_ENABLED.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.PROFILING_DISABLED.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.USER_DIRECTORY_ADDED.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.USER_DIRECTORY_DELETED.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.USER_DIRECTORY_UPDATED.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_LOGGED_IN_WITHOUT_2SV.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ALLOWLIST_ENTRY_ADDED.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ALLOWLIST_ENTRY_DELETED.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ALLOWLIST_ENTRY_MODIFIED.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ALLOWLIST_ENABLED.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ALLOWLIST_DISABLED.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.SITE_EXPORT_COMPLETED.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.SITE_IMPORT_COMPLETED.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.SITE_WIDE_BANNER_ADDED.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.SITE_WIDE_BANNER_UPDATED_OR_DELETED.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.SITE_WIDE_BANNER_UPDATED.ordinal()] = 42;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.ADMIN_USER_ANONYMIZED.ordinal()] = 43;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.EXPORT_STARTED.ordinal()] = 44;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertType.IMPORT_COMPLETED.ordinal()] = 45;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

