/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.consumer;

import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.api.IgnoreAuditExclusionsPolicy;
import com.atlassian.audit.api.IgnoreAuditPolicy;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.security.service.AuditEventHandlerService;
import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IgnoreAuditPolicy
@IgnoreAuditExclusionsPolicy
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/lighthouse/security/consumer/SecurityAuditConsumer;", "Lcom/atlassian/audit/api/AuditConsumer;", "auditEventHandlerService", "Lcom/atlassian/lighthouse/security/service/AuditEventHandlerService;", "(Lcom/atlassian/lighthouse/security/service/AuditEventHandlerService;)V", "accept", "", "auditEntities", "", "Lcom/atlassian/audit/entity/AuditEntity;", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nSecurityAuditConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecurityAuditConsumer.kt\ncom/atlassian/lighthouse/security/consumer/SecurityAuditConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,33:1\n1855#2,2:34\n11#3:36\n10#3,3:37\n*S KotlinDebug\n*F\n+ 1 SecurityAuditConsumer.kt\ncom/atlassian/lighthouse/security/consumer/SecurityAuditConsumer\n*L\n24#1:34,2\n17#1:36\n17#1:37,3\n*E\n"})
public final class SecurityAuditConsumer
implements AuditConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuditEventHandlerService auditEventHandlerService;
    @NotNull
    private static final Logger logger;

    public SecurityAuditConsumer(@NotNull AuditEventHandlerService auditEventHandlerService) {
        Intrinsics.checkNotNullParameter(auditEventHandlerService, "auditEventHandlerService");
        this.auditEventHandlerService = auditEventHandlerService;
    }

    public void accept(@Nonnull @NotNull List<? extends AuditEntity> auditEntities) {
        Intrinsics.checkNotNullParameter(auditEntities, "auditEntities");
        logger.debug("[Atlassian Lighthouse] - Received " + auditEntities.size() + " audit events");
        Iterable $this$forEach$iv = auditEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AuditEntity it = (AuditEntity)element$iv;
            boolean bl = false;
            try {
                this.auditEventHandlerService.handleAuditEvents(it);
            }
            catch (Exception e) {
                logger.error("[Atlassian Lighthouse] Error while handling audit event: {}", (Object)it, (Object)e);
            }
        }
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        SecurityAuditConsumer.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/security/consumer/SecurityAuditConsumer$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

