/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.detector;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.config.alerts.ChangedValueSettings;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.matchers.audit.log.AuditMatchingAttributes;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.CommonDetectionFunctions;
import com.atlassian.lighthouse.security.detector.DefaultThreatDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J2\u0010\u0015\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00120\n2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/lighthouse/security/detector/ChangedValuesDetector;", "Lcom/atlassian/lighthouse/security/detector/DefaultThreatDetector;", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "auditEventMatchingAttributes", "Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;", "commonDetectionFunctions", "Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "(Lcom/atlassian/lighthouse/security/detector/AlertType;Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;)V", "convertAuditEntityToThreatEventEntityList", "", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "auditEntity", "Lcom/atlassian/audit/entity/AuditEntity;", "isApplicableFor", "", "mapAuditEntityToThreatEventEntityList", "allAttributes", "", "", "userKey", "splitAttributesBySettings", "attributes", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nChangedValuesDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangedValuesDetector.kt\ncom/atlassian/lighthouse/security/detector/ChangedValuesDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1549#2:58\n1620#2,3:59\n1549#2:62\n1620#2,2:63\n766#2:65\n857#2,2:66\n1271#2,2:68\n1285#2,4:70\n1622#2:74\n766#2:75\n857#2,2:76\n*S KotlinDebug\n*F\n+ 1 ChangedValuesDetector.kt\ncom/atlassian/lighthouse/security/detector/ChangedValuesDetector\n*L\n40#1:58\n40#1:59,3\n51#1:62\n51#1:63,2\n53#1:65\n53#1:66,2\n54#1:68,2\n54#1:70,4\n51#1:74\n55#1:75\n55#1:76,2\n*E\n"})
public class ChangedValuesDetector
extends DefaultThreatDetector {
    @NotNull
    private final AuditMatchingAttributes auditEventMatchingAttributes;
    @NotNull
    private final CommonDetectionFunctions commonDetectionFunctions;

    public ChangedValuesDetector(@NotNull AlertType alertType, @NotNull AuditMatchingAttributes auditEventMatchingAttributes, @NotNull CommonDetectionFunctions commonDetectionFunctions) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(auditEventMatchingAttributes, "auditEventMatchingAttributes");
        Intrinsics.checkNotNullParameter(commonDetectionFunctions, "commonDetectionFunctions");
        super(alertType, auditEventMatchingAttributes, commonDetectionFunctions);
        this.auditEventMatchingAttributes = auditEventMatchingAttributes;
        this.commonDetectionFunctions = commonDetectionFunctions;
    }

    @Override
    public boolean isApplicableFor(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        boolean isChangedValuesEvent = this.commonDetectionFunctions.isApplicableFor(auditEntity, this.auditEventMatchingAttributes);
        if (!isChangedValuesEvent) {
            return false;
        }
        boolean securityRelatedChangesDetected = !this.auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity).isEmpty();
        return securityRelatedChangesDetected;
    }

    @Override
    @NotNull
    public List<ThreatEventEntity> convertAuditEntityToThreatEventEntityList(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return this.mapAuditEntityToThreatEventEntityList(auditEntity, this.auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity), this.commonDetectionFunctions.getUserKeyByAuditEntity(auditEntity));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ThreatEventEntity> mapAuditEntityToThreatEventEntityList(AuditEntity auditEntity, Map<String, String> allAttributes, String userKey) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.splitAttributesBySettings(allAttributes);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void extraAttributes;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.commonDetectionFunctions.convertAuditEntityToThreatEventEntity(auditEntity, (Map<String, String>)extraAttributes, userKey));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, String>> splitAttributesBySettings(Map<String, String> attributes) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = ChangedValueSettings.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$associateWith$iv;
            String key;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv;
            void setting;
            ChangedValueSettings changedValueSettings = (ChangedValueSettings)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = new String[]{setting.getFrom(), setting.getTo()};
            object = CollectionsKt.listOf(object);
            boolean $i$f$filter = false;
            void var13_13 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                key = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(attributes.get(key) != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                key = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl3 = false;
                String string = attributes.get(key);
                map.put(t, string);
            }
            collection.add((Map)result$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map extraAttributes = (Map)element$iv$iv;
            boolean bl = false;
            boolean bl4 = !extraAttributes.isEmpty();
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

