/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.detector;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.matchers.audit.log.AuditMatchingAttributes;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.CommonDetectionFunctions;
import com.atlassian.lighthouse.security.detector.DefaultThreatDetector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/lighthouse/security/detector/Without2SVDetector;", "Lcom/atlassian/lighthouse/security/detector/DefaultThreatDetector;", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "auditEventMatchingAttributes", "Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;", "commonDetectionFunctions", "Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;", "(Lcom/atlassian/lighthouse/security/detector/AlertType;Lcom/atlassian/lighthouse/matchers/audit/log/AuditMatchingAttributes;Lcom/atlassian/lighthouse/security/detector/CommonDetectionFunctions;)V", "convertAuditEntityToThreatEventEntityList", "", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "auditEntity", "Lcom/atlassian/audit/entity/AuditEntity;", "atlassian-lighthouse-core"})
public final class Without2SVDetector
extends DefaultThreatDetector {
    @NotNull
    private final AuditMatchingAttributes auditEventMatchingAttributes;
    @NotNull
    private final CommonDetectionFunctions commonDetectionFunctions;

    public Without2SVDetector(@NotNull AlertType alertType, @NotNull AuditMatchingAttributes auditEventMatchingAttributes, @NotNull CommonDetectionFunctions commonDetectionFunctions) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(auditEventMatchingAttributes, "auditEventMatchingAttributes");
        Intrinsics.checkNotNullParameter(commonDetectionFunctions, "commonDetectionFunctions");
        super(alertType, auditEventMatchingAttributes, commonDetectionFunctions);
        this.auditEventMatchingAttributes = auditEventMatchingAttributes;
        this.commonDetectionFunctions = commonDetectionFunctions;
    }

    @Override
    @NotNull
    public List<ThreatEventEntity> convertAuditEntityToThreatEventEntityList(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        HashMap<String, String> extraAttributes = new HashMap<String, String>(this.auditEventMatchingAttributes.getProductSpecificAttributeExtractor().invoke(auditEntity));
        String string = extraAttributes.get("admin.username");
        Intrinsics.checkNotNull(string);
        String userName = string;
        String userKey = this.commonDetectionFunctions.getUserKeyByUserName(userName);
        return CollectionsKt.listOf(this.commonDetectionFunctions.convertAuditEntityToThreatEventEntity(auditEntity, (Map<String, String>)extraAttributes, userKey));
    }
}

