/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.lighthouse.database.dao.AlertManager;
import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.GuardPushStatus;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.notification.NotificationService;
import com.atlassian.lighthouse.notification.exception.NotificationException;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.EmailStatus;
import com.atlassian.lighthouse.service.guard.ApiResponse;
import com.atlassian.lighthouse.service.guard.GuardDetectService;
import com.atlassian.lighthouse.service.guard.GuardIntegrationMonitor;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/lighthouse/security/service/AlertService;", "", "alertManager", "Lcom/atlassian/lighthouse/database/dao/AlertManager;", "notificationService", "Lcom/atlassian/lighthouse/notification/NotificationService;", "guardDetectService", "Lcom/atlassian/lighthouse/service/guard/GuardDetectService;", "guardIntegrationMonitor", "Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;", "(Lcom/atlassian/lighthouse/database/dao/AlertManager;Lcom/atlassian/lighthouse/notification/NotificationService;Lcom/atlassian/lighthouse/service/guard/GuardDetectService;Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;)V", "persistAlertAndSendNotification", "", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "threatEvents", "", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "pushToGuardDetect", "alert", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "trySendNotification", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAlertService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertService.kt\ncom/atlassian/lighthouse/security/service/AlertService\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,89:1\n11#2:90\n10#2,3:91\n*S KotlinDebug\n*F\n+ 1 AlertService.kt\ncom/atlassian/lighthouse/security/service/AlertService\n*L\n25#1:90\n25#1:91,3\n*E\n"})
public final class AlertService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlertManager alertManager;
    @NotNull
    private final NotificationService notificationService;
    @NotNull
    private final GuardDetectService guardDetectService;
    @NotNull
    private final GuardIntegrationMonitor guardIntegrationMonitor;
    @NotNull
    private static final Logger logger;

    public AlertService(@NotNull AlertManager alertManager, @NotNull NotificationService notificationService, @NotNull GuardDetectService guardDetectService, @NotNull GuardIntegrationMonitor guardIntegrationMonitor) {
        Intrinsics.checkNotNullParameter(alertManager, "alertManager");
        Intrinsics.checkNotNullParameter(notificationService, "notificationService");
        Intrinsics.checkNotNullParameter(guardDetectService, "guardDetectService");
        Intrinsics.checkNotNullParameter(guardIntegrationMonitor, "guardIntegrationMonitor");
        this.alertManager = alertManager;
        this.notificationService = notificationService;
        this.guardDetectService = guardDetectService;
        this.guardIntegrationMonitor = guardIntegrationMonitor;
    }

    public final void persistAlertAndSendNotification(@NotNull AlertType alertType, @NotNull List<ThreatEventEntity> threatEvents) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(threatEvents, "threatEvents");
        try {
            AlertEntity alert = this.alertManager.createAlert(alertType, AlertStatus.OPEN, EmailStatus.UNSENT, threatEvents);
            this.trySendNotification(alert);
            this.pushToGuardDetect(alert);
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Error while alerting and notifying; alert type: {}", (Object)alertType, (Object)e);
        }
    }

    private final void trySendNotification(AlertEntity alert) throws IllegalArgumentException, NotificationException {
        EmailStatus status = this.notificationService.sendEmailNotification(alert);
        if (alert.getId() == null) {
            throw new NotificationException("[Atlassian Lighthouse] Alert status is not updated: alert ID is null", null, 2, null);
        }
        this.alertManager.updateEmailStatus(alert.getId(), status);
    }

    @VisibleForTesting
    public final void pushToGuardDetect(@NotNull AlertEntity alert) {
        GuardPushStatus guardPushStatus;
        Intrinsics.checkNotNullParameter(alert, "alert");
        if (!this.guardIntegrationMonitor.canSendAlerts()) {
            logger.debug("[Atlassian Lighthouse] Guard Detect integration is disabled, skipping the push for alert ID: {}", (Object)alert.getId());
            return;
        }
        String string = this.guardIntegrationMonitor.getGuardStatusFromLocalCache().getGuardWorkspaceAri();
        if (string == null) {
            throw new IllegalStateException("No guard workspace uri provided");
        }
        String workspaceAri = string;
        ApiResponse<Map<?, ?>> apiResponse = this.guardDetectService.pushAlertToGuardDetect(alert, workspaceAri);
        ApiResponse<Map<?, ?>> apiResponse2 = apiResponse;
        if (apiResponse2 instanceof ApiResponse.Success) {
            guardPushStatus = GuardPushStatus.PUSHED;
        } else if (apiResponse2 instanceof ApiResponse.Failure) {
            guardPushStatus = GuardPushStatus.FAILED;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        GuardPushStatus guardPushStatus2 = guardPushStatus;
        Long l = alert.getId();
        Intrinsics.checkNotNull(l);
        this.alertManager.logPushAttempt(l, guardPushStatus2);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        AlertService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/security/service/AlertService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

