/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.service;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.detector.ThreatDetector;
import com.atlassian.lighthouse.security.service.AlertDeactivationService;
import com.atlassian.lighthouse.security.service.AlertService;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/lighthouse/security/service/AuditEventHandlerService;", "", "alertDeactivationService", "Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;", "alertService", "Lcom/atlassian/lighthouse/security/service/AlertService;", "threatDetectors", "", "Lcom/atlassian/lighthouse/security/detector/ThreatDetector;", "(Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;Lcom/atlassian/lighthouse/security/service/AlertService;Ljava/util/List;)V", "enabledThreatDetectors", "handleAuditEvent", "", "auditEntity", "Lcom/atlassian/audit/entity/AuditEntity;", "threatDetector", "handleAuditEvents", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAuditEventHandlerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuditEventHandlerService.kt\ncom/atlassian/lighthouse/security/service/AuditEventHandlerService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,49:1\n766#2:50\n857#2,2:51\n1855#2,2:53\n766#2:55\n857#2,2:56\n11#3:58\n10#3,3:59\n*S KotlinDebug\n*F\n+ 1 AuditEventHandlerService.kt\ncom/atlassian/lighthouse/security/service/AuditEventHandlerService\n*L\n20#1:50\n20#1:51,2\n21#1:53,2\n47#1:55\n47#1:56,2\n15#1:58\n15#1:59,3\n*E\n"})
public final class AuditEventHandlerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlertDeactivationService alertDeactivationService;
    @NotNull
    private final AlertService alertService;
    @NotNull
    private final List<ThreatDetector> enabledThreatDetectors;
    @NotNull
    private static final Logger logger;

    public AuditEventHandlerService(@NotNull AlertDeactivationService alertDeactivationService, @NotNull AlertService alertService, @NotNull List<? extends ThreatDetector> threatDetectors) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(threatDetectors, "threatDetectors");
        this.alertDeactivationService = alertDeactivationService;
        this.alertService = alertService;
        this.enabledThreatDetectors = this.enabledThreatDetectors(threatDetectors);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleAuditEvents(@NotNull AuditEntity auditEntity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        Iterable $this$filter$iv = this.enabledThreatDetectors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ThreatDetector it = (ThreatDetector)element$iv$iv;
            boolean bl = false;
            if (!it.isApplicableFor(auditEntity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThreatDetector it = (ThreatDetector)element$iv;
            boolean bl = false;
            this.handleAuditEvent(auditEntity, it);
        }
    }

    private final void handleAuditEvent(AuditEntity auditEntity, ThreatDetector threatDetector) {
        try {
            AlertType alertType = threatDetector.alertType();
            logger.debug("[Atlassian Lighthouse] handling applicable audit event: {}", (Object)alertType);
            List<ThreatEventEntity> threatEvents = threatDetector.convertAuditEntityToThreatEventEntityList(auditEntity);
            this.alertService.persistAlertAndSendNotification(alertType, threatEvents);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{auditEntity.getAuditType().getCategoryI18nKey(), auditEntity.getAuditType().getActionI18nKey(), threatDetector.alertType(), e};
            logger.error("[Atlassian Lighthouse] Error while handling audit event categoryI18nKey = {}, actionI18nKey = {} by {} detector: {}", objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ThreatDetector> enabledThreatDetectors(List<? extends ThreatDetector> threatDetectors) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = threatDetectors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ThreatDetector it = (ThreatDetector)element$iv$iv;
            boolean bl = false;
            if (!(!this.alertDeactivationService.isAlertTypeDisabled(it.alertType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        AuditEventHandlerService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/security/service/AuditEventHandlerService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

