/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.service;

import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.websudo.WebSudoManager;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/security/service/WebSudoEnforcerService;", "", "permissionEnforcer", "Lcom/atlassian/sal/api/permission/PermissionEnforcer;", "webSudoManager", "Lcom/atlassian/sal/api/websudo/WebSudoManager;", "(Lcom/atlassian/sal/api/permission/PermissionEnforcer;Lcom/atlassian/sal/api/websudo/WebSudoManager;)V", "enforceWebSudoIfApplicable", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "shouldEnforceWebSudo", "", "atlassian-lighthouse-core"})
public final class WebSudoEnforcerService {
    @NotNull
    private final PermissionEnforcer permissionEnforcer;
    @NotNull
    private final WebSudoManager webSudoManager;

    public WebSudoEnforcerService(@NotNull PermissionEnforcer permissionEnforcer, @NotNull WebSudoManager webSudoManager) {
        Intrinsics.checkNotNullParameter(permissionEnforcer, "permissionEnforcer");
        Intrinsics.checkNotNullParameter(webSudoManager, "webSudoManager");
        this.permissionEnforcer = permissionEnforcer;
        this.webSudoManager = webSudoManager;
    }

    public final void enforceWebSudoIfApplicable(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter(request, "request");
        if (this.shouldEnforceWebSudo()) {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
    }

    private final boolean shouldEnforceWebSudo() {
        return this.permissionEnforcer.isAdmin() || this.permissionEnforcer.isSystemAdmin();
    }
}

