/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceEvent;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.lang.invoke.MethodHandles;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 '*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002&'B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\r\u0010 \u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001eH\u0002J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\u0006\u0010%\u001a\u00020\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R,\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0015R\b\u0012\u0004\u0012\u00028\u00000\u00008\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001cR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/lighthouse/service/AbstractCachedService;", "T", "Lcom/atlassian/sal/api/lifecycle/LifecycleAware;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "cacheName", "", "rebuildRateInSeconds", "", "(Lcom/atlassian/cache/CacheManager;Ljava/lang/String;J)V", "cacheRebuildTask", "Ljava/util/TimerTask;", "cacheRebuildTimer", "Ljava/util/Timer;", "cachedReference", "Lcom/atlassian/cache/CachedReference;", "getCachedReference", "()Lcom/atlassian/cache/CachedReference;", "invalidationListener", "Lcom/atlassian/lighthouse/service/AbstractCachedService$CacheInvalidationListener;", "getInvalidationListener$annotations", "()V", "getInvalidationListener", "()Lcom/atlassian/lighthouse/service/AbstractCachedService$CacheInvalidationListener;", "isCacheResettable", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "afterPropertiesSet", "", "destroy", "fetchValues", "()Ljava/lang/Object;", "initCacheValues", "onStart", "onStop", "rebuildCache", "CacheInvalidationListener", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAbstractCachedService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCachedService.kt\ncom/atlassian/lighthouse/service/AbstractCachedService\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,109:1\n11#2:110\n10#2,3:111\n*S KotlinDebug\n*F\n+ 1 AbstractCachedService.kt\ncom/atlassian/lighthouse/service/AbstractCachedService\n*L\n33#1:110\n33#1:111,3\n*E\n"})
public abstract class AbstractCachedService<T>
implements LifecycleAware,
InitializingBean,
DisposableBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String cacheName;
    private final long rebuildRateInSeconds;
    @NotNull
    private final CacheInvalidationListener<T> invalidationListener;
    @NotNull
    private final AtomicBoolean isCacheResettable;
    @Nullable
    private volatile TimerTask cacheRebuildTask;
    @NotNull
    private final Timer cacheRebuildTimer;
    @NotNull
    private final CachedReference<T> cachedReference;
    @NotNull
    private static final CacheSettings CACHE_SETTINGS;
    @NotNull
    private static final Logger logger;

    public AbstractCachedService(@NotNull CacheManager cacheManager, @NotNull String cacheName, long rebuildRateInSeconds) {
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(cacheName, "cacheName");
        this.cacheName = cacheName;
        this.rebuildRateInSeconds = rebuildRateInSeconds;
        this.invalidationListener = new CacheInvalidationListener();
        this.isCacheResettable = new AtomicBoolean(true);
        this.cacheRebuildTimer = new Timer("lighthouse-cache-invalidation-timer", true);
        CachedReference cachedReference = cacheManager.getCachedReference(this.cacheName, () -> AbstractCachedService.cachedReference$lambda$0(this), CACHE_SETTINGS);
        Intrinsics.checkNotNullExpressionValue(cachedReference, "getCachedReference(...)");
        this.cachedReference = cachedReference;
    }

    @NotNull
    public final CacheInvalidationListener<T> getInvalidationListener() {
        return this.invalidationListener;
    }

    @VisibleForTesting
    public static /* synthetic */ void getInvalidationListener$annotations() {
    }

    @NotNull
    public final AtomicBoolean isCacheResettable() {
        return this.isCacheResettable;
    }

    @NotNull
    protected final CachedReference<T> getCachedReference() {
        return this.cachedReference;
    }

    public abstract T fetchValues();

    public final void rebuildCache() {
        TimerTask timerTask2 = this.cacheRebuildTask;
        if (timerTask2 != null) {
            timerTask2.cancel();
        }
        this.cacheRebuildTask = new TimerTask(this){
            final /* synthetic */ AbstractCachedService this$0;
            {
                this.this$0 = abstractCachedService;
            }

            public void run() {
                TimerTask $this$rebuildCache_u24lambda_u241 = this;
                boolean bl = false;
                this.this$0.getCachedReference().reset();
                AbstractCachedService.access$getLogger$cp().debug("[Atlassian Lighthouse] Cache reset called for: " + AbstractCachedService.access$getCacheName$p(this.this$0));
            }
        };
        this.cacheRebuildTimer.purge();
        this.cacheRebuildTimer.schedule(this.cacheRebuildTask, TimeUnit.SECONDS.toMillis(this.rebuildRateInSeconds));
    }

    private final void initCacheValues() {
        if (this.isCacheResettable.get()) {
            Object object = this.cachedReference.get();
            Intrinsics.checkNotNullExpressionValue(object, "get(...)");
            Object cache = object;
            logger.debug("[Atlassian Lighthouse] Cache initialised: " + this.cacheName + ", data: " + cache);
        } else {
            logger.debug("[Atlassian Lighthouse] Cache cannot be initialised");
        }
    }

    public void onStart() {
        this.initCacheValues();
    }

    public void onStop() {
    }

    public void afterPropertiesSet() {
        this.cachedReference.addListener((CachedReferenceListener)this.invalidationListener, false);
    }

    public void destroy() {
        this.cachedReference.removeListener((CachedReferenceListener)this.invalidationListener);
    }

    private static final Object cachedReference$lambda$0(AbstractCachedService this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.fetchValues();
    }

    public static final /* synthetic */ String access$getCacheName$p(AbstractCachedService $this) {
        return $this.cacheName;
    }

    static {
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build();
        Intrinsics.checkNotNullExpressionValue(cacheSettings, "build(...)");
        CACHE_SETTINGS = cacheSettings;
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        AbstractCachedService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0016J\u0016\u0010\b\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0016J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/lighthouse/service/AbstractCachedService$CacheInvalidationListener;", "T", "Lcom/atlassian/cache/CachedReferenceListener;", "(Lcom/atlassian/lighthouse/service/AbstractCachedService;)V", "onEvict", "", "event", "Lcom/atlassian/cache/CachedReferenceEvent;", "onReset", "onSet", "atlassian-lighthouse-core"})
    public final class CacheInvalidationListener<T>
    implements CachedReferenceListener<T> {
        public void onEvict(@NotNull CachedReferenceEvent<T> event) {
            Intrinsics.checkNotNullParameter(event, "event");
        }

        public void onReset(@NotNull CachedReferenceEvent<T> event) {
            Intrinsics.checkNotNullParameter(event, "event");
            ((AbstractCachedService)AbstractCachedService.this).initCacheValues();
        }

        public void onSet(@NotNull CachedReferenceEvent<T> event) {
            Intrinsics.checkNotNullParameter(event, "event");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/lighthouse/service/AbstractCachedService$Companion;", "", "()V", "CACHE_SETTINGS", "Lcom/atlassian/cache/CacheSettings;", "getCACHE_SETTINGS", "()Lcom/atlassian/cache/CacheSettings;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CacheSettings getCACHE_SETTINGS() {
            return CACHE_SETTINGS;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

