/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service;

import com.atlassian.audit.core.spi.service.AuditMethodProvider;
import com.atlassian.audit.core.spi.service.BaseUrlProvider;
import com.atlassian.audit.core.spi.service.ClusterNodeProvider;
import com.atlassian.audit.core.spi.service.CurrentUserProvider;
import com.atlassian.audit.core.spi.service.IpAddressProvider;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.service.ThreatEventEntityFactory;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/lighthouse/service/DefaultThreatEventEntityFactory;", "Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;", "auditMethodProvider", "Lcom/atlassian/audit/core/spi/service/AuditMethodProvider;", "baseUrlProvider", "Lcom/atlassian/audit/core/spi/service/BaseUrlProvider;", "clusterNodeProvider", "Lcom/atlassian/audit/core/spi/service/ClusterNodeProvider;", "currentUserProvider", "Lcom/atlassian/audit/core/spi/service/CurrentUserProvider;", "ipAddressProvider", "Lcom/atlassian/audit/core/spi/service/IpAddressProvider;", "securityUserService", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "instantSupplier", "Ljava/util/function/Supplier;", "Ljava/time/Instant;", "(Lcom/atlassian/audit/core/spi/service/AuditMethodProvider;Lcom/atlassian/audit/core/spi/service/BaseUrlProvider;Lcom/atlassian/audit/core/spi/service/ClusterNodeProvider;Lcom/atlassian/audit/core/spi/service/CurrentUserProvider;Lcom/atlassian/audit/core/spi/service/IpAddressProvider;Lcom/atlassian/lighthouse/service/user/SecurityUserService;Ljava/util/function/Supplier;)V", "createThreatEventEntity", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "id", "", "extraAttributes", "", "atlassian-lighthouse-core"})
public final class DefaultThreatEventEntityFactory
implements ThreatEventEntityFactory {
    @NotNull
    private final AuditMethodProvider auditMethodProvider;
    @NotNull
    private final BaseUrlProvider baseUrlProvider;
    @NotNull
    private final ClusterNodeProvider clusterNodeProvider;
    @NotNull
    private final CurrentUserProvider currentUserProvider;
    @NotNull
    private final IpAddressProvider ipAddressProvider;
    @NotNull
    private final SecurityUserService securityUserService;
    @NotNull
    private final Supplier<Instant> instantSupplier;

    public DefaultThreatEventEntityFactory(@NotNull AuditMethodProvider auditMethodProvider, @NotNull BaseUrlProvider baseUrlProvider, @NotNull ClusterNodeProvider clusterNodeProvider, @NotNull CurrentUserProvider currentUserProvider, @NotNull IpAddressProvider ipAddressProvider, @NotNull SecurityUserService securityUserService, @NotNull Supplier<Instant> instantSupplier) {
        Intrinsics.checkNotNullParameter(auditMethodProvider, "auditMethodProvider");
        Intrinsics.checkNotNullParameter(baseUrlProvider, "baseUrlProvider");
        Intrinsics.checkNotNullParameter(clusterNodeProvider, "clusterNodeProvider");
        Intrinsics.checkNotNullParameter(currentUserProvider, "currentUserProvider");
        Intrinsics.checkNotNullParameter(ipAddressProvider, "ipAddressProvider");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        Intrinsics.checkNotNullParameter(instantSupplier, "instantSupplier");
        this.auditMethodProvider = auditMethodProvider;
        this.baseUrlProvider = baseUrlProvider;
        this.clusterNodeProvider = clusterNodeProvider;
        this.currentUserProvider = currentUserProvider;
        this.ipAddressProvider = ipAddressProvider;
        this.securityUserService = securityUserService;
        this.instantSupplier = instantSupplier;
    }

    public /* synthetic */ DefaultThreatEventEntityFactory(AuditMethodProvider auditMethodProvider, BaseUrlProvider baseUrlProvider, ClusterNodeProvider clusterNodeProvider, CurrentUserProvider currentUserProvider, IpAddressProvider ipAddressProvider, SecurityUserService securityUserService, Supplier supplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            supplier = DefaultThreatEventEntityFactory::_init_$lambda$0;
        }
        this(auditMethodProvider, baseUrlProvider, clusterNodeProvider, currentUserProvider, ipAddressProvider, securityUserService, supplier);
    }

    @Override
    @NotNull
    public ThreatEventEntity createThreatEventEntity(@NotNull String id, @NotNull Map<String, String> extraAttributes) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(extraAttributes, "extraAttributes");
        String string = this.auditMethodProvider.currentMethod();
        AuditAuthor auditAuthor = this.currentUserProvider.currentUser();
        Intrinsics.checkNotNullExpressionValue(auditAuthor, "currentUser(...)");
        String string2 = this.securityUserService.getUserKeyByAuditAuthor(auditAuthor);
        Optional optional = this.clusterNodeProvider.currentNodeId();
        Intrinsics.checkNotNullExpressionValue(optional, "currentNodeId(...)");
        String string3 = (String)OptionalsKt.getOrNull(optional);
        String string4 = this.ipAddressProvider.remoteIpAddress();
        String string5 = this.baseUrlProvider.currentBaseUrl();
        Instant instant = this.instantSupplier.get();
        Intrinsics.checkNotNullExpressionValue(instant, "get(...)");
        return new ThreatEventEntity(id, string, extraAttributes, string2, string3, string4, string5, instant);
    }

    private static final Instant _init_$lambda$0() {
        return Instant.now();
    }
}

