/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.bitbucket;

import com.atlassian.audit.core.spi.AuditMethods;
import com.atlassian.audit.core.spi.service.AuditMethodProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/lighthouse/service/bitbucket/BitbucketAuditMethodProvider;", "Lcom/atlassian/audit/core/spi/service/AuditMethodProvider;", "osgiContainerManager", "Lcom/atlassian/plugin/osgi/container/OsgiContainerManager;", "requestManager", "Lcom/atlassian/bitbucket/request/RequestManager;", "(Lcom/atlassian/plugin/osgi/container/OsgiContainerManager;Lcom/atlassian/bitbucket/request/RequestManager;)V", "serviceTracker", "Lorg/osgi/util/tracker/ServiceTracker;", "Lcom/atlassian/oauth2/scopes/api/ScopesRequestCache;", "currentMethod", "", "getApplicationNameForRequest", "onPluginFrameworkStarted", "", "event", "Lcom/atlassian/plugin/event/events/PluginFrameworkStartedEvent;", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nBitbucketAuditMethodProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitbucketAuditMethodProvider.kt\ncom/atlassian/lighthouse/service/bitbucket/BitbucketAuditMethodProvider\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,63:1\n11#2:64\n10#2,3:65\n*S KotlinDebug\n*F\n+ 1 BitbucketAuditMethodProvider.kt\ncom/atlassian/lighthouse/service/bitbucket/BitbucketAuditMethodProvider\n*L\n26#1:64\n26#1:65,3\n*E\n"})
public final class BitbucketAuditMethodProvider
implements AuditMethodProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OsgiContainerManager osgiContainerManager;
    @NotNull
    private final RequestManager requestManager;
    private ServiceTracker<ScopesRequestCache, ScopesRequestCache> serviceTracker;
    @NotNull
    private static final Logger logger;

    public BitbucketAuditMethodProvider(@NotNull OsgiContainerManager osgiContainerManager, @NotNull RequestManager requestManager) {
        Intrinsics.checkNotNullParameter(osgiContainerManager, "osgiContainerManager");
        Intrinsics.checkNotNullParameter(requestManager, "requestManager");
        this.osgiContainerManager = osgiContainerManager;
        this.requestManager = requestManager;
    }

    @EventListener
    public final void onPluginFrameworkStarted(@NotNull PluginFrameworkStartedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ServiceTracker serviceTracker = this.osgiContainerManager.getServiceTracker(ScopesRequestCache.class.getName());
        Intrinsics.checkNotNull(serviceTracker, "null cannot be cast to non-null type org.osgi.util.tracker.ServiceTracker<com.atlassian.oauth2.scopes.api.ScopesRequestCache, com.atlassian.oauth2.scopes.api.ScopesRequestCache>");
        this.serviceTracker = serviceTracker;
    }

    @Nullable
    public String currentMethod() {
        String applicationNameForRequest = this.getApplicationNameForRequest();
        if (applicationNameForRequest != null) {
            return applicationNameForRequest + " - OAuth";
        }
        if (this.requestManager.getRequestMetadata() == null) {
            return AuditMethods.system();
        }
        return AuditMethods.browser();
    }

    private final String getApplicationNameForRequest() {
        try {
            ServiceTracker<ScopesRequestCache, ScopesRequestCache> serviceTracker = this.serviceTracker;
            if (serviceTracker == null) {
                Intrinsics.throwUninitializedPropertyAccessException("serviceTracker");
                serviceTracker = null;
            }
            return ((ScopesRequestCache)serviceTracker.getService()).getApplicationNameForRequest().orElse(null);
        }
        catch (Exception e) {
            logger.info("Failed to get service tracker for BitbucketAuditMethodProvider");
            return null;
        }
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        BitbucketAuditMethodProvider.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/service/bitbucket/BitbucketAuditMethodProvider$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

