/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.confluence;

import com.atlassian.audit.core.spi.AuditMethods;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditMethodProvider;", "", "scopesRequestCacheDelegate", "Lcom/atlassian/confluence/dmz/security/delegate/ScopesRequestCacheDelegate;", "(Lcom/atlassian/confluence/dmz/security/delegate/ScopesRequestCacheDelegate;)V", "currentMethod", "", "getOAuthMethod", "isMobileAppRequest", "", "oauth2ApplicationName", "Companion", "atlassian-lighthouse-core"})
public final class ConfluenceAuditMethodProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    @NotNull
    private static final String OAUTH_METHOD = "OAuth";

    public ConfluenceAuditMethodProvider(@NotNull ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        Intrinsics.checkNotNullParameter(scopesRequestCacheDelegate, "scopesRequestCacheDelegate");
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    @NotNull
    public final String currentMethod() {
        boolean isMobileAppRequest = RequestCacheThreadLocal.getMobileAppRequestHeader() != null;
        Optional oauth2ApplicationName = this.scopesRequestCacheDelegate.getApplicationNameForRequest();
        if (oauth2ApplicationName.isPresent()) {
            Object t = oauth2ApplicationName.get();
            Intrinsics.checkNotNullExpressionValue(t, "get(...)");
            return this.getOAuthMethod(isMobileAppRequest, (String)t);
        }
        if (RequestCacheThreadLocal.getRemoteAddress() == null) {
            String string = AuditMethods.system();
            Intrinsics.checkNotNullExpressionValue(string, "system(...)");
            return string;
        }
        if (isMobileAppRequest) {
            String string = AuditMethods.mobile();
            Intrinsics.checkNotNullExpressionValue(string, "mobile(...)");
            return string;
        }
        String string = AuditMethods.browser();
        Intrinsics.checkNotNullExpressionValue(string, "browser(...)");
        return string;
    }

    private final String getOAuthMethod(boolean isMobileAppRequest, String oauth2ApplicationName) {
        String applicationName = isMobileAppRequest ? AuditMethods.mobile() : oauth2ApplicationName;
        return applicationName + " - OAuth";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditMethodProvider$Companion;", "", "()V", "OAUTH_METHOD", "", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

