/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.confluence;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditUserProvider;", "", "()V", "currentUser", "Lcom/atlassian/audit/entity/AuditAuthor;", "atlassian-lighthouse-core"})
public final class ConfluenceAuditUserProvider {
    @NotNull
    public final AuditAuthor currentUser() {
        AuditAuthor auditAuthor;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            AuditAuthor auditAuthor2 = AuditAuthor.builder().type("user").id(user.getKey().getStringValue()).name(user.getFullName()).build();
            Intrinsics.checkNotNull(auditAuthor2);
            auditAuthor = auditAuthor2;
        } else if (RequestCacheThreadLocal.getRemoteAddress() == null) {
            AuditAuthor auditAuthor3 = AuditAuthor.SYSTEM_AUTHOR;
            Intrinsics.checkNotNull(auditAuthor3);
            auditAuthor = auditAuthor3;
        } else {
            AuditAuthor auditAuthor4 = AuditAuthor.ANONYMOUS_AUTHOR;
            Intrinsics.checkNotNull(auditAuthor4);
            auditAuthor = auditAuthor4;
        }
        return auditAuthor;
    }
}

