/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.group;

import com.atlassian.lighthouse.config.alerts.ChangedValueSettings;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.matchers.atlassian.event.AtlassianEventType;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.service.AlertService;
import com.atlassian.lighthouse.service.ThreatEventEntityFactory;
import com.atlassian.lighthouse.service.event.EventToThreatsService;
import com.atlassian.lighthouse.service.user.cache.CachedAdminUserService;
import com.atlassian.lighthouse.service.user.supplier.AdminUsernamesFinder;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0001$B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J=\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u0002H\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010H\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/lighthouse/service/group/AdminChangeHandler;", "", "adminUsernamesFinder", "Lcom/atlassian/lighthouse/service/user/supplier/AdminUsernamesFinder;", "alertService", "Lcom/atlassian/lighthouse/security/service/AlertService;", "cachedAdminUserService", "Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;", "eventToThreatsService", "Lcom/atlassian/lighthouse/service/event/EventToThreatsService;", "threatEventEntityFactory", "Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;", "requiresUncachedUsernameCheck", "", "(Lcom/atlassian/lighthouse/service/user/supplier/AdminUsernamesFinder;Lcom/atlassian/lighthouse/security/service/AlertService;Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;Lcom/atlassian/lighthouse/service/event/EventToThreatsService;Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;Z)V", "changedValueSettings", "", "Lcom/atlassian/lighthouse/config/alerts/ChangedValueSettings;", "getThreatEntityWithUsername", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "T", "eventType", "Lcom/atlassian/lighthouse/matchers/atlassian/event/AtlassianEventType;", "extraAttributes", "", "", "handleUserChangeEvent", "", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "event", "usernames", "(Lcom/atlassian/lighthouse/security/detector/AlertType;Ljava/lang/Object;Lcom/atlassian/lighthouse/matchers/atlassian/event/AtlassianEventType;Ljava/util/List;)V", "isSysAdminOrAdmin", "isSystemAdminOrAdminUncached", "it", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAdminChangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminChangeHandler.kt\ncom/atlassian/lighthouse/service/group/AdminChangeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,99:1\n1747#2,3:100\n11#3:103\n10#3,3:104\n*S KotlinDebug\n*F\n+ 1 AdminChangeHandler.kt\ncom/atlassian/lighthouse/service/group/AdminChangeHandler\n*L\n84#1:100,3\n96#1:103\n96#1:104,3\n*E\n"})
public final class AdminChangeHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AdminUsernamesFinder adminUsernamesFinder;
    @NotNull
    private final AlertService alertService;
    @NotNull
    private final CachedAdminUserService cachedAdminUserService;
    @NotNull
    private final EventToThreatsService eventToThreatsService;
    @NotNull
    private final ThreatEventEntityFactory threatEventEntityFactory;
    private final boolean requiresUncachedUsernameCheck;
    @NotNull
    private final List<ChangedValueSettings> changedValueSettings;
    @NotNull
    private static final Logger logger;

    public AdminChangeHandler(@NotNull AdminUsernamesFinder adminUsernamesFinder, @NotNull AlertService alertService, @NotNull CachedAdminUserService cachedAdminUserService, @NotNull EventToThreatsService eventToThreatsService, @NotNull ThreatEventEntityFactory threatEventEntityFactory, boolean requiresUncachedUsernameCheck) {
        Intrinsics.checkNotNullParameter(adminUsernamesFinder, "adminUsernamesFinder");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(eventToThreatsService, "eventToThreatsService");
        Intrinsics.checkNotNullParameter(threatEventEntityFactory, "threatEventEntityFactory");
        this.adminUsernamesFinder = adminUsernamesFinder;
        this.alertService = alertService;
        this.cachedAdminUserService = cachedAdminUserService;
        this.eventToThreatsService = eventToThreatsService;
        this.threatEventEntityFactory = threatEventEntityFactory;
        this.requiresUncachedUsernameCheck = requiresUncachedUsernameCheck;
        ChangedValueSettings[] changedValueSettingsArray = new ChangedValueSettings[]{ChangedValueSettings.ADMIN_USER_DETAILS_ACTIVE, ChangedValueSettings.ADMIN_USER_DETAILS_EMAIL, ChangedValueSettings.ADMIN_USER_DETAILS_FULLNAME, ChangedValueSettings.ADMIN_USERNAME};
        this.changedValueSettings = CollectionsKt.listOf(changedValueSettingsArray);
    }

    public final <T> void handleUserChangeEvent(@NotNull AlertType alertType, T event, @NotNull AtlassianEventType<T> eventType, @NotNull List<String> usernames) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        Intrinsics.checkNotNullParameter(eventType, "eventType");
        Intrinsics.checkNotNullParameter(usernames, "usernames");
        if (!this.isSysAdminOrAdmin(usernames)) {
            return;
        }
        Map<String, String> extraAttributes = eventType.getMapEventToExtraAttributes().invoke(event);
        List<ThreatEventEntity> extraAttributesThreats = this.eventToThreatsService.getThreatEntitiesUsingChangedValues(eventType, this.changedValueSettings, extraAttributes);
        if (alertType == AlertType.ADMIN_USER_DETAILS_CHANGED && extraAttributesThreats.isEmpty()) {
            logger.debug("[Atlassian Lighthouse] Skipping {} alert for event: {} as no security attributes changes detected.", (Object)alertType, event);
            return;
        }
        List<ThreatEventEntity> threats = CollectionsKt.plus((Collection)extraAttributesThreats, this.getThreatEntityWithUsername(eventType, extraAttributes));
        this.alertService.persistAlertAndSendNotification(alertType, threats);
    }

    private final <T> ThreatEventEntity getThreatEntityWithUsername(AtlassianEventType<T> eventType, Map<String, String> extraAttributes) {
        String string = eventType.getAlertId();
        String string2 = extraAttributes.get("admin.username");
        Intrinsics.checkNotNull(string2);
        return this.threatEventEntityFactory.createThreatEventEntity(string, MapsKt.mapOf(TuplesKt.to("admin.username", string2)));
    }

    private final boolean isSysAdminOrAdmin(List<String> usernames) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = CollectionsKt.distinct((Iterable)usernames);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(this.cachedAdminUserService.isUsernameInSysAdminOrAdminCache(it) || this.isSystemAdminOrAdminUncached(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isSystemAdminOrAdminUncached(String it) {
        return this.requiresUncachedUsernameCheck && this.adminUsernamesFinder.isSysAdminOrAdminUncached(it);
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        AdminChangeHandler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/service/group/AdminChangeHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

