/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.group;

import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsDeletedEvent;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.service.AlertDeactivationService;
import com.atlassian.lighthouse.security.service.AlertService;
import com.atlassian.lighthouse.service.ThreatEventEntityFactory;
import com.atlassian.lighthouse.service.group.cache.CachedAdminGroupService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0012\u0010\"\u001a\u00020\u001d2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J.\u0010#\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J&\u0010&\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J$\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/lighthouse/service/group/BitbucketGroupChangeHandler;", "", "alertDeactivationService", "Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;", "alertService", "Lcom/atlassian/lighthouse/security/service/AlertService;", "threatEventEntityFactory", "Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;", "cachedAdminGroupService", "Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;", "adminGroupPermissionName", "", "systemAdminGroupPermissionName", "securityGroupName", "(Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;Lcom/atlassian/lighthouse/security/service/AlertService;Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "adminOrSysAdminAttributes", "", "groupName", "username", "permissionType", "getPermissionName", "handleGroupMembershipCreated", "", "groupMembershipsCreatedEvent", "Lcom/atlassian/crowd/event/group/GroupMembershipsCreatedEvent;", "handleGroupMembershipDeleted", "groupMembershipsDeletedEvent", "Lcom/atlassian/crowd/event/group/GroupMembershipsDeletedEvent;", "isAlertEnabled", "", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "isSecurityGroup", "isSysAdminGroup", "isSysAdminOrAdminGroup", "persistAndAlertAdminGroupEvent", "usernames", "", "persistAndAlertSecurityGroupThreat", "securityExtraAttributes", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nBitbucketGroupChangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitbucketGroupChangeHandler.kt\ncom/atlassian/lighthouse/service/group/BitbucketGroupChangeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1855#2,2:130\n1855#2,2:132\n*S KotlinDebug\n*F\n+ 1 BitbucketGroupChangeHandler.kt\ncom/atlassian/lighthouse/service/group/BitbucketGroupChangeHandler\n*L\n74#1:130,2\n90#1:132,2\n*E\n"})
public final class BitbucketGroupChangeHandler {
    @NotNull
    private final AlertDeactivationService alertDeactivationService;
    @NotNull
    private final AlertService alertService;
    @NotNull
    private final ThreatEventEntityFactory threatEventEntityFactory;
    @NotNull
    private final CachedAdminGroupService cachedAdminGroupService;
    @NotNull
    private final String adminGroupPermissionName;
    @NotNull
    private final String systemAdminGroupPermissionName;
    @NotNull
    private final String securityGroupName;

    public BitbucketGroupChangeHandler(@NotNull AlertDeactivationService alertDeactivationService, @NotNull AlertService alertService, @NotNull ThreatEventEntityFactory threatEventEntityFactory, @NotNull CachedAdminGroupService cachedAdminGroupService, @NotNull String adminGroupPermissionName, @NotNull String systemAdminGroupPermissionName, @NotNull String securityGroupName) {
        Intrinsics.checkNotNullParameter(alertDeactivationService, "alertDeactivationService");
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(threatEventEntityFactory, "threatEventEntityFactory");
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(adminGroupPermissionName, "adminGroupPermissionName");
        Intrinsics.checkNotNullParameter(systemAdminGroupPermissionName, "systemAdminGroupPermissionName");
        Intrinsics.checkNotNullParameter(securityGroupName, "securityGroupName");
        this.alertDeactivationService = alertDeactivationService;
        this.alertService = alertService;
        this.threatEventEntityFactory = threatEventEntityFactory;
        this.cachedAdminGroupService = cachedAdminGroupService;
        this.adminGroupPermissionName = adminGroupPermissionName;
        this.systemAdminGroupPermissionName = systemAdminGroupPermissionName;
        this.securityGroupName = securityGroupName;
    }

    public final void handleGroupMembershipCreated(@NotNull GroupMembershipsCreatedEvent groupMembershipsCreatedEvent) {
        Intrinsics.checkNotNullParameter(groupMembershipsCreatedEvent, "groupMembershipsCreatedEvent");
        String groupName = groupMembershipsCreatedEvent.getGroupName();
        Collection collection = groupMembershipsCreatedEvent.getEntityNames();
        Intrinsics.checkNotNullExpressionValue(collection, "getEntityNames(...)");
        List usernames = CollectionsKt.toList(collection);
        if (this.isAlertEnabled(AlertType.USER_ADDED_TO_SECURITY_GROUP)) {
            Intrinsics.checkNotNull(groupName);
            if (this.isSecurityGroup(groupName)) {
                this.persistAndAlertSecurityGroupThreat(AlertType.USER_ADDED_TO_SECURITY_GROUP, usernames, groupName);
            }
        }
        if (this.isAlertEnabled(AlertType.ADMIN_USER_ADDED_TO_GROUP) && this.isSysAdminOrAdminGroup(groupName)) {
            Collection collection2 = usernames;
            Intrinsics.checkNotNull(groupName);
            this.persistAndAlertAdminGroupEvent(AlertType.ADMIN_USER_ADDED_TO_GROUP, collection2, groupName, this.getPermissionName(groupName));
        }
    }

    public final void handleGroupMembershipDeleted(@NotNull GroupMembershipsDeletedEvent groupMembershipsDeletedEvent) {
        Intrinsics.checkNotNullParameter(groupMembershipsDeletedEvent, "groupMembershipsDeletedEvent");
        String groupName = groupMembershipsDeletedEvent.getGroupName();
        Collection collection = groupMembershipsDeletedEvent.getEntityNames();
        Intrinsics.checkNotNullExpressionValue(collection, "getEntityNames(...)");
        List usernames = CollectionsKt.toList(collection);
        if (this.isAlertEnabled(AlertType.USER_DELETED_FROM_SECURITY_GROUP)) {
            Intrinsics.checkNotNull(groupName);
            if (this.isSecurityGroup(groupName)) {
                this.persistAndAlertSecurityGroupThreat(AlertType.USER_DELETED_FROM_SECURITY_GROUP, usernames, groupName);
            }
        }
        if (this.isAlertEnabled(AlertType.ADMIN_USER_DELETED_FROM_GROUP) && this.isSysAdminOrAdminGroup(groupName)) {
            Collection collection2 = usernames;
            Intrinsics.checkNotNull(groupName);
            this.persistAndAlertAdminGroupEvent(AlertType.ADMIN_USER_DELETED_FROM_GROUP, collection2, groupName, this.getPermissionName(groupName));
        }
    }

    private final void persistAndAlertSecurityGroupThreat(AlertType alertType, Collection<String> usernames, String groupName) {
        Iterable $this$forEach$iv = usernames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String username = (String)element$iv;
            boolean bl = false;
            ThreatEventEntity threatEvent = this.threatEventEntityFactory.createThreatEventEntity(alertType.getId(), this.securityExtraAttributes(groupName, username));
            this.alertService.persistAlertAndSendNotification(alertType, CollectionsKt.listOf(threatEvent));
        }
    }

    private final void persistAndAlertAdminGroupEvent(AlertType alertType, Collection<String> usernames, String groupName, String permissionType) {
        Iterable $this$forEach$iv = usernames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String username = (String)element$iv;
            boolean bl = false;
            ThreatEventEntity threatEvent = this.threatEventEntityFactory.createThreatEventEntity(alertType.getId(), this.adminOrSysAdminAttributes(groupName, username, permissionType));
            this.alertService.persistAlertAndSendNotification(alertType, CollectionsKt.listOf(threatEvent));
        }
    }

    private final Map<String, String> securityExtraAttributes(String groupName, String username) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("security.group.name", groupName), TuplesKt.to("security.group.user.name", username)};
        return MapsKt.mapOf(pairArray);
    }

    private final Map<String, String> adminOrSysAdminAttributes(String groupName, String username, String permissionType) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("admin.group.name", groupName), TuplesKt.to("admin.username", username), TuplesKt.to("admin.group.permission.type", permissionType)};
        return MapsKt.mapOf(pairArray);
    }

    private final boolean isAlertEnabled(AlertType alertType) {
        return !this.alertDeactivationService.isAlertTypeDisabled(alertType);
    }

    private final boolean isSecurityGroup(String groupName) {
        return Intrinsics.areEqual(groupName, this.securityGroupName);
    }

    private final String getPermissionName(String groupName) {
        return this.isSysAdminGroup(groupName) ? this.systemAdminGroupPermissionName : this.adminGroupPermissionName;
    }

    private final boolean isSysAdminOrAdminGroup(String groupName) {
        return this.cachedAdminGroupService.isGroupNameInSysAdminOrAdminCache(groupName);
    }

    private final boolean isSysAdminGroup(String groupName) {
        return this.cachedAdminGroupService.isGroupNameInSysAdminCache(groupName);
    }
}

