/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.group;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/lighthouse/service/group/JiraGroupManagerService;", "", "globalPermissionManager", "Lcom/atlassian/jira/security/GlobalPermissionManager;", "groupManager", "Lcom/atlassian/jira/security/groups/GroupManager;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "(Lcom/atlassian/jira/security/GlobalPermissionManager;Lcom/atlassian/jira/security/groups/GroupManager;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;)V", "containsGroupWithPermission", "", "userGroups", "", "", "permissionKey", "Lcom/atlassian/jira/permission/GlobalPermissionKey;", "isSysAdminOrAdmin", "username", "atlassian-lighthouse-core"})
public final class JiraGroupManagerService {
    @NotNull
    private final GlobalPermissionManager globalPermissionManager;
    @NotNull
    private final GroupManager groupManager;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;

    public JiraGroupManagerService(@NotNull GlobalPermissionManager globalPermissionManager, @NotNull GroupManager groupManager, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil) {
        Intrinsics.checkNotNullParameter(globalPermissionManager, "globalPermissionManager");
        Intrinsics.checkNotNullParameter(groupManager, "groupManager");
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        this.globalPermissionManager = globalPermissionManager;
        this.groupManager = groupManager;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
    }

    public final boolean isSysAdminOrAdmin(@Nullable String username) {
        Object v = this.jiraThreadLocalUtil.wrap(() -> JiraGroupManagerService.isSysAdminOrAdmin$lambda$0(this, username)).call();
        Intrinsics.checkNotNullExpressionValue(v, "call(...)");
        return (Boolean)v;
    }

    private final boolean containsGroupWithPermission(Set<String> userGroups, GlobalPermissionKey permissionKey) {
        Collection collection = this.globalPermissionManager.getGroupNamesWithPermission(permissionKey);
        Intrinsics.checkNotNullExpressionValue(collection, "getGroupNamesWithPermission(...)");
        return !((Collection)CollectionsKt.intersect(collection, (Iterable)userGroups)).isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean isSysAdminOrAdmin$lambda$0(JiraGroupManagerService this$0, String $username) {
        boolean bl;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Collection collection = this$0.groupManager.getGroupNamesForUser($username);
        Intrinsics.checkNotNullExpressionValue(collection, "getGroupNamesForUser(...)");
        Set<String> userGroups = CollectionsKt.toSet(collection);
        GlobalPermissionKey globalPermissionKey = GlobalPermissionKey.ADMINISTER;
        Intrinsics.checkNotNullExpressionValue(globalPermissionKey, "ADMINISTER");
        if (!this$0.containsGroupWithPermission(userGroups, globalPermissionKey)) {
            GlobalPermissionKey globalPermissionKey2 = GlobalPermissionKey.SYSTEM_ADMIN;
            Intrinsics.checkNotNullExpressionValue(globalPermissionKey2, "SYSTEM_ADMIN");
            if (!this$0.containsGroupWithPermission(userGroups, globalPermissionKey2)) {
                bl = false;
                return bl;
            }
        }
        bl = true;
        return bl;
    }
}

