/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.group.cache;

import com.atlassian.bitbucket.event.permission.GlobalPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionRevokedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.service.group.cache.CachedAdminGroupService;
import com.atlassian.lighthouse.util.matchers.permissions.BitbucketPermissionFunctions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u001c\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/lighthouse/service/group/cache/BitbucketCachedAdminGroupUpdater;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "cachedAdminGroupService", "Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "(Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;Lcom/atlassian/event/api/EventPublisher;)V", "afterPropertiesSet", "", "destroy", "handleGlobalPermissionUpdated", "newPermission", "Lcom/atlassian/bitbucket/permission/Permission;", "oldPermission", "onGlobalPermissionGranted", "event", "Lcom/atlassian/bitbucket/event/permission/GlobalPermissionGrantedEvent;", "onGlobalPermissionModified", "Lcom/atlassian/bitbucket/event/permission/GlobalPermissionModifiedEvent;", "onGlobalPermissionRevoked", "Lcom/atlassian/bitbucket/event/permission/GlobalPermissionRevokedEvent;", "onGroupDeleted", "Lcom/atlassian/crowd/event/group/GroupDeletedEvent;", "atlassian-lighthouse-core"})
public final class BitbucketCachedAdminGroupUpdater
implements InitializingBean,
DisposableBean {
    @NotNull
    private final CachedAdminGroupService cachedAdminGroupService;
    @NotNull
    private final EventPublisher eventPublisher;

    public BitbucketCachedAdminGroupUpdater(@NotNull CachedAdminGroupService cachedAdminGroupService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        this.cachedAdminGroupService = cachedAdminGroupService;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public final void onGroupDeleted(@NotNull GroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getGroupName();
        Intrinsics.checkNotNullExpressionValue(string, "getGroupName(...)");
        this.cachedAdminGroupService.rebuildAdminGroupCacheIfExists(string);
    }

    @EventListener
    public final void onGlobalPermissionGranted(@NotNull GlobalPermissionGrantedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getAffectedGroup() == null) {
            return;
        }
        Permission permission = event.getPermission();
        Intrinsics.checkNotNullExpressionValue(permission, "getPermission(...)");
        BitbucketCachedAdminGroupUpdater.handleGlobalPermissionUpdated$default(this, permission, null, 2, null);
    }

    @EventListener
    public final void onGlobalPermissionModified(@NotNull GlobalPermissionModifiedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getAffectedGroup() == null) {
            return;
        }
        Permission permission = event.getPermission();
        Intrinsics.checkNotNullExpressionValue(permission, "getPermission(...)");
        this.handleGlobalPermissionUpdated(permission, event.getOldValue());
    }

    @EventListener
    public final void onGlobalPermissionRevoked(@NotNull GlobalPermissionRevokedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getAffectedGroup() == null) {
            return;
        }
        Permission permission = event.getPermission();
        Intrinsics.checkNotNullExpressionValue(permission, "getPermission(...)");
        BitbucketCachedAdminGroupUpdater.handleGlobalPermissionUpdated$default(this, permission, null, 2, null);
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private final void handleGlobalPermissionUpdated(Permission newPermission, Permission oldPermission) {
        if (BitbucketPermissionFunctions.INSTANCE.isAdminOrSysAdminPermission(newPermission) || BitbucketPermissionFunctions.INSTANCE.isAdminOrSysAdminPermission(oldPermission)) {
            this.cachedAdminGroupService.rebuildCache();
        }
    }

    static /* synthetic */ void handleGlobalPermissionUpdated$default(BitbucketCachedAdminGroupUpdater bitbucketCachedAdminGroupUpdater, Permission permission, Permission permission2, int n, Object object) {
        if ((n & 2) != 0) {
            permission2 = null;
        }
        bitbucketCachedAdminGroupUpdater.handleGlobalPermissionUpdated(permission, permission2);
    }
}

