/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.group.cache;

import com.atlassian.confluence.event.events.admin.RestoreLockDatabaseEvent;
import com.atlassian.confluence.event.events.admin.RestoreUnlockDatabaseEvent;
import com.atlassian.confluence.event.events.permission.GlobalPermissionChangeEvent;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.service.group.cache.CachedAdminGroupService;
import com.atlassian.lighthouse.util.matchers.permissions.ConfluencePermissionFunctions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/lighthouse/service/group/cache/ConfluenceCachedAdminGroupUpdater;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "cachedAdminGroupService", "Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "(Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;Lcom/atlassian/event/api/EventPublisher;)V", "afterPropertiesSet", "", "destroy", "onGlobalPermissionChangedEvent", "event", "Lcom/atlassian/confluence/event/events/permission/GlobalPermissionChangeEvent;", "onGroupDeleted", "Lcom/atlassian/crowd/event/group/GroupDeletedEvent;", "onRestoreLockDatabaseEvent", "Lcom/atlassian/confluence/event/events/admin/RestoreLockDatabaseEvent;", "onRestoreUnlockDatabaseEvent", "Lcom/atlassian/confluence/event/events/admin/RestoreUnlockDatabaseEvent;", "atlassian-lighthouse-core"})
public final class ConfluenceCachedAdminGroupUpdater
implements InitializingBean,
DisposableBean {
    @NotNull
    private final CachedAdminGroupService cachedAdminGroupService;
    @NotNull
    private final EventPublisher eventPublisher;

    public ConfluenceCachedAdminGroupUpdater(@NotNull CachedAdminGroupService cachedAdminGroupService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        this.cachedAdminGroupService = cachedAdminGroupService;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public final void onGroupDeleted(@NotNull GroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getGroupName();
        Intrinsics.checkNotNullExpressionValue(string, "getGroupName(...)");
        this.cachedAdminGroupService.rebuildAdminGroupCacheIfExists(string);
    }

    @EventListener
    public final void onGlobalPermissionChangedEvent(@NotNull GlobalPermissionChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        SpacePermission permission = event.getPermission();
        if (permission.isGroupPermission() && ConfluencePermissionFunctions.INSTANCE.isAdminOrSysAdminPermission(permission.getType())) {
            this.cachedAdminGroupService.rebuildCache();
        }
    }

    @EventListener
    public final void onRestoreLockDatabaseEvent(@NotNull RestoreLockDatabaseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminGroupService.isCacheResettable().set(false);
    }

    @EventListener
    public final void onRestoreUnlockDatabaseEvent(@NotNull RestoreUnlockDatabaseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminGroupService.isCacheResettable().set(true);
        this.cachedAdminGroupService.rebuildCache();
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

