/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.group.supplier;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.lighthouse.service.group.supplier.AdminGroupNamesFinder;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/lighthouse/service/group/supplier/JiraAdminGroupNamesFinder;", "Lcom/atlassian/lighthouse/service/group/supplier/AdminGroupNamesFinder;", "globalPermissionManager", "Lcom/atlassian/jira/security/GlobalPermissionManager;", "(Lcom/atlassian/jira/security/GlobalPermissionManager;)V", "getAdminGroupNames", "", "", "getSysAdminGroupNames", "searchByPermission", "permissionKey", "Lcom/atlassian/jira/permission/GlobalPermissionKey;", "atlassian-lighthouse-core"})
public final class JiraAdminGroupNamesFinder
implements AdminGroupNamesFinder {
    @NotNull
    private final GlobalPermissionManager globalPermissionManager;

    public JiraAdminGroupNamesFinder(@NotNull GlobalPermissionManager globalPermissionManager) {
        Intrinsics.checkNotNullParameter(globalPermissionManager, "globalPermissionManager");
        this.globalPermissionManager = globalPermissionManager;
    }

    @Override
    @NotNull
    public Set<String> getAdminGroupNames() {
        GlobalPermissionKey globalPermissionKey = GlobalPermissionKey.ADMINISTER;
        Intrinsics.checkNotNullExpressionValue(globalPermissionKey, "ADMINISTER");
        return this.searchByPermission(globalPermissionKey);
    }

    @Override
    @NotNull
    public Set<String> getSysAdminGroupNames() {
        GlobalPermissionKey globalPermissionKey = GlobalPermissionKey.SYSTEM_ADMIN;
        Intrinsics.checkNotNullExpressionValue(globalPermissionKey, "SYSTEM_ADMIN");
        return this.searchByPermission(globalPermissionKey);
    }

    private final Set<String> searchByPermission(GlobalPermissionKey permissionKey) {
        Collection collection = this.globalPermissionManager.getGroupNamesWithPermission(permissionKey);
        Intrinsics.checkNotNullExpressionValue(collection, "getGroupNamesWithPermission(...)");
        return CollectionsKt.toSet(collection);
    }
}

