/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.guard;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.plugin.PluginInfo;
import com.atlassian.lighthouse.security.service.Constants;
import com.atlassian.lighthouse.service.guard.ApiResponse;
import com.atlassian.lighthouse.service.guard.GuardDetectPayloadMapper;
import com.atlassian.lighthouse.service.guard.graphql.GuardDetectGraphQLQuery;
import com.atlassian.lighthouse.service.guard.graphql.request.CreateAlertPayload;
import com.atlassian.lighthouse.service.guard.graphql.request.CreateAlertsPayload;
import com.atlassian.lighthouse.service.guard.graphql.request.OrgIdData;
import com.atlassian.lighthouse.service.guard.graphql.request.WorkspacePayload;
import com.atlassian.lighthouse.service.guard.graphql.response.createalerts.CreateAlertsResponse;
import com.atlassian.lighthouse.service.guard.graphql.response.workspace.WorkspaceResponse;
import com.atlassian.plugins.cloud.connect.companion.client.CloudContext;
import com.atlassian.plugins.cloud.connect.companion.client.CloudLink;
import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequest;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestMethod;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceLocator;
import com.atlassian.plugins.cloud.connect.companion.client.CloudResponse;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\nJ!\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u0002H\u0018H\u0007\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\nJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0010J\b\u0010\u001e\u001a\u0004\u0018\u00010\nJ$\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 0\u00102\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ(\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0010\"\u0004\b\u0000\u0010\u00182\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u00100$H\u0002J*\u0010%\u001a\b\u0012\u0004\u0012\u0002H&0\u0010\"\u0004\b\u0000\u0010\u0018\"\u0006\b\u0001\u0010&\u0018\u00012\u0006\u0010\u0019\u001a\u0002H\u0018H\u0082\b\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\n8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\n8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/lighthouse/service/guard/GuardDetectService;", "", "cloudRequestServiceLocator", "Lcom/atlassian/plugins/cloud/connect/companion/client/CloudRequestServiceLocator;", "cloudObjectMapper", "Lcom/atlassian/plugins/cloud/connect/companion/client/CloudObjectMapper;", "pluginInfo", "Lcom/atlassian/lighthouse/plugin/PluginInfo;", "(Lcom/atlassian/plugins/cloud/connect/companion/client/CloudRequestServiceLocator;Lcom/atlassian/plugins/cloud/connect/companion/client/CloudObjectMapper;Lcom/atlassian/lighthouse/plugin/PluginInfo;)V", "graphqlGatewayBaseUrlHost", "", "graphqlGatewayBaseUrlPort", "", "graphqlGatewayBaseUrlScheme", "guardDetectWebpageBaseUrl", "batchPushAlertToGuardDetect", "Lcom/atlassian/lighthouse/service/guard/ApiResponse;", "Lcom/atlassian/lighthouse/service/guard/graphql/response/createalerts/CreateAlertsResponse;", "alerts", "", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "workspaceAri", "buildGraphqlRequest", "Lcom/atlassian/plugins/cloud/connect/companion/client/CloudRequest;", "T", "payload", "(Ljava/lang/Object;)Lcom/atlassian/plugins/cloud/connect/companion/client/CloudRequest;", "getGuardDetectWebpageUrl", "getGuardStatus", "Lcom/atlassian/lighthouse/service/guard/graphql/response/workspace/WorkspaceResponse;", "getOrgId", "pushAlertToGuardDetect", "", "alert", "returnFailureResponseOnException", "requestAction", "Lkotlin/Function0;", "sendGuardRequest", "R", "(Ljava/lang/Object;)Lcom/atlassian/lighthouse/service/guard/ApiResponse;", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nGuardDetectService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuardDetectService.kt\ncom/atlassian/lighthouse/service/guard/GuardDetectService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n+ 4 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,147:1\n1#2:148\n30#3:149\n11#4:150\n10#4,3:151\n*S KotlinDebug\n*F\n+ 1 GuardDetectService.kt\ncom/atlassian/lighthouse/service/guard/GuardDetectService\n*L\n126#1:149\n144#1:150\n144#1:151,3\n*E\n"})
public final class GuardDetectService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudRequestServiceLocator cloudRequestServiceLocator;
    @NotNull
    private final CloudObjectMapper cloudObjectMapper;
    @NotNull
    private final PluginInfo pluginInfo;
    @Value(value="${graphql.gateway.base.hostname}")
    @NotNull
    private final String graphqlGatewayBaseUrlHost;
    @Value(value="${graphql.gateway.base.scheme}")
    @NotNull
    private final String graphqlGatewayBaseUrlScheme;
    @Value(value="${graphql.gateway.base.port}")
    private final int graphqlGatewayBaseUrlPort;
    @Value(value="${guard.detect.webpage.base.url}")
    @NotNull
    private final String guardDetectWebpageBaseUrl;
    @NotNull
    private static final String PATH = "/gateway/api/graphql";
    @NotNull
    private static final Logger logger;

    public GuardDetectService(@NotNull CloudRequestServiceLocator cloudRequestServiceLocator, @NotNull CloudObjectMapper cloudObjectMapper, @NotNull PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter(cloudRequestServiceLocator, "cloudRequestServiceLocator");
        Intrinsics.checkNotNullParameter(cloudObjectMapper, "cloudObjectMapper");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        this.cloudRequestServiceLocator = cloudRequestServiceLocator;
        this.cloudObjectMapper = cloudObjectMapper;
        this.pluginInfo = pluginInfo;
        this.graphqlGatewayBaseUrlHost = "api.atlassian.com";
        this.graphqlGatewayBaseUrlScheme = "https";
        this.graphqlGatewayBaseUrlPort = -1;
        this.guardDetectWebpageBaseUrl = "https://detect.atlassian.com";
    }

    @NotNull
    public final ApiResponse<Map<?, ?>> pushAlertToGuardDetect(@NotNull AlertEntity alert, @NotNull String workspaceAri) {
        Intrinsics.checkNotNullParameter(alert, "alert");
        Intrinsics.checkNotNullParameter(workspaceAri, "workspaceAri");
        return this.returnFailureResponseOnException(new Function0<ApiResponse<? extends Map<?, ?>>>(alert, workspaceAri, this){
            final /* synthetic */ AlertEntity $alert;
            final /* synthetic */ String $workspaceAri;
            final /* synthetic */ GuardDetectService this$0;
            {
                this.$alert = $alert;
                this.$workspaceAri = $workspaceAri;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ApiResponse<Map<?, ?>> invoke() {
                ApiResponse apiResponse;
                CreateAlertPayload payload = GuardDetectPayloadMapper.INSTANCE.getCreateAlertPayload(this.$alert, this.$workspaceAri, GuardDetectService.access$getPluginInfo$p(this.this$0).getProductId(), GuardDetectGraphQLQuery.INSTANCE.getCREATE_ALERT_QUERY$atlassian_lighthouse_core());
                GuardDetectService this_$iv = this.this$0;
                boolean $i$f$sendGuardRequest = false;
                CloudRequest<CreateAlertPayload> cloudRequest$iv = this_$iv.buildGraphqlRequest(payload);
                CloudResponse<Map> cloudResponse$iv = GuardDetectService.access$getCloudRequestServiceLocator$p(this_$iv).sendRequest(cloudRequest$iv, Map.class, GuardDetectService.access$getCloudObjectMapper$p(this_$iv));
                GuardDetectService.access$getLogger$cp().debug("[Atlassian Lighthouse] status code: " + cloudResponse$iv.getStatusCode());
                CloudResponse<Map> cloudResponse = cloudResponse$iv;
                boolean bl = cloudResponse != null ? cloudResponse.getStatusCode() == 200 : false;
                if (bl) {
                    Map map;
                    Map map2 = map = cloudResponse$iv.getBody();
                    if (map2 != null) {
                        Intrinsics.checkNotNull(map2);
                        Map it$iv = map;
                        boolean bl2 = false;
                        apiResponse = new ApiResponse.Success<Map>(it$iv);
                    } else {
                        apiResponse = new ApiResponse.Success<T>(null, 1, null);
                    }
                } else {
                    GuardDetectService.access$getLogger$cp().debug("[Atlassian Lighthouse] Failed to query GuardDetectService using the payload: " + payload);
                    CloudResponse<Map> cloudResponse2 = cloudResponse$iv;
                    CloudResponse<Map> cloudResponse3 = cloudResponse$iv;
                    apiResponse = new ApiResponse.Failure(cloudResponse2 != null ? Integer.valueOf(cloudResponse2.getStatusCode()) : null, String.valueOf(cloudResponse3 != null ? cloudResponse3.getBody() : null));
                }
                return apiResponse;
            }
        });
    }

    @NotNull
    public final ApiResponse<CreateAlertsResponse> batchPushAlertToGuardDetect(@NotNull List<AlertEntity> alerts, @NotNull String workspaceAri) {
        Intrinsics.checkNotNullParameter(alerts, "alerts");
        Intrinsics.checkNotNullParameter(workspaceAri, "workspaceAri");
        return this.returnFailureResponseOnException((Function0)new Function0<ApiResponse<? extends CreateAlertsResponse>>(alerts, workspaceAri, this){
            final /* synthetic */ List<AlertEntity> $alerts;
            final /* synthetic */ String $workspaceAri;
            final /* synthetic */ GuardDetectService this$0;
            {
                this.$alerts = $alerts;
                this.$workspaceAri = $workspaceAri;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ApiResponse<CreateAlertsResponse> invoke() {
                ApiResponse apiResponse;
                CreateAlertsPayload payload = GuardDetectPayloadMapper.INSTANCE.getBatchCreateAlertPayload(this.$alerts, this.$workspaceAri, GuardDetectService.access$getPluginInfo$p(this.this$0).getProductId(), GuardDetectGraphQLQuery.INSTANCE.getBATCH_CREATE_ALERTS_QUERY$atlassian_lighthouse_core());
                GuardDetectService this_$iv = this.this$0;
                boolean $i$f$sendGuardRequest = false;
                CloudRequest<CreateAlertsPayload> cloudRequest$iv = this_$iv.buildGraphqlRequest(payload);
                CloudResponse<CreateAlertsResponse> cloudResponse$iv = GuardDetectService.access$getCloudRequestServiceLocator$p(this_$iv).sendRequest(cloudRequest$iv, CreateAlertsResponse.class, GuardDetectService.access$getCloudObjectMapper$p(this_$iv));
                GuardDetectService.access$getLogger$cp().debug("[Atlassian Lighthouse] status code: " + cloudResponse$iv.getStatusCode());
                CloudResponse<CreateAlertsResponse> cloudResponse = cloudResponse$iv;
                boolean bl = cloudResponse != null ? cloudResponse.getStatusCode() == 200 : false;
                if (bl) {
                    CreateAlertsResponse createAlertsResponse;
                    CreateAlertsResponse createAlertsResponse2 = createAlertsResponse = cloudResponse$iv.getBody();
                    if (createAlertsResponse2 != null) {
                        Intrinsics.checkNotNull(createAlertsResponse2);
                        CreateAlertsResponse it$iv = createAlertsResponse;
                        boolean bl2 = false;
                        apiResponse = new ApiResponse.Success<CreateAlertsResponse>(it$iv);
                    } else {
                        apiResponse = new ApiResponse.Success<T>(null, 1, null);
                    }
                } else {
                    GuardDetectService.access$getLogger$cp().debug("[Atlassian Lighthouse] Failed to query GuardDetectService using the payload: " + payload);
                    CloudResponse<CreateAlertsResponse> cloudResponse2 = cloudResponse$iv;
                    CloudResponse<CreateAlertsResponse> cloudResponse3 = cloudResponse$iv;
                    apiResponse = new ApiResponse.Failure(cloudResponse2 != null ? Integer.valueOf(cloudResponse2.getStatusCode()) : null, String.valueOf(cloudResponse3 != null ? cloudResponse3.getBody() : null));
                }
                return apiResponse;
            }
        });
    }

    @NotNull
    public final ApiResponse<WorkspaceResponse> getGuardStatus() {
        return this.returnFailureResponseOnException((Function0)new Function0<ApiResponse<? extends WorkspaceResponse>>(this){
            final /* synthetic */ GuardDetectService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ApiResponse<WorkspaceResponse> invoke() {
                ApiResponse apiResponse;
                String string = GuardDetectGraphQLQuery.INSTANCE.getGUARD_STATUS_QUERY$atlassian_lighthouse_core();
                String string2 = this.this$0.getOrgId();
                Intrinsics.checkNotNull(string2);
                WorkspacePayload payload = new WorkspacePayload(string, new OrgIdData(string2));
                GuardDetectService this_$iv = this.this$0;
                boolean $i$f$sendGuardRequest = false;
                CloudRequest<WorkspacePayload> cloudRequest$iv = this_$iv.buildGraphqlRequest(payload);
                CloudResponse<WorkspaceResponse> cloudResponse$iv = GuardDetectService.access$getCloudRequestServiceLocator$p(this_$iv).sendRequest(cloudRequest$iv, WorkspaceResponse.class, GuardDetectService.access$getCloudObjectMapper$p(this_$iv));
                GuardDetectService.access$getLogger$cp().debug("[Atlassian Lighthouse] status code: " + cloudResponse$iv.getStatusCode());
                CloudResponse<WorkspaceResponse> cloudResponse = cloudResponse$iv;
                boolean bl = cloudResponse != null ? cloudResponse.getStatusCode() == 200 : false;
                if (bl) {
                    WorkspaceResponse workspaceResponse;
                    WorkspaceResponse workspaceResponse2 = workspaceResponse = cloudResponse$iv.getBody();
                    if (workspaceResponse2 != null) {
                        Intrinsics.checkNotNull(workspaceResponse2);
                        WorkspaceResponse it$iv = workspaceResponse;
                        boolean bl2 = false;
                        apiResponse = new ApiResponse.Success<WorkspaceResponse>(it$iv);
                    } else {
                        apiResponse = new ApiResponse.Success<T>(null, 1, null);
                    }
                } else {
                    GuardDetectService.access$getLogger$cp().debug("[Atlassian Lighthouse] Failed to query GuardDetectService using the payload: " + payload);
                    CloudResponse<WorkspaceResponse> cloudResponse2 = cloudResponse$iv;
                    CloudResponse<WorkspaceResponse> cloudResponse3 = cloudResponse$iv;
                    apiResponse = new ApiResponse.Failure(cloudResponse2 != null ? Integer.valueOf(cloudResponse2.getStatusCode()) : null, String.valueOf(cloudResponse3 != null ? cloudResponse3.getBody() : null));
                }
                return apiResponse;
            }
        });
    }

    @NotNull
    public final String getGuardDetectWebpageUrl() {
        return this.guardDetectWebpageBaseUrl;
    }

    private final /* synthetic */ <T, R> ApiResponse<R> sendGuardRequest(T payload) {
        ApiResponse apiResponse;
        boolean $i$f$sendGuardRequest = false;
        CloudRequest<T> cloudRequest = this.buildGraphqlRequest(payload);
        CloudRequestServiceLocator cloudRequestServiceLocator = this.cloudRequestServiceLocator;
        Intrinsics.reifiedOperationMarker(4, "R");
        CloudResponse<Object> cloudResponse = cloudRequestServiceLocator.sendRequest(cloudRequest, Object.class, this.cloudObjectMapper);
        GuardDetectService.logger.debug("[Atlassian Lighthouse] status code: " + cloudResponse.getStatusCode());
        CloudResponse<Object> cloudResponse2 = cloudResponse;
        boolean bl = cloudResponse2 != null ? cloudResponse2.getStatusCode() == 200 : false;
        if (bl) {
            ApiResponse apiResponse2;
            Object object = cloudResponse.getBody();
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                apiResponse2 = new ApiResponse.Success<Object>(it);
            } else {
                apiResponse2 = new ApiResponse.Success(null, 1, null);
            }
            apiResponse = apiResponse2;
        } else {
            GuardDetectService.logger.debug("[Atlassian Lighthouse] Failed to query GuardDetectService using the payload: " + payload);
            CloudResponse<Object> cloudResponse3 = cloudResponse;
            CloudResponse<Object> cloudResponse4 = cloudResponse;
            apiResponse = new ApiResponse.Failure(cloudResponse3 != null ? Integer.valueOf(cloudResponse3.getStatusCode()) : null, String.valueOf(cloudResponse4 != null ? cloudResponse4.getBody() : null));
        }
        return apiResponse;
    }

    @VisibleForTesting
    @NotNull
    public final <T> CloudRequest<T> buildGraphqlRequest(T payload) {
        CloudRequest<T> cloudRequest = CloudRequest.builder(payload).method(CloudRequestMethod.POST).url(GuardDetectService.Companion.buildGraphQLEndPoint(this.graphqlGatewayBaseUrlHost, this.graphqlGatewayBaseUrlScheme, this.graphqlGatewayBaseUrlPort)).cloudContext(CloudContext.withMinimumDataSharingLevel(Constants.INSTANCE.getMinLighthouseDataSharingLevel())).header("Content-Type", "application/json").header("Accept", "*/*").header("Host", this.graphqlGatewayBaseUrlHost).build();
        Intrinsics.checkNotNull(cloudRequest);
        return cloudRequest;
    }

    private final <T> ApiResponse<T> returnFailureResponseOnException(Function0<? extends ApiResponse<? extends T>> requestAction) {
        ApiResponse apiResponse;
        try {
            apiResponse = requestAction.invoke();
        }
        catch (Exception e) {
            apiResponse = new ApiResponse.Failure(null, e.toString());
        }
        return apiResponse;
    }

    @Nullable
    public final String getOrgId() {
        CloudLink cloudLink;
        Optional<CloudLink> optional = this.cloudRequestServiceLocator.getCloudLink();
        Intrinsics.checkNotNullExpressionValue(optional, "getCloudLink(...)");
        Optional<CloudLink> $this$getOrElse$iv = optional;
        boolean $i$f$getOrElse = false;
        if ($this$getOrElse$iv.isPresent()) {
            cloudLink = $this$getOrElse$iv.get();
        } else {
            boolean bl = false;
            cloudLink = null;
        }
        return cloudLink != null ? cloudLink.getOrgId() : null;
    }

    public static final /* synthetic */ PluginInfo access$getPluginInfo$p(GuardDetectService $this) {
        return $this.pluginInfo;
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        GuardDetectService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/service/guard/GuardDetectService$Companion;", "", "()V", "PATH", "", "logger", "Lorg/slf4j/Logger;", "buildGraphQLEndPoint", "Ljava/net/URL;", "host", "scheme", "port", "", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        private final URL buildGraphQLEndPoint(String host, String scheme, int port) {
            URL uRL = UriBuilder.fromPath((String)GuardDetectService.PATH).host(host).scheme(scheme).port(port).build(new Object[0]).toURL();
            Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
            return uRL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

