/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.guard;

import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.database.dao.AlertManager;
import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.GuardPushStatus;
import com.atlassian.lighthouse.service.guard.ApiResponse;
import com.atlassian.lighthouse.service.guard.CreateAlertsResponseMapper;
import com.atlassian.lighthouse.service.guard.GuardDetectService;
import com.atlassian.lighthouse.service.guard.GuardIntegrationMonitor;
import com.atlassian.lighthouse.service.guard.UnpushedGuardAlertsRetryService;
import com.atlassian.lighthouse.service.guard.graphql.response.createalerts.CreateAlertsResponse;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013JF\u0010\u0015\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00132\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0018\u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u0013\u0012\u0004\u0012\u00020\u00110\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0011J\u0014\u0010\u001d\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/lighthouse/service/guard/UnpushedGuardAlertsRetryService;", "", "alertManager", "Lcom/atlassian/lighthouse/database/dao/AlertManager;", "guardDetectService", "Lcom/atlassian/lighthouse/service/guard/GuardDetectService;", "guardIntegrationMonitor", "Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "(Lcom/atlassian/lighthouse/database/dao/AlertManager;Lcom/atlassian/lighthouse/service/guard/GuardDetectService;Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;Lcom/atlassian/lighthouse/config/system/LighthouseConfig;)V", "alertCountPerRetry", "", "maxRetryTimespanInMillis", "", "unpushedAlertsRetryJobIntervalInMillis", "pushAlerts", "", "alerts", "", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "respectBatchRateLimit", "T", "items", "batchSize", "rateLimit", "batchPayload", "Lkotlin/Function1;", "retryUnpushedGuardAlerts", "tryToPushAlerts", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nUnpushedGuardAlertsRetryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnpushedGuardAlertsRetryService.kt\ncom/atlassian/lighthouse/service/guard/UnpushedGuardAlertsRetryService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,134:1\n1864#2,2:135\n1864#2,3:137\n1866#2:140\n1549#2:141\n1620#2,3:142\n11#3:145\n10#3,3:146\n*S KotlinDebug\n*F\n+ 1 UnpushedGuardAlertsRetryService.kt\ncom/atlassian/lighthouse/service/guard/UnpushedGuardAlertsRetryService\n*L\n73#1:135,2\n77#1:137,3\n73#1:140\n101#1:141\n101#1:142,3\n131#1:145\n131#1:146,3\n*E\n"})
public final class UnpushedGuardAlertsRetryService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlertManager alertManager;
    @NotNull
    private final GuardDetectService guardDetectService;
    @NotNull
    private final GuardIntegrationMonitor guardIntegrationMonitor;
    private final long maxRetryTimespanInMillis;
    private final long unpushedAlertsRetryJobIntervalInMillis;
    private final int alertCountPerRetry;
    public static final int GUARD_DETECT_ALERTS_BATCH_SIZE = 50;
    public static final int GUARD_DETECT_RATE_LIMIT_PER_MINUTE = 40;
    private static final long INITIAL_SYNC_NUM_OF_DAYS_FROM = 180L;
    @NotNull
    private static final Logger logger;

    public UnpushedGuardAlertsRetryService(@NotNull AlertManager alertManager, @NotNull GuardDetectService guardDetectService, @NotNull GuardIntegrationMonitor guardIntegrationMonitor, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(alertManager, "alertManager");
        Intrinsics.checkNotNullParameter(guardDetectService, "guardDetectService");
        Intrinsics.checkNotNullParameter(guardIntegrationMonitor, "guardIntegrationMonitor");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        this.alertManager = alertManager;
        this.guardDetectService = guardDetectService;
        this.guardIntegrationMonitor = guardIntegrationMonitor;
        this.maxRetryTimespanInMillis = lighthouseConfig.getUnpushedCloudAlertsMaxRetryTimespanInMinutes() * (long)60 * 1000L;
        this.unpushedAlertsRetryJobIntervalInMillis = lighthouseConfig.getUnpushedCloudAlertsJobRunIntervalInMinutes() * (long)60 * 1000L;
        this.alertCountPerRetry = 2000 * UnpushedGuardAlertsRetryService.Companion.toPositiveIntOrDefault(lighthouseConfig.getUnpushedCloudAlertsJobRunIntervalInMinutes(), 5);
    }

    public final void retryUnpushedGuardAlerts() {
        if (!this.guardIntegrationMonitor.canSendAlerts()) {
            logger.debug("[Atlassian Lighthouse] Guard Detect integration is disabled, skipping the retry to push unpushed alerts");
            return;
        }
        List<AlertEntity> alerts = this.alertManager.getUnpushedAlerts(this.alertCountPerRetry, Companion.getDate180DaysAgo());
        if (!((Collection)alerts).isEmpty()) {
            this.pushAlerts(alerts);
        }
    }

    public final void pushAlerts(@NotNull List<AlertEntity> alerts) {
        Intrinsics.checkNotNullParameter(alerts, "alerts");
        this.respectBatchRateLimit(alerts, 50, 40, (Function1)new Function1<List<? extends AlertEntity>, Unit>((Object)this){

            public final void invoke(@NotNull List<AlertEntity> p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((UnpushedGuardAlertsRetryService)this.receiver).tryToPushAlerts(p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void respectBatchRateLimit(List<? extends T> items, int batchSize, int rateLimit, Function1<? super List<? extends T>, Unit> batchPayload) {
        void $this$forEachIndexed$iv;
        List batches = CollectionsKt.chunked((Iterable)items, batchSize);
        Iterable iterable = CollectionsKt.chunked(batches, rateLimit);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void batchesPerMinute;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int minuteIndex = n;
            boolean bl = false;
            Instant timestamp = Instant.now();
            boolean isLastMinute = minuteIndex == batches.size() - 1;
            Iterable $this$forEachIndexed$iv2 = (Iterable)batchesPerMinute;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                long sleepDuration;
                void batch;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list2 = (List)item$iv2;
                int index = n2;
                boolean bl2 = false;
                batchPayload.invoke((List<T>)batch);
                boolean isLastBatchForMinute = index == batchesPerMinute.size() - 1;
                if (!isLastBatchForMinute || isLastMinute || (sleepDuration = timestamp.plus(1L, ChronoUnit.MINUTES).toEpochMilli() - Instant.now().toEpochMilli()) <= 0L) continue;
                Thread.sleep(sleepDuration);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tryToPushAlerts(@NotNull List<AlertEntity> alerts) {
        Intrinsics.checkNotNullParameter(alerts, "alerts");
        try {
            String string = this.guardIntegrationMonitor.getGuardStatusFromLocalCache().getGuardWorkspaceAri();
            if (string == null) {
                throw new IllegalStateException("No guard workspace uri provided");
            }
            String workspaceAri = string;
            ApiResponse<CreateAlertsResponse> response = this.guardDetectService.batchPushAlertToGuardDetect(alerts, workspaceAri);
            Map<Long, GuardPushStatus> alertIdToStatusMap = CreateAlertsResponseMapper.INSTANCE.mapAlertsToGuardPushStatuses(alerts, response, this.unpushedAlertsRetryJobIntervalInMillis, this.maxRetryTimespanInMillis);
            this.alertManager.updateGuardPushStatuses(alertIdToStatusMap);
        }
        catch (Exception e) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = alerts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AlertEntity alertEntity = (AlertEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            String ids2 = CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, tryToPushAlerts.ids.2.INSTANCE, 31, null);
            logger.error("[Atlassian Lighthouse] Failed to push alerts with ids: " + ids2, (Throwable)e);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        UnpushedGuardAlertsRetryService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/lighthouse/service/guard/UnpushedGuardAlertsRetryService$Companion;", "", "()V", "GUARD_DETECT_ALERTS_BATCH_SIZE", "", "GUARD_DETECT_RATE_LIMIT_PER_MINUTE", "INITIAL_SYNC_NUM_OF_DAYS_FROM", "", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getDate180DaysAgo", "Ljava/time/Instant;", "toPositiveIntOrDefault", "default", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Instant getDate180DaysAgo() {
            Instant instant = Instant.now().minus(180L, ChronoUnit.DAYS);
            Intrinsics.checkNotNullExpressionValue(instant, "minus(...)");
            return instant;
        }

        private final int toPositiveIntOrDefault(long $this$toPositiveIntOrDefault, int n) {
            return $this$toPositiveIntOrDefault >= 1L && $this$toPositiveIntOrDefault <= Integer.MAX_VALUE ? (int)$this$toPositiveIntOrDefault : n;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

