/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.guard.cache;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/service/guard/cache/TimeBasedSingleValueCache;", "T", "", "fetchFunction", "Lkotlin/Function0;", "cacheDurationMillis", "", "(Lkotlin/jvm/functions/Function0;J)V", "cachedValue", "Ljava/lang/Object;", "lastFetchedTime", "get", "()Ljava/lang/Object;", "invalidate", "", "atlassian-lighthouse-core"})
public final class TimeBasedSingleValueCache<T> {
    @NotNull
    private final Function0<T> fetchFunction;
    private final long cacheDurationMillis;
    @Nullable
    private T cachedValue;
    private long lastFetchedTime;

    public TimeBasedSingleValueCache(@NotNull Function0<? extends T> fetchFunction, long cacheDurationMillis) {
        Intrinsics.checkNotNullParameter(fetchFunction, "fetchFunction");
        this.fetchFunction = fetchFunction;
        this.cacheDurationMillis = cacheDurationMillis;
    }

    public final T get() {
        long currentTime = System.currentTimeMillis();
        if (this.cachedValue == null || currentTime - this.lastFetchedTime > this.cacheDurationMillis) {
            this.cachedValue = this.fetchFunction.invoke();
            this.lastFetchedTime = currentTime;
        }
        T t = this.cachedValue;
        Intrinsics.checkNotNull(t);
        return t;
    }

    public final void invalidate() {
        this.cachedValue = null;
    }
}

