/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.scheduler;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.lighthouse.database.dao.ScheduleJobManager;
import com.atlassian.lighthouse.service.guard.UnpushedGuardAlertsRetryService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0002J\u001c\u0010\u0011\u001a\u00020\n\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobRunner;", "Lcom/atlassian/scheduler/JobRunner;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "unpushedGuardAlertsRetryService", "Lcom/atlassian/lighthouse/service/guard/UnpushedGuardAlertsRetryService;", "scheduleJobManager", "Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager;", "(Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/lighthouse/service/guard/UnpushedGuardAlertsRetryService;Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager;)V", "abortJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "getJobRunnerKey", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "runJob", "ignored", "Lcom/atlassian/scheduler/JobRunnerRequest;", "runJobWithLock", "runWithDefaultJobResponse", "T", "action", "Lkotlin/Function0;", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nUnpushedGuardAlertsRetryJobRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnpushedGuardAlertsRetryJobRunner.kt\ncom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobRunner\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,64:1\n11#2:65\n10#2,3:66\n*S KotlinDebug\n*F\n+ 1 UnpushedGuardAlertsRetryJobRunner.kt\ncom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobRunner\n*L\n61#1:65\n61#1:66,3\n*E\n"})
public final class UnpushedGuardAlertsRetryJobRunner
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterLockService clusterLockService;
    @NotNull
    private final UnpushedGuardAlertsRetryService unpushedGuardAlertsRetryService;
    @NotNull
    private final ScheduleJobManager scheduleJobManager;
    @NotNull
    public static final String PUSH_GUARD_ALERTS_CLUSTER_LOCK_KEY = "UnpushedGuardAlertsRetryJobRunnerClusterLock";
    @NotNull
    private static final JobRunnerKey KEY;
    @NotNull
    private static final Logger logger;

    public UnpushedGuardAlertsRetryJobRunner(@NotNull ClusterLockService clusterLockService, @NotNull UnpushedGuardAlertsRetryService unpushedGuardAlertsRetryService, @NotNull ScheduleJobManager scheduleJobManager) {
        Intrinsics.checkNotNullParameter(clusterLockService, "clusterLockService");
        Intrinsics.checkNotNullParameter(unpushedGuardAlertsRetryService, "unpushedGuardAlertsRetryService");
        Intrinsics.checkNotNullParameter(scheduleJobManager, "scheduleJobManager");
        this.clusterLockService = clusterLockService;
        this.unpushedGuardAlertsRetryService = unpushedGuardAlertsRetryService;
        this.scheduleJobManager = scheduleJobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest ignored) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter(ignored, "ignored");
        ClusterLock clusterLock = this.clusterLockService.getLockForName(PUSH_GUARD_ALERTS_CLUSTER_LOCK_KEY);
        if (clusterLock.tryLock()) {
            JobRunnerResponse jobRunnerResponse2;
            try {
                jobRunnerResponse2 = this.runJobWithLock();
            }
            finally {
                clusterLock.unlock();
            }
            jobRunnerResponse = jobRunnerResponse2;
        } else {
            jobRunnerResponse = this.abortJob();
        }
        return jobRunnerResponse;
    }

    @NotNull
    public final JobRunnerKey getJobRunnerKey() {
        return KEY;
    }

    private final JobRunnerResponse runJobWithLock() {
        long scheduledAtEpoch = Instant.now().toEpochMilli();
        return this.runWithDefaultJobResponse((Function0)new Function0<Long>(this, scheduledAtEpoch){
            final /* synthetic */ UnpushedGuardAlertsRetryJobRunner this$0;
            final /* synthetic */ long $scheduledAtEpoch;
            {
                this.this$0 = $receiver;
                this.$scheduledAtEpoch = $scheduledAtEpoch;
                super(0);
            }

            @Nullable
            public final Long invoke() {
                UnpushedGuardAlertsRetryJobRunner.access$getUnpushedGuardAlertsRetryService$p(this.this$0).retryUnpushedGuardAlerts();
                ScheduleJobManager scheduleJobManager = UnpushedGuardAlertsRetryJobRunner.access$getScheduleJobManager$p(this.this$0);
                String string = UnpushedGuardAlertsRetryJobRunner.access$getKEY$cp().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return scheduleJobManager.updateLastTimeJobRunSuccessfully(string, this.$scheduledAtEpoch);
            }
        });
    }

    private final JobRunnerResponse abortJob() {
        logger.debug("[Atlassian Lighthouse] Could not acquire lock UnpushedGuardAlertsRetryJobRunnerClusterLock");
        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.aborted((String)"Could not acquire lock UnpushedGuardAlertsRetryJobRunnerClusterLock");
        Intrinsics.checkNotNullExpressionValue(jobRunnerResponse, "aborted(...)");
        return jobRunnerResponse;
    }

    private final <T> JobRunnerResponse runWithDefaultJobResponse(Function0<? extends T> action) {
        JobRunnerResponse jobRunnerResponse;
        try {
            action.invoke();
            jobRunnerResponse = JobRunnerResponse.success((String)"UnpushedGuardAlertsRetryJobRunner ran successfully");
            Intrinsics.checkNotNull(jobRunnerResponse);
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Failed to run UnpushedGuardAlertsRetryJobRunner", (Throwable)e);
            JobRunnerResponse jobRunnerResponse2 = JobRunnerResponse.failed((String)"Failed to run UnpushedGuardAlertsRetryJobRunner");
            Intrinsics.checkNotNull(jobRunnerResponse2);
            jobRunnerResponse = jobRunnerResponse2;
        }
        return jobRunnerResponse;
    }

    public static final /* synthetic */ UnpushedGuardAlertsRetryService access$getUnpushedGuardAlertsRetryService$p(UnpushedGuardAlertsRetryJobRunner $this) {
        return $this.unpushedGuardAlertsRetryService;
    }

    public static final /* synthetic */ ScheduleJobManager access$getScheduleJobManager$p(UnpushedGuardAlertsRetryJobRunner $this) {
        return $this.scheduleJobManager;
    }

    public static final /* synthetic */ JobRunnerKey access$getKEY$cp() {
        return KEY;
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)UnpushedGuardAlertsRetryJobRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue(jobRunnerKey, "of(...)");
        KEY = jobRunnerKey;
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        UnpushedGuardAlertsRetryJobRunner.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobRunner$Companion;", "", "()V", "KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "PUSH_GUARD_ALERTS_CLUSTER_LOCK_KEY", "", "getPUSH_GUARD_ALERTS_CLUSTER_LOCK_KEY$annotations", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPUSH_GUARD_ALERTS_CLUSTER_LOCK_KEY$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

