/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.lighthouse.service.user.Constants;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/service/user/BitbucketUserDetailsFinder;", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "userService", "Lcom/atlassian/bitbucket/user/UserService;", "(Lcom/atlassian/sal/api/message/I18nResolver;Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/bitbucket/user/UserService;)V", "fromUserKey", "Lcom/atlassian/lighthouse/service/user/UserDetails;", "userKey", "", "fromUsername", "username", "atlassian-lighthouse-core"})
public final class BitbucketUserDetailsFinder
implements UserDetailsFinder {
    @NotNull
    private final I18nResolver i18nResolver;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final UserService userService;

    public BitbucketUserDetailsFinder(@NotNull I18nResolver i18nResolver, @NotNull UserManager userManager, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(userService, "userService");
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.userService = userService;
    }

    @Override
    @NotNull
    public UserDetails fromUserKey(@Nullable String userKey) {
        ApplicationUser applicationUser;
        String string;
        String string2 = string = userKey;
        if (string2 == null ? true : Intrinsics.areEqual(string2, Constants.INSTANCE.getUNKNOWN_USER_KEY())) {
            return UserDetailsFinder.Companion.getUNKNOWN_USER_DETAILS$atlassian_lighthouse_core();
        }
        if (Intrinsics.areEqual(string, Constants.INSTANCE.getSYSTEM_USER_KEY())) {
            return UserDetailsFinder.Companion.getSYSTEM_USER_DETAILS$atlassian_lighthouse_core();
        }
        if (Intrinsics.areEqual(string, Constants.INSTANCE.getANONYMOUS_USER_KEY())) {
            return UserDetailsFinder.Companion.getANONYMOUS_USER_DETAILS$atlassian_lighthouse_core();
        }
        try {
            applicationUser = this.userService.getUserById(Integer.parseInt(userKey), true);
            if (applicationUser == null) {
                return UserDetailsFinder.Companion.createUnknownUserWithKey(userKey, this.i18nResolver);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ApplicationUser applicationUser2 = this.userService.getUserByName(userKey, true);
            if (applicationUser2 == null) {
                return UserDetailsFinder.Companion.createUnknownUserWithKey(userKey, this.i18nResolver);
            }
            applicationUser = applicationUser2;
        }
        ApplicationUser user = applicationUser;
        UserKey key = new UserKey(userKey);
        String string3 = user.getEmailAddress();
        String string4 = user.getDisplayName();
        String string5 = user.getName();
        Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
        return new UserDetails(string3, string4, userKey, string5, this.userManager.isAdmin(key), this.userManager.isSystemAdmin(key));
    }

    @Override
    @NotNull
    public UserDetails fromUsername(@NotNull String username) {
        Intrinsics.checkNotNullParameter(username, "username");
        if (((CharSequence)username).length() == 0) {
            return UserDetailsFinder.Companion.getUNKNOWN_USER_DETAILS$atlassian_lighthouse_core();
        }
        ApplicationUser applicationUser = this.userService.getUserByName(username, true);
        if (applicationUser == null) {
            return UserDetailsFinder.Companion.getUNKNOWN_USER_DETAILS$atlassian_lighthouse_core();
        }
        ApplicationUser applicationUser2 = applicationUser;
        UserKey userKey = UserKey.fromLong((long)applicationUser2.getId());
        String string = applicationUser2.getEmailAddress();
        String string2 = applicationUser2.getDisplayName();
        String string3 = userKey.getStringValue();
        Intrinsics.checkNotNullExpressionValue(string3, "getStringValue(...)");
        String string4 = applicationUser2.getName();
        Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
        return new UserDetails(string, string2, string3, string4, this.userManager.isAdmin(userKey), this.userManager.isSystemAdmin(userKey));
    }
}

