/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.lighthouse.service.user.CrowdHelper;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u001e\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\r0\r0\f2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/lighthouse/service/user/ConfluenceSecurityUserService;", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "crowdHelper", "Lcom/atlassian/lighthouse/service/user/CrowdHelper;", "securityGroupName", "", "spacePermissionManager", "Lcom/atlassian/confluence/security/SpacePermissionManager;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "(Lcom/atlassian/lighthouse/service/user/CrowdHelper;Ljava/lang/String;Lcom/atlassian/confluence/security/SpacePermissionManager;Lcom/atlassian/sal/api/user/UserManager;)V", "getAdminUsers", "", "Lcom/atlassian/crowd/embedded/api/User;", "getSysAdminEmailAddresses", "", "()[Ljava/lang/String;", "getSysAdminUsers", "getUserKeyByAuditAuthor", "auditAuthor", "Lcom/atlassian/audit/entity/AuditAuthor;", "getUserKeyByUserName", "userName", "getUsersWithGlobalPermission", "spacePermission", "getUsersWithGroupPermission", "kotlin.jvm.PlatformType", "getValidSecurityGroupUserEmails", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nConfluenceSecurityUserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfluenceSecurityUserService.kt\ncom/atlassian/lighthouse/service/user/ConfluenceSecurityUserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,63:1\n1603#2,9:64\n1855#2:73\n1856#2:75\n1612#2:76\n1603#2,9:79\n1855#2:88\n1856#2:90\n1612#2:91\n766#2:94\n857#2,2:95\n1360#2:97\n1446#2,5:98\n1#3:74\n1#3:89\n37#4,2:77\n37#4,2:92\n*S KotlinDebug\n*F\n+ 1 ConfluenceSecurityUserService.kt\ncom/atlassian/lighthouse/service/user/ConfluenceSecurityUserService\n*L\n19#1:64,9\n19#1:73\n19#1:75\n19#1:76\n27#1:79,9\n27#1:88\n27#1:90\n27#1:91\n49#1:94\n49#1:95,2\n50#1:97\n50#1:98,5\n19#1:74\n27#1:89\n22#1:77,2\n29#1:92,2\n*E\n"})
public final class ConfluenceSecurityUserService
implements SecurityUserService {
    @NotNull
    private final CrowdHelper crowdHelper;
    @NotNull
    private final String securityGroupName;
    @NotNull
    private final SpacePermissionManager spacePermissionManager;
    @NotNull
    private final UserManager userManager;

    public ConfluenceSecurityUserService(@NotNull CrowdHelper crowdHelper, @NotNull String securityGroupName, @NotNull SpacePermissionManager spacePermissionManager, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(crowdHelper, "crowdHelper");
        Intrinsics.checkNotNullParameter(securityGroupName, "securityGroupName");
        Intrinsics.checkNotNullParameter(spacePermissionManager, "spacePermissionManager");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        this.crowdHelper = crowdHelper;
        this.securityGroupName = securityGroupName;
        this.spacePermissionManager = spacePermissionManager;
        this.userManager = userManager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] getSysAdminEmailAddresses() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getSysAdminUsers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            User it = (User)element$iv$iv;
            boolean bl2 = false;
            if (it.getEmailAddress() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.take(CollectionsKt.distinct((List)destination$iv$iv), 100);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] getValidSecurityGroupUserEmails() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.crowdHelper.searchActiveUsersByGroupName(this.securityGroupName, 100);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            User it = (User)element$iv$iv;
            boolean bl2 = false;
            if (it.getEmailAddress() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.distinct((List)destination$iv$iv);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public String getUserKeyByAuditAuthor(@NotNull AuditAuthor auditAuthor) {
        Intrinsics.checkNotNullParameter(auditAuthor, "auditAuthor");
        String string = auditAuthor.getId();
        Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
        return string;
    }

    @Override
    @Nullable
    public String getUserKeyByUserName(@NotNull String userName) {
        Intrinsics.checkNotNullParameter(userName, "userName");
        UserProfile userProfile = this.userManager.getUserProfile(userName);
        return userProfile != null && (userProfile = userProfile.getUserKey()) != null ? userProfile.getStringValue() : null;
    }

    @NotNull
    public final Set<User> getSysAdminUsers() {
        return SetsKt.plus(this.getUsersWithGroupPermission("SYSTEMADMINISTRATOR"), (Iterable)this.getUsersWithGlobalPermission("SYSTEMADMINISTRATOR"));
    }

    @NotNull
    public final Set<User> getAdminUsers() {
        return SetsKt.plus(this.getUsersWithGroupPermission("ADMINISTRATECONFLUENCE"), (Iterable)this.getUsersWithGlobalPermission("ADMINISTRATECONFLUENCE"));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<User> getUsersWithGroupPermission(String spacePermission) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.spacePermissionManager.getGroupsForPermissionType(spacePermission, null).keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String groupName = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(groupName);
            Iterable list$iv$iv = this.crowdHelper.searchActiveUsersByGroupName(groupName, 100);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private final Set<User> getUsersWithGlobalPermission(String spacePermission) {
        Set usernames = this.spacePermissionManager.getUsersForPermissionType(spacePermission, null).keySet();
        return usernames.isEmpty() ? SetsKt.emptySet() : this.crowdHelper.searchActiveUsersByUsername(usernames, 100);
    }

    @Override
    public boolean isSecurityGroupSetup() {
        return SecurityUserService.DefaultImpls.isSecurityGroupSetup(this);
    }
}

