/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0011\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002J$\u0010\u0015\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\u0016\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\u0017\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002J\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00122\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u0019\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/lighthouse/service/user/CrowdHelper;", "", "crowdService", "Lcom/atlassian/crowd/embedded/api/CrowdService;", "(Lcom/atlassian/crowd/embedded/api/CrowdService;)V", "byGroupNameQuery", "Lcom/atlassian/crowd/search/query/membership/MembershipQuery;", "Lcom/atlassian/crowd/embedded/api/User;", "kotlin.jvm.PlatformType", "groupName", "", "limit", "", "byUsernamesQuery", "Lcom/atlassian/crowd/search/query/entity/EntityQuery;", "usernames", "", "searchActiveUsers", "", "query", "Lcom/atlassian/crowd/embedded/api/Query;", "searchActiveUsersByGroupName", "searchActiveUsersByUsername", "searchAllUsers", "searchAllUsersByGroupName", "searchAllUsersByUsername", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nCrowdHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrowdHelper.kt\ncom/atlassian/lighthouse/service/user/CrowdHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1549#2:65\n1620#2,3:66\n766#2:69\n857#2,2:70\n*S KotlinDebug\n*F\n+ 1 CrowdHelper.kt\ncom/atlassian/lighthouse/service/user/CrowdHelper\n*L\n48#1:65\n48#1:66,3\n58#1:69\n58#1:70,2\n*E\n"})
public final class CrowdHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CrowdService crowdService;
    public static final int MAX_CROWD_RESULT_SET_COUNT = 10000;

    public CrowdHelper(@NotNull CrowdService crowdService) {
        Intrinsics.checkNotNullParameter(crowdService, "crowdService");
        this.crowdService = crowdService;
    }

    @NotNull
    public final Set<User> searchActiveUsersByGroupName(@NotNull String groupName, int limit) {
        Intrinsics.checkNotNullParameter(groupName, "groupName");
        MembershipQuery<User> membershipQuery = this.byGroupNameQuery(groupName, limit);
        Intrinsics.checkNotNullExpressionValue(membershipQuery, "byGroupNameQuery(...)");
        return this.searchActiveUsers((Query<User>)((Query)membershipQuery));
    }

    @NotNull
    public final Set<User> searchActiveUsersByUsername(@NotNull Collection<String> usernames, int limit) {
        Intrinsics.checkNotNullParameter(usernames, "usernames");
        return this.searchActiveUsers((Query<User>)((Query)this.byUsernamesQuery(usernames, limit)));
    }

    @NotNull
    public final Set<User> searchAllUsersByGroupName(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter(groupName, "groupName");
        MembershipQuery<User> membershipQuery = this.byGroupNameQuery(groupName, 10000);
        Intrinsics.checkNotNullExpressionValue(membershipQuery, "byGroupNameQuery(...)");
        return this.searchAllUsers((Query<User>)((Query)membershipQuery));
    }

    @NotNull
    public final Set<User> searchAllUsersByUsername(@NotNull Collection<String> usernames) {
        Intrinsics.checkNotNullParameter(usernames, "usernames");
        return this.searchAllUsers((Query<User>)((Query)this.byUsernamesQuery(usernames, 10000)));
    }

    private final MembershipQuery<User> byGroupNameQuery(String groupName, int limit) {
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(limit);
    }

    /*
     * WARNING - void declaration
     */
    private final EntityQuery<User> byUsernamesQuery(Collection<String> usernames, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = usernames;
        QueryBuilder.PartialEntityQuery partialEntityQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user());
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)it));
        }
        EntityQuery entityQuery = partialEntityQuery.with((SearchRestriction)Combine.anyOf((Collection)((List)destination$iv$iv))).returningAtMost(limit);
        Intrinsics.checkNotNullExpressionValue(entityQuery, "returningAtMost(...)");
        return entityQuery;
    }

    private final Set<User> searchAllUsers(Query<User> query) {
        Iterable iterable = this.crowdService.search(query);
        Intrinsics.checkNotNullExpressionValue(iterable, "search(...)");
        return CollectionsKt.toSet(iterable);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<User> searchActiveUsers(Query<User> query) {
        void $this$filterTo$iv$iv;
        Iterable iterable = this.crowdService.search(query);
        Intrinsics.checkNotNullExpressionValue(iterable, "search(...)");
        Iterable $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            User it = (User)element$iv$iv;
            boolean bl = false;
            if (!it.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/service/user/CrowdHelper$Companion;", "", "()V", "MAX_CROWD_RESULT_SET_COUNT", "", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

