/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user.cache;

import com.atlassian.cache.CacheManager;
import com.atlassian.lighthouse.service.AbstractCachedService;
import com.atlassian.lighthouse.service.user.cache.AdminUserCache;
import com.atlassian.lighthouse.service.user.supplier.AdminUsernamesFinder;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;", "Lcom/atlassian/lighthouse/service/AbstractCachedService;", "Lcom/atlassian/lighthouse/service/user/cache/AdminUserCache;", "adminUsernamesFinder", "Lcom/atlassian/lighthouse/service/user/supplier/AdminUsernamesFinder;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "cacheRebuildSeconds", "", "(Lcom/atlassian/lighthouse/service/user/supplier/AdminUsernamesFinder;Lcom/atlassian/cache/CacheManager;J)V", "fetchValues", "isUsernameInAdminCache", "", "username", "", "isUsernameInSysAdminCache", "isUsernameInSysAdminOrAdminCache", "rebuildAdminUserCacheIfExists", "", "usernames", "", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nCachedAdminUserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedAdminUserService.kt\ncom/atlassian/lighthouse/service/user/cache/CachedAdminUserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1747#2,3:45\n*S KotlinDebug\n*F\n+ 1 CachedAdminUserService.kt\ncom/atlassian/lighthouse/service/user/cache/CachedAdminUserService\n*L\n25#1:45,3\n*E\n"})
public final class CachedAdminUserService
extends AbstractCachedService<AdminUserCache> {
    @NotNull
    private final AdminUsernamesFinder adminUsernamesFinder;

    public CachedAdminUserService(@NotNull AdminUsernamesFinder adminUsernamesFinder, @NotNull CacheManager cacheManager, long cacheRebuildSeconds) {
        Intrinsics.checkNotNullParameter(adminUsernamesFinder, "adminUsernamesFinder");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        super(cacheManager, "Security alerts - admin usernames cache", cacheRebuildSeconds);
        this.adminUsernamesFinder = adminUsernamesFinder;
    }

    public final boolean isUsernameInAdminCache(@Nullable String username) {
        return username != null && ((AdminUserCache)this.getCachedReference().get()).getAdmins().contains(username);
    }

    public final boolean isUsernameInSysAdminCache(@Nullable String username) {
        return username != null && ((AdminUserCache)this.getCachedReference().get()).getSysadmins().contains(username);
    }

    public final boolean isUsernameInSysAdminOrAdminCache(@Nullable String username) {
        return this.isUsernameInSysAdminCache(username) || this.isUsernameInAdminCache(username);
    }

    public final void rebuildAdminUserCacheIfExists(@NotNull Collection<String> usernames) {
        block13: {
            block12: {
                boolean bl;
                block11: {
                    String p0;
                    boolean bl2;
                    Iterable $this$any$iv;
                    boolean $i$f$any;
                    Set<String> set;
                    AdminUserCache adminUserCache;
                    block10: {
                        Intrinsics.checkNotNullParameter(usernames, "usernames");
                        Object object = this.getCachedReference().get();
                        Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                        adminUserCache = (AdminUserCache)object;
                        Iterable iterable = usernames;
                        set = adminUserCache.getAdmins();
                        $i$f$any = false;
                        if (((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                p0 = (String)element$iv;
                                boolean bl3 = false;
                                if (!set.contains(p0)) continue;
                                bl2 = true;
                                break block10;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) break block12;
                    $this$any$iv = usernames;
                    set = adminUserCache.getSysadmins();
                    $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            p0 = (String)element$iv;
                            boolean bl4 = false;
                            if (!set.contains(p0)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block13;
            }
            this.rebuildCache();
        }
    }

    @Override
    @NotNull
    public AdminUserCache fetchValues() {
        AdminUserCache adminUserCache;
        try {
            adminUserCache = new AdminUserCache(this.adminUsernamesFinder.getAdminUsernames(), this.adminUsernamesFinder.getSysAdminUsernames());
        }
        catch (Exception exception) {
            AbstractCachedService.Companion.getLogger().error("[Atlassian Lighthouse] Admin usernames failed to retrieve. Resorting to an empty set.", (Throwable)exception);
            adminUserCache = new AdminUserCache(SetsKt.emptySet(), SetsKt.emptySet());
        }
        return adminUserCache;
    }
}

