/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user.supplier;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.lighthouse.service.user.supplier.AdminUsernamesFinder;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/service/user/supplier/BitbucketAdminUsernamesFinder;", "Lcom/atlassian/lighthouse/service/user/supplier/AdminUsernamesFinder;", "permissionService", "Lcom/atlassian/bitbucket/permission/PermissionService;", "(Lcom/atlassian/bitbucket/permission/PermissionService;)V", "getAdminUsernames", "", "", "getSysAdminUsernames", "isSysAdminOrAdminUncached", "", "username", "searchByPermission", "permission", "Lcom/atlassian/bitbucket/permission/Permission;", "atlassian-lighthouse-core"})
public final class BitbucketAdminUsernamesFinder
implements AdminUsernamesFinder {
    @NotNull
    private final PermissionService permissionService;

    public BitbucketAdminUsernamesFinder(@NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter(permissionService, "permissionService");
        this.permissionService = permissionService;
    }

    @Override
    @NotNull
    public Set<String> getAdminUsernames() {
        return this.searchByPermission(Permission.ADMIN);
    }

    @Override
    @NotNull
    public Set<String> getSysAdminUsernames() {
        return this.searchByPermission(Permission.SYS_ADMIN);
    }

    @Override
    public boolean isSysAdminOrAdminUncached(@NotNull String username) {
        Intrinsics.checkNotNullParameter(username, "username");
        String string = "Not yet used in Bitbucket";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final Set<String> searchByPermission(Permission permission) {
        Set set = this.permissionService.getUsersWithPermission(permission);
        Intrinsics.checkNotNullExpressionValue(set, "getUsersWithPermission(...)");
        return set;
    }
}

