/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user.supplier;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.lighthouse.service.user.CrowdHelper;
import com.atlassian.lighthouse.service.user.supplier.AdminUsernamesFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\r0\r0\f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/lighthouse/service/user/supplier/ConfluenceAdminUsernamesFinder;", "Lcom/atlassian/lighthouse/service/user/supplier/AdminUsernamesFinder;", "crowdHelper", "Lcom/atlassian/lighthouse/service/user/CrowdHelper;", "permissionManager", "Lcom/atlassian/confluence/security/PermissionManager;", "spacePermissionManager", "Lcom/atlassian/confluence/security/SpacePermissionManager;", "userAccessor", "Lcom/atlassian/confluence/user/UserAccessor;", "(Lcom/atlassian/lighthouse/service/user/CrowdHelper;Lcom/atlassian/confluence/security/PermissionManager;Lcom/atlassian/confluence/security/SpacePermissionManager;Lcom/atlassian/confluence/user/UserAccessor;)V", "getAdminUsernames", "", "", "getSysAdminUsernames", "getUsersWithGlobalPermission", "spacePermission", "getUsersWithGroupPermission", "kotlin.jvm.PlatformType", "isSysAdminOrAdminUncached", "", "username", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nConfluenceAdminUsernamesFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfluenceAdminUsernamesFinder.kt\ncom/atlassian/lighthouse/service/user/supplier/ConfluenceAdminUsernamesFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n766#2:53\n857#2,2:54\n1360#2:56\n1446#2,5:57\n1549#2:62\n1620#2,3:63\n1549#2:66\n1620#2,3:67\n*S KotlinDebug\n*F\n+ 1 ConfluenceAdminUsernamesFinder.kt\ncom/atlassian/lighthouse/service/user/supplier/ConfluenceAdminUsernamesFinder\n*L\n37#1:53\n37#1:54,2\n38#1:56\n38#1:57,5\n39#1:62\n39#1:63,3\n48#1:66\n48#1:67,3\n*E\n"})
public final class ConfluenceAdminUsernamesFinder
implements AdminUsernamesFinder {
    @NotNull
    private final CrowdHelper crowdHelper;
    @NotNull
    private final PermissionManager permissionManager;
    @NotNull
    private final SpacePermissionManager spacePermissionManager;
    @NotNull
    private final UserAccessor userAccessor;

    public ConfluenceAdminUsernamesFinder(@NotNull CrowdHelper crowdHelper, @NotNull PermissionManager permissionManager, @NotNull SpacePermissionManager spacePermissionManager, @NotNull UserAccessor userAccessor) {
        Intrinsics.checkNotNullParameter(crowdHelper, "crowdHelper");
        Intrinsics.checkNotNullParameter(permissionManager, "permissionManager");
        Intrinsics.checkNotNullParameter(spacePermissionManager, "spacePermissionManager");
        Intrinsics.checkNotNullParameter(userAccessor, "userAccessor");
        this.crowdHelper = crowdHelper;
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.userAccessor = userAccessor;
    }

    @Override
    @NotNull
    public Set<String> getSysAdminUsernames() {
        return SetsKt.plus(this.getUsersWithGroupPermission("SYSTEMADMINISTRATOR"), (Iterable)this.getUsersWithGlobalPermission("SYSTEMADMINISTRATOR"));
    }

    @Override
    @NotNull
    public Set<String> getAdminUsernames() {
        return SetsKt.plus(this.getUsersWithGroupPermission("ADMINISTRATECONFLUENCE"), (Iterable)this.getUsersWithGlobalPermission("ADMINISTRATECONFLUENCE"));
    }

    @Override
    public boolean isSysAdminOrAdminUncached(@NotNull String username) {
        Intrinsics.checkNotNullParameter(username, "username");
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(username);
        if (confluenceUser != null) {
            ConfluenceUser user = confluenceUser;
            boolean bl = false;
            if (this.permissionManager.isConfluenceAdministrator(user) || this.permissionManager.isSystemAdministrator(user)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getUsersWithGroupPermission(String spacePermission) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.spacePermissionManager.getGroupsForPermissionType(spacePermission, null).keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String groupName = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(groupName);
            list$iv$iv = this.crowdHelper.searchAllUsersByGroupName(groupName);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (User)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getUsersWithGlobalPermission(String spacePermission) {
        Set<String> set;
        Set usernames = this.spacePermissionManager.getUsersForPermissionType(spacePermission, null).keySet();
        if (usernames.isEmpty()) {
            set = SetsKt.emptySet();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.crowdHelper.searchAllUsersByUsername(usernames);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                User user = (User)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            set = CollectionsKt.toSet((List)destination$iv$iv);
        }
        return set;
    }
}

