/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.usage.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditQuery;
import com.atlassian.audit.api.AuditSearchService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0003!\"#B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0002J\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0017J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00130\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService;", "", "auditSearchService", "Lcom/atlassian/audit/api/AuditSearchService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "currentInstantSupplier", "Ljava/util/function/Supplier;", "Ljava/time/Instant;", "(Lcom/atlassian/audit/api/AuditSearchService;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/sal/api/timezone/TimeZoneManager;Ljava/util/function/Supplier;)V", "timeZoneForCacheKeys", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/ZoneId;", "userAuditEventsCache", "Lcom/atlassian/cache/Cache;", "Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService$UserAuditEventsForMonthKey;", "kotlin.jvm.PlatformType", "", "getCurrentMonth", "Lkotlin/Pair;", "Ljava/time/Month;", "", "getSystemTimeZone", "getUserMonthAuditUsage", "userAuditId", "", "month", "year", "getUserMonthAuditUsageUncached", "invalidateIfTimeZoneChanged", "", "Companion", "UserAuditEventStatsCacheLoader", "UserAuditEventsForMonthKey", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nCachingAuditUsageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingAuditUsageService.kt\ncom/atlassian/lighthouse/usage/service/CachingAuditUsageService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,132:1\n1#2:133\n11#3:134\n10#3,3:135\n*S KotlinDebug\n*F\n+ 1 CachingAuditUsageService.kt\ncom/atlassian/lighthouse/usage/service/CachingAuditUsageService\n*L\n122#1:134\n122#1:135,3\n*E\n"})
public final class CachingAuditUsageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuditSearchService auditSearchService;
    @NotNull
    private final TimeZoneManager timeZoneManager;
    @NotNull
    private final Supplier<Instant> currentInstantSupplier;
    @NotNull
    private AtomicReference<ZoneId> timeZoneForCacheKeys;
    @NotNull
    private final Cache<UserAuditEventsForMonthKey, Long> userAuditEventsCache;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final CacheSettings CACHE_SETTINGS;

    public CachingAuditUsageService(@NotNull AuditSearchService auditSearchService, @NotNull CacheManager cacheManager, @NotNull TimeZoneManager timeZoneManager, @NotNull Supplier<Instant> currentInstantSupplier) {
        Intrinsics.checkNotNullParameter(auditSearchService, "auditSearchService");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        Intrinsics.checkNotNullParameter(timeZoneManager, "timeZoneManager");
        Intrinsics.checkNotNullParameter(currentInstantSupplier, "currentInstantSupplier");
        this.auditSearchService = auditSearchService;
        this.timeZoneManager = timeZoneManager;
        this.currentInstantSupplier = currentInstantSupplier;
        this.timeZoneForCacheKeys = new AtomicReference<ZoneId>(this.getSystemTimeZone());
        Cache cache = cacheManager.getCache("Security monitoring and alerts - audit usage cache", (CacheLoader)new UserAuditEventStatsCacheLoader(), CACHE_SETTINGS);
        Intrinsics.checkNotNullExpressionValue(cache, "getCache(...)");
        this.userAuditEventsCache = cache;
    }

    public /* synthetic */ CachingAuditUsageService(AuditSearchService auditSearchService, CacheManager cacheManager, TimeZoneManager timeZoneManager, Supplier supplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            supplier = CachingAuditUsageService::_init_$lambda$0;
        }
        this(auditSearchService, cacheManager, timeZoneManager, supplier);
    }

    public final long getUserMonthAuditUsage(@NotNull String userAuditId, @NotNull Month month, int year) {
        Intrinsics.checkNotNullParameter(userAuditId, "userAuditId");
        Intrinsics.checkNotNullParameter(month, "month");
        this.invalidateIfTimeZoneChanged();
        if (Intrinsics.areEqual(this.getCurrentMonth(), new Pair<Month, Integer>(month, year))) {
            return this.getUserMonthAuditUsageUncached(userAuditId, month, year);
        }
        Object object = this.userAuditEventsCache.get((Object)new UserAuditEventsForMonthKey(userAuditId, month, year));
        Intrinsics.checkNotNull(object);
        return ((Number)object).longValue();
    }

    private final long getUserMonthAuditUsageUncached(String userAuditId, Month month, int year) {
        ZonedDateTime startOfMonth = ZonedDateTime.of(year, month.getValue(), 1, 0, 0, 0, 0, this.timeZoneForCacheKeys.get());
        ZonedDateTime endOfMonth = startOfMonth.plusMonths(1L);
        String[] stringArray = new String[]{userAuditId};
        AuditQuery auditQuery = AuditQuery.builder().userIds(stringArray).from(startOfMonth.toInstant()).to(endOfMonth.toInstant()).build();
        return this.auditSearchService.count(auditQuery);
    }

    private final void invalidateIfTimeZoneChanged() {
        ZoneId newTimeZone = this.getSystemTimeZone();
        ZoneId oldTimeZone = this.timeZoneForCacheKeys.getAndSet(newTimeZone);
        if (!Intrinsics.areEqual(oldTimeZone, newTimeZone)) {
            Object $this$invalidateIfTimeZoneChanged_u24lambda_u241;
            logger.info("System timezone changed from {} to {}, clearing cache.", (Object)oldTimeZone, (Object)newTimeZone);
            Object object = this;
            try {
                $this$invalidateIfTimeZoneChanged_u24lambda_u241 = object;
                boolean bl = false;
                ((CachingAuditUsageService)$this$invalidateIfTimeZoneChanged_u24lambda_u241).userAuditEventsCache.removeAll();
                $this$invalidateIfTimeZoneChanged_u24lambda_u241 = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$invalidateIfTimeZoneChanged_u24lambda_u241 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = $this$invalidateIfTimeZoneChanged_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Object it = $this$invalidateIfTimeZoneChanged_u24lambda_u241 = throwable;
                boolean bl = false;
                if (it instanceof Error) {
                    throw it;
                }
            }
            Throwable throwable2 = Result.exceptionOrNull-impl(object);
            if (throwable2 != null) {
                Throwable e = throwable2;
                boolean bl = false;
                logger.error("Failed to remove all cache entries after system timezone change.", e);
            }
        }
    }

    private final Pair<Month, Integer> getCurrentMonth() {
        ZonedDateTime zonedDateTime = this.currentInstantSupplier.get().atZone(this.timeZoneForCacheKeys.get());
        return new Pair<Month, Integer>(zonedDateTime.getMonth(), zonedDateTime.getYear());
    }

    private final ZoneId getSystemTimeZone() {
        ZoneId zoneId = this.timeZoneManager.getDefaultTimeZone().toZoneId();
        Intrinsics.checkNotNullExpressionValue(zoneId, "toZoneId(...)");
        return zoneId;
    }

    private static final Instant _init_$lambda$0() {
        return Instant.now();
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        CachingAuditUsageService.logger = logger;
        CacheSettings cacheSettings = new CacheSettingsBuilder().local().expireAfterAccess(180L, TimeUnit.DAYS).maxEntries(10000).build();
        Intrinsics.checkNotNullExpressionValue(cacheSettings, "build(...)");
        CACHE_SETTINGS = cacheSettings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService$Companion;", "", "()V", "CACHE_SETTINGS", "Lcom/atlassian/cache/CacheSettings;", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService$UserAuditEventStatsCacheLoader;", "Lcom/atlassian/cache/CacheLoader;", "Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService$UserAuditEventsForMonthKey;", "", "(Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService;)V", "load", "key", "(Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService$UserAuditEventsForMonthKey;)Ljava/lang/Long;", "atlassian-lighthouse-core"})
    private final class UserAuditEventStatsCacheLoader
    implements CacheLoader<UserAuditEventsForMonthKey, Long> {
        @NotNull
        public Long load(@NotNull UserAuditEventsForMonthKey key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return CachingAuditUsageService.this.getUserMonthAuditUsageUncached(key.getUserAuditId(), key.getMonth(), key.getYear());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService$UserAuditEventsForMonthKey;", "Ljava/io/Serializable;", "userAuditId", "", "month", "Ljava/time/Month;", "year", "", "(Ljava/lang/String;Ljava/time/Month;I)V", "getMonth", "()Ljava/time/Month;", "getUserAuditId", "()Ljava/lang/String;", "getYear", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "atlassian-lighthouse-core"})
    @VisibleForTesting
    public static final class UserAuditEventsForMonthKey
    implements Serializable {
        @NotNull
        private final String userAuditId;
        @NotNull
        private final Month month;
        private final int year;

        public UserAuditEventsForMonthKey(@NotNull String userAuditId, @NotNull Month month, int year) {
            Intrinsics.checkNotNullParameter(userAuditId, "userAuditId");
            Intrinsics.checkNotNullParameter(month, "month");
            this.userAuditId = userAuditId;
            this.month = month;
            this.year = year;
        }

        @NotNull
        public final String getUserAuditId() {
            return this.userAuditId;
        }

        @NotNull
        public final Month getMonth() {
            return this.month;
        }

        public final int getYear() {
            return this.year;
        }

        @NotNull
        public final String component1() {
            return this.userAuditId;
        }

        @NotNull
        public final Month component2() {
            return this.month;
        }

        public final int component3() {
            return this.year;
        }

        @NotNull
        public final UserAuditEventsForMonthKey copy(@NotNull String userAuditId, @NotNull Month month, int year) {
            Intrinsics.checkNotNullParameter(userAuditId, "userAuditId");
            Intrinsics.checkNotNullParameter(month, "month");
            return new UserAuditEventsForMonthKey(userAuditId, month, year);
        }

        public static /* synthetic */ UserAuditEventsForMonthKey copy$default(UserAuditEventsForMonthKey userAuditEventsForMonthKey, String string, Month month, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = userAuditEventsForMonthKey.userAuditId;
            }
            if ((n2 & 2) != 0) {
                month = userAuditEventsForMonthKey.month;
            }
            if ((n2 & 4) != 0) {
                n = userAuditEventsForMonthKey.year;
            }
            return userAuditEventsForMonthKey.copy(string, month, n);
        }

        @NotNull
        public String toString() {
            return "UserAuditEventsForMonthKey(userAuditId=" + this.userAuditId + ", month=" + this.month + ", year=" + this.year + ")";
        }

        public int hashCode() {
            int result = this.userAuditId.hashCode();
            result = result * 31 + this.month.hashCode();
            result = result * 31 + Integer.hashCode(this.year);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserAuditEventsForMonthKey)) {
                return false;
            }
            UserAuditEventsForMonthKey userAuditEventsForMonthKey = (UserAuditEventsForMonthKey)other;
            if (!Intrinsics.areEqual(this.userAuditId, userAuditEventsForMonthKey.userAuditId)) {
                return false;
            }
            if (this.month != userAuditEventsForMonthKey.month) {
                return false;
            }
            return this.year == userAuditEventsForMonthKey.year;
        }
    }
}

